/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4cheri.srom;

import java.util.Date;
import org.dcm4che.data.Dataset;
import org.dcm4che.srom.Code;
import org.dcm4che.srom.Content;
import org.dcm4che.srom.KeyObject;
import org.dcm4che.srom.RefSOP;
import org.dcm4che.srom.Template;
import org.dcm4che.srom.WaveformContent;
import org.dcm4cheri.srom.CompositeContentImpl;

class WaveformContentImpl
extends CompositeContentImpl
implements WaveformContent {
    private static final int[] NULL_CHANNELNUMBER = new int[0];
    protected int[] channelNumbers;

    WaveformContentImpl(KeyObject keyObject, Date date, Template template, Code code, RefSOP refSOP, int[] nArray) {
        super(keyObject, date, template, code, refSOP);
        this.setChannelNumbers(nArray);
    }

    Content clone(KeyObject keyObject, boolean bl) {
        return new WaveformContentImpl(keyObject, this.getObservationDateTime(bl), this.template, this.name, this.refSOP, this.channelNumbers);
    }

    public String toString() {
        StringBuffer stringBuffer = this.prompt().append(this.refSOP);
        int n = 0;
        while (n < this.channelNumbers.length) {
            stringBuffer.append(",[").append(this.channelNumbers[0]).append("]");
            ++n;
        }
        return stringBuffer.append(')').toString();
    }

    public final Content.ValueType getValueType() {
        return Content.ValueType.WAVEFORM;
    }

    public final int[] getChannelNumbers() {
        return (int[])this.channelNumbers.clone();
    }

    public final void setChannelNumbers(int[] nArray) {
        if (nArray != null) {
            if ((nArray.length & 1) != 0) {
                throw new IllegalArgumentException("L=" + nArray.length);
            }
            this.channelNumbers = (int[])nArray.clone();
        } else {
            this.channelNumbers = NULL_CHANNELNUMBER;
        }
    }

    public void toDataset(Dataset dataset) {
        super.toDataset(dataset);
        if (this.channelNumbers.length != 0) {
            dataset.get(528793).getItem().putUS(4235440, this.channelNumbers);
        }
    }
}

