/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4cheri.media;

import java.io.File;
import java.io.IOException;
import javax.imageio.stream.FileImageInputStream;
import javax.imageio.stream.FileImageOutputStream;
import javax.imageio.stream.ImageInputStream;
import org.dcm4che.data.DcmEncodeParam;
import org.dcm4che.data.DcmObjectFactory;
import org.dcm4che.data.FileMetaInfo;
import org.dcm4che.media.DirBuilder;
import org.dcm4che.media.DirBuilderFactory;
import org.dcm4che.media.DirBuilderPref;
import org.dcm4che.media.DirReader;
import org.dcm4che.media.DirWriter;
import org.dcm4cheri.media.DirBuilderImpl;
import org.dcm4cheri.media.DirBuilderPrefImpl;
import org.dcm4cheri.media.DirReaderImpl;
import org.dcm4cheri.media.DirWriterImpl;

public final class DirBuilderFactoryImpl
extends DirBuilderFactory {
    public DirReader newDirReader(File file) throws IOException {
        return new DirReaderImpl(file, new FileImageInputStream(file)).initReader();
    }

    public DirReader newDirReader(ImageInputStream imageInputStream) throws IOException {
        return new DirReaderImpl(null, imageInputStream).initReader();
    }

    public DirWriter newDirWriter(File file, DcmEncodeParam dcmEncodeParam) throws IOException {
        return new DirWriterImpl(file, new FileImageOutputStream(file), dcmEncodeParam).initWriter();
    }

    public DirWriter newDirWriter(File file, FileMetaInfo fileMetaInfo, String string, File file2, String string2, DcmEncodeParam dcmEncodeParam) throws IOException {
        if (file.exists()) {
            file.delete();
        }
        return new DirWriterImpl(file, new FileImageOutputStream(file), dcmEncodeParam).initWriter(fileMetaInfo, string, file2, string2);
    }

    public DirWriter newDirWriter(File file, String string, String string2, File file2, String string3, DcmEncodeParam dcmEncodeParam) throws IOException {
        return this.newDirWriter(file, DcmObjectFactory.getInstance().newFileMetaInfo("1.2.840.10008.1.3.10", string, "1.2.840.10008.1.2.1"), string2, file2, string3, dcmEncodeParam);
    }

    public DirBuilder newDirBuilder(DirWriter dirWriter, DirBuilderPref dirBuilderPref) {
        return new DirBuilderImpl(dirWriter, dirBuilderPref);
    }

    public DirBuilderPref newDirBuilderPref() {
        return new DirBuilderPrefImpl();
    }
}

