/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4cheri.data;

import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.util.Date;
import org.dcm4che.data.DcmElement;
import org.dcm4che.data.DcmValueException;
import org.dcm4che.data.PersonName;
import org.dcm4cheri.data.Charsets;
import org.dcm4cheri.data.DateTimeFormatImpl;
import org.dcm4cheri.data.DcmElementImpl;
import org.dcm4cheri.data.PersonNameImpl;
import org.dcm4cheri.data.ValueElement;

abstract class StringElement
extends ValueElement {
    private static final Trim NO_TRIM = new Trim(){

        public String trim(String string) {
            return string;
        }
    };
    private static final Trim TRAIL_TRIM = new Trim(){

        public String trim(String string) {
            int n = string.length();
            while (n > 0) {
                char c = string.charAt(n - 1);
                if (c != '\u0000' && c != ' ') {
                    return string.substring(0, n);
                }
                --n;
            }
            return "";
        }
    };
    private static final Trim TOT_TRIM = new Trim(){

        public String trim(String string) {
            int n = string.length();
            while (n > 0) {
                if (string.charAt(n - 1) != ' ') {
                    int n2 = 0;
                    while (n2 < n) {
                        if (string.charAt(n2) != ' ') {
                            return string.substring(n2, n);
                        }
                        ++n2;
                    }
                }
                --n;
            }
            return "";
        }
    };
    private static final Check NO_CHECK = new Check(){

        public String check(String string) {
            return string;
        }
    };
    private final Trim trim;
    private static final Check LT_CHECK = new CheckImpl(10240, true);
    private static final Check ST_CHECK = new CheckImpl(1024, true);
    static final Check UT_CHECK = new CheckImpl(Integer.MAX_VALUE, true);
    private static final byte DELIM = 92;
    private static final Check LO_CHECK = new CheckImpl(64, false);
    private static final Check SH_CHECK = new CheckImpl(16, false);
    private static final Check AE_CHECK = new CheckImpl(16, false);
    private static final Check AS_CHECK = new Check(){

        public String check(String string) {
            if (string.length() == 4 && Character.isDigit(string.charAt(0)) && Character.isDigit(string.charAt(1)) && Character.isDigit(string.charAt(2))) {
                switch (string.charAt(3)) {
                    case 'D': 
                    case 'M': 
                    case 'W': 
                    case 'Y': {
                        return string;
                    }
                }
            }
            throw new IllegalArgumentException(string);
        }
    };
    static final Check CS_CHECK = new CheckImpl(16, false){

        protected boolean check(char c) {
            return c >= 'A' && c <= 'Z' || c >= '0' && c <= '9' || c == ' ' || c == '_';
        }
    };
    static final Check DS_CHECK = new Check(){

        public String check(String string) {
            if (string.length() > 16) {
                throw new IllegalArgumentException(string);
            }
            Float.parseFloat(string);
            return string;
        }
    };
    static final Check IS_CHECK = new Check(){

        public String check(String string) {
            if (string.length() > 12) {
                throw new IllegalArgumentException(string);
            }
            Integer.parseInt(string);
            return string;
        }
    };
    private static final int UID_DIGIT1 = 0;
    private static final int UID_DIGIT = 1;
    private static final int UID_DOT = 2;
    private static final int UID_ERROR = -1;
    private static final Check UI_CHECK = new CheckImpl(64, false){

        public String check(String string) {
            char[] cArray = string.toCharArray();
            if (cArray.length > this.maxLen) {
                throw new IllegalArgumentException(string);
            }
            int n = 0;
            int n2 = 0;
            while (n2 < cArray.length) {
                if ((n = StringElement.nextState(n, cArray[n2])) == -1) {
                    throw new IllegalArgumentException(string);
                }
                ++n2;
            }
            if (n == 0) {
                throw new IllegalArgumentException(string);
            }
            return string;
        }
    };
    private static final byte HYPHEN = 45;
    private static final DateTimeFormatImpl DTF = DateTimeFormatImpl.inst;

    private static boolean isDICOMControl(char c) {
        switch (c) {
            case '\n': 
            case '\f': 
            case '\r': 
            case '\u001b': {
                return true;
            }
        }
        return false;
    }

    private static ByteBuffer toByteBuffer(String string, Trim trim, Check check, Charset charset) {
        if (string == null || string.length() == 0) {
            return DcmElementImpl.EMPTY_VALUE;
        }
        try {
            return (charset != null ? charset : Charsets.ASCII).newEncoder().encode(CharBuffer.wrap(check.check(trim.trim(string))));
        }
        catch (CharacterCodingException characterCodingException) {
            throw new IllegalArgumentException(string);
        }
    }

    private static ByteBuffer toByteBuffer(ByteBuffer[] byteBufferArray, int n) {
        ByteBuffer byteBuffer = ByteBuffer.wrap(new byte[n]);
        byteBuffer.put(byteBufferArray[0]);
        int n2 = 1;
        while (n2 < byteBufferArray.length) {
            byteBuffer.put((byte)92);
            byteBuffer.put(byteBufferArray[n2]);
            ++n2;
        }
        return byteBuffer;
    }

    private static ByteBuffer toByteBuffer(String[] stringArray, Trim trim, Check check, Charset charset) {
        if (stringArray.length == 0) {
            return DcmElementImpl.EMPTY_VALUE;
        }
        if (stringArray.length == 1) {
            return StringElement.toByteBuffer(stringArray[0], trim, check, charset);
        }
        ByteBuffer[] byteBufferArray = new ByteBuffer[stringArray.length];
        int n = -1;
        int n2 = 0;
        while (n2 < stringArray.length) {
            byteBufferArray[n2] = StringElement.toByteBuffer(stringArray[n2], trim, check, charset);
            n += byteBufferArray[n2].limit() + 1;
            ++n2;
        }
        return StringElement.toByteBuffer(byteBufferArray, n);
    }

    StringElement(int n, ByteBuffer byteBuffer, Trim trim) {
        super(n, byteBuffer);
        this.trim = trim;
    }

    public String getString(int n, Charset charset) throws DcmValueException {
        if (n >= this.vm()) {
            return n == 0 ? "" : null;
        }
        try {
            return this.trim.trim((charset != null ? charset : Charsets.ASCII).newDecoder().decode(this.getByteBuffer(n)).toString());
        }
        catch (CharacterCodingException characterCodingException) {
            throw new DcmValueException(characterCodingException.getMessage(), characterCodingException);
        }
    }

    public String[] getStrings(Charset charset) throws DcmValueException {
        String[] stringArray = new String[this.vm()];
        int n = 0;
        while (n < stringArray.length) {
            stringArray[n] = this.getString(n, charset);
            ++n;
        }
        return stringArray;
    }

    public ByteBuffer getByteBuffer(int n) {
        this.checkIndex(n);
        return (ByteBuffer)this.data.rewind();
    }

    static DcmElement createLT(int n, ByteBuffer byteBuffer) {
        return new LT(n, byteBuffer);
    }

    static DcmElement createLT(int n) {
        return new LT(n, DcmElementImpl.EMPTY_VALUE);
    }

    static DcmElement createLT(int n, String string, Charset charset) {
        return new LT(n, StringElement.toByteBuffer(string, TRAIL_TRIM, LT_CHECK, charset));
    }

    static DcmElement createLT(int n, String[] stringArray, Charset charset) {
        return new LT(n, StringElement.toByteBuffer(stringArray, TRAIL_TRIM, LT_CHECK, charset));
    }

    static DcmElement createST(int n, ByteBuffer byteBuffer) {
        return new ST(n, byteBuffer);
    }

    static DcmElement createST(int n) {
        return new ST(n, DcmElementImpl.EMPTY_VALUE);
    }

    static DcmElement createST(int n, String string, Charset charset) {
        return new ST(n, StringElement.toByteBuffer(string, TRAIL_TRIM, ST_CHECK, charset));
    }

    static DcmElement createST(int n, String[] stringArray, Charset charset) {
        return new ST(n, StringElement.toByteBuffer(stringArray, TRAIL_TRIM, ST_CHECK, charset));
    }

    static DcmElement createUT(int n, ByteBuffer byteBuffer) {
        return new UT(n, byteBuffer);
    }

    static DcmElement createUT(int n) {
        return new UT(n, DcmElementImpl.EMPTY_VALUE);
    }

    static DcmElement createUT(int n, String string, Charset charset) {
        return new UT(n, StringElement.toByteBuffer(string, TRAIL_TRIM, UT_CHECK, charset));
    }

    static DcmElement createUT(int n, String[] stringArray, Charset charset) {
        return new UT(n, StringElement.toByteBuffer(stringArray, TRAIL_TRIM, UT_CHECK, charset));
    }

    static DcmElement createLO(int n, ByteBuffer byteBuffer) {
        return new LO(n, byteBuffer);
    }

    static DcmElement createLO(int n) {
        return new LO(n, DcmElementImpl.EMPTY_VALUE);
    }

    static DcmElement createLO(int n, String string, Charset charset) {
        return new LO(n, StringElement.toByteBuffer(string, TOT_TRIM, LO_CHECK, charset));
    }

    static DcmElement createLO(int n, String[] stringArray, Charset charset) {
        return new LO(n, StringElement.toByteBuffer(stringArray, TOT_TRIM, LO_CHECK, charset));
    }

    static DcmElement createPN(int n, ByteBuffer byteBuffer) {
        return new PN(n, byteBuffer);
    }

    static DcmElement createPN(int n) {
        return new PN(n, DcmElementImpl.EMPTY_VALUE);
    }

    static DcmElement createPN(int n, PersonName personName, Charset charset) {
        return new PN(n, StringElement.toByteBuffer(personName.toString(), NO_TRIM, NO_CHECK, charset));
    }

    static DcmElement createPN(int n, PersonName[] personNameArray, Charset charset) {
        String[] stringArray = new String[personNameArray.length];
        int n2 = 0;
        while (n2 < personNameArray.length) {
            stringArray[n2] = personNameArray[n2].toString();
            ++n2;
        }
        return new PN(n, StringElement.toByteBuffer(stringArray, NO_TRIM, NO_CHECK, charset));
    }

    static DcmElement createSH(int n, ByteBuffer byteBuffer) {
        return new SH(n, byteBuffer);
    }

    static DcmElement createSH(int n) {
        return new SH(n, DcmElementImpl.EMPTY_VALUE);
    }

    static DcmElement createSH(int n, String string, Charset charset) {
        return new SH(n, StringElement.toByteBuffer(string, TOT_TRIM, SH_CHECK, charset));
    }

    static DcmElement createSH(int n, String[] stringArray, Charset charset) {
        return new SH(n, StringElement.toByteBuffer(stringArray, TOT_TRIM, SH_CHECK, charset));
    }

    static DcmElement createAE(int n, ByteBuffer byteBuffer) {
        return new AE(n, byteBuffer);
    }

    static DcmElement createAE(int n) {
        return new AE(n, DcmElementImpl.EMPTY_VALUE);
    }

    static DcmElement createAE(int n, String string) {
        return new AE(n, StringElement.toByteBuffer(string, TOT_TRIM, AE_CHECK, null));
    }

    static DcmElement createAE(int n, String[] stringArray) {
        return new AE(n, StringElement.toByteBuffer(stringArray, TOT_TRIM, AE_CHECK, null));
    }

    static DcmElement createAS(int n, ByteBuffer byteBuffer) {
        return new AS(n, byteBuffer);
    }

    static DcmElement createAS(int n) {
        return new AS(n, DcmElementImpl.EMPTY_VALUE);
    }

    static DcmElement createAS(int n, String string) {
        return new AS(n, StringElement.toByteBuffer(string, NO_TRIM, AS_CHECK, null));
    }

    static DcmElement createAS(int n, String[] stringArray) {
        return new AS(n, StringElement.toByteBuffer(stringArray, NO_TRIM, AS_CHECK, null));
    }

    static DcmElement createCS(int n, ByteBuffer byteBuffer) {
        return new CS(n, byteBuffer);
    }

    static DcmElement createCS(int n) {
        return new CS(n, DcmElementImpl.EMPTY_VALUE);
    }

    static DcmElement createCS(int n, String string) {
        return new CS(n, StringElement.toByteBuffer(string, TOT_TRIM, CS_CHECK, null));
    }

    static DcmElement createCS(int n, String[] stringArray) {
        return new CS(n, StringElement.toByteBuffer(stringArray, TOT_TRIM, CS_CHECK, null));
    }

    static DcmElement createDS(int n, ByteBuffer byteBuffer) {
        return new DS(n, byteBuffer);
    }

    static DcmElement createDS(int n) {
        return new DS(n, DcmElementImpl.EMPTY_VALUE);
    }

    static DcmElement createDS(int n, float f) {
        return new DS(n, StringElement.toByteBuffer(String.valueOf(f), NO_TRIM, NO_CHECK, null));
    }

    static DcmElement createDS(int n, float[] fArray) {
        String[] stringArray = new String[fArray.length];
        int n2 = 0;
        while (n2 < fArray.length) {
            stringArray[n2] = String.valueOf(fArray[n2]);
            ++n2;
        }
        return new DS(n, StringElement.toByteBuffer(stringArray, NO_TRIM, NO_CHECK, null));
    }

    static DcmElement createDS(int n, String string) {
        return new DS(n, StringElement.toByteBuffer(string, TOT_TRIM, DS_CHECK, null));
    }

    static DcmElement createDS(int n, String[] stringArray) {
        return new DS(n, StringElement.toByteBuffer(stringArray, TOT_TRIM, DS_CHECK, null));
    }

    static DcmElement createIS(int n, ByteBuffer byteBuffer) {
        return new IS(n, byteBuffer);
    }

    static DcmElement createIS(int n) {
        return new IS(n, DcmElementImpl.EMPTY_VALUE);
    }

    static DcmElement createIS(int n, int n2) {
        return new IS(n, StringElement.toByteBuffer(String.valueOf(n2), NO_TRIM, NO_CHECK, null));
    }

    static DcmElement createIS(int n, int[] nArray) {
        String[] stringArray = new String[nArray.length];
        int n2 = 0;
        while (n2 < nArray.length) {
            stringArray[n2] = String.valueOf(nArray[n2]);
            ++n2;
        }
        return new IS(n, StringElement.toByteBuffer(stringArray, NO_TRIM, NO_CHECK, null));
    }

    static DcmElement createIS(int n, String string) {
        return new IS(n, StringElement.toByteBuffer(string, TOT_TRIM, IS_CHECK, null));
    }

    static DcmElement createIS(int n, String[] stringArray) {
        return new IS(n, StringElement.toByteBuffer(stringArray, TOT_TRIM, IS_CHECK, null));
    }

    private static int nextState(int n, char c) {
        switch (n) {
            case 0: {
                if (c > '0' && c <= '9') {
                    return 1;
                }
                if (c == '0') {
                    return 2;
                }
                return -1;
            }
            case 1: {
                if (c >= '0' && c <= '9') {
                    return 1;
                }
            }
            case 2: {
                if (c != '.') break;
                return 0;
            }
        }
        return -1;
    }

    static DcmElement createUI(int n, ByteBuffer byteBuffer) {
        return new UI(n, byteBuffer);
    }

    static DcmElement createUI(int n) {
        return new UI(n, DcmElementImpl.EMPTY_VALUE);
    }

    static DcmElement createUI(int n, String string) {
        return new UI(n, StringElement.toByteBuffer(string, NO_TRIM, UI_CHECK, null));
    }

    static DcmElement createUI(int n, String[] stringArray) {
        return new UI(n, StringElement.toByteBuffer(stringArray, NO_TRIM, UI_CHECK, null));
    }

    static DcmElement createDA(int n, ByteBuffer byteBuffer) {
        return new DA(n, byteBuffer);
    }

    static DcmElement createDA(int n) {
        return new DA(n, DcmElementImpl.EMPTY_VALUE);
    }

    static DcmElement createDA(int n, Date date) {
        return new DA(n, StringElement.toByteBuffer(DTF.formatDate(date), NO_TRIM, NO_CHECK, null));
    }

    static DcmElement createDA(int n, Date[] dateArray) {
        String[] stringArray = new String[dateArray.length];
        int n2 = 0;
        while (n2 < dateArray.length) {
            stringArray[n2] = DTF.formatDate(dateArray[n2]);
            ++n2;
        }
        return new DA(n, StringElement.toByteBuffer(stringArray, NO_TRIM, NO_CHECK, null));
    }

    static DcmElement createDA(int n, Date date, Date date2) {
        return new DA(n, StringElement.toByteBuffer(DTF.formatDateRange(date, date2), NO_TRIM, NO_CHECK, null));
    }

    static DcmElement createDA(int n, String string) {
        if (string.indexOf(45) != -1) {
            DTF.parseDateRange(string);
        } else {
            DTF.parseDate(string);
        }
        return new DA(n, StringElement.toByteBuffer(string, NO_TRIM, NO_CHECK, null));
    }

    static DcmElement createDA(int n, String[] stringArray) {
        int n2 = 0;
        while (n2 < stringArray.length) {
            DTF.parseDate(stringArray[n2]);
            ++n2;
        }
        return new DA(n, StringElement.toByteBuffer(stringArray, NO_TRIM, NO_CHECK, null));
    }

    static DcmElement createDT(int n, ByteBuffer byteBuffer) {
        return new DT(n, byteBuffer);
    }

    static DcmElement createDT(int n) {
        return new DT(n, DcmElementImpl.EMPTY_VALUE);
    }

    static DcmElement createDT(int n, Date date) {
        return new DT(n, StringElement.toByteBuffer(DTF.formatDateTime(date), NO_TRIM, NO_CHECK, null));
    }

    static DcmElement createDT(int n, Date[] dateArray) {
        String[] stringArray = new String[dateArray.length];
        int n2 = 0;
        while (n2 < dateArray.length) {
            stringArray[n2] = DTF.formatDateTime(dateArray[n2]);
            ++n2;
        }
        return new DT(n, StringElement.toByteBuffer(stringArray, NO_TRIM, NO_CHECK, null));
    }

    static DcmElement createDT(int n, Date date, Date date2) {
        return new DT(n, StringElement.toByteBuffer(DTF.formatDateTimeRange(date, date2), NO_TRIM, NO_CHECK, null));
    }

    static DcmElement createDT(int n, String string) {
        if (string.indexOf(45) != -1) {
            DTF.parseDateTimeRange(string);
        } else {
            DTF.parseDateTime(string);
        }
        return new DT(n, StringElement.toByteBuffer(string, NO_TRIM, NO_CHECK, null));
    }

    static DcmElement createDT(int n, String[] stringArray) {
        int n2 = 0;
        while (n2 < stringArray.length) {
            DTF.parseDateTime(stringArray[n2]);
            ++n2;
        }
        return new DT(n, StringElement.toByteBuffer(stringArray, NO_TRIM, NO_CHECK, null));
    }

    static DcmElement createTM(int n, ByteBuffer byteBuffer) {
        return new TM(n, byteBuffer);
    }

    static DcmElement createTM(int n) {
        return new TM(n, DcmElementImpl.EMPTY_VALUE);
    }

    static DcmElement createTM(int n, Date date) {
        return new TM(n, StringElement.toByteBuffer(DTF.formatTime(date), NO_TRIM, NO_CHECK, null));
    }

    static DcmElement createTM(int n, Date[] dateArray) {
        String[] stringArray = new String[dateArray.length];
        int n2 = 0;
        while (n2 < dateArray.length) {
            stringArray[n2] = DTF.formatTime(dateArray[n2]);
            ++n2;
        }
        return new TM(n, StringElement.toByteBuffer(stringArray, NO_TRIM, NO_CHECK, null));
    }

    static DcmElement createTM(int n, Date date, Date date2) {
        return new TM(n, StringElement.toByteBuffer(DTF.formatTimeRange(date, date2), NO_TRIM, NO_CHECK, null));
    }

    static DcmElement createTM(int n, String string) {
        if (string.indexOf(45) != -1) {
            DTF.parseTimeRange(string);
        } else {
            DTF.parseTime(string);
        }
        return new TM(n, StringElement.toByteBuffer(string, NO_TRIM, NO_CHECK, null));
    }

    static DcmElement createTM(int n, String[] stringArray) {
        int n2 = 0;
        while (n2 < stringArray.length) {
            DTF.parseTime(stringArray[n2]);
            ++n2;
        }
        return new TM(n, StringElement.toByteBuffer(stringArray, NO_TRIM, NO_CHECK, null));
    }

    private static final class TM
    extends DateString {
        TM(int n, ByteBuffer byteBuffer) {
            super(n, byteBuffer, TRAIL_TRIM);
        }

        public final int vr() {
            return 21581;
        }

        public final Date getDate(int n) throws DcmValueException {
            return DTF.parseTime(this.getString(n, null));
        }

        public final Date[] getDates() throws DcmValueException {
            Date[] dateArray = new Date[this.vm()];
            int n = 0;
            while (n < dateArray.length) {
                dateArray[n] = DTF.parseTime(this.getString(n, null));
                ++n;
            }
            return dateArray;
        }

        public final Date[] getDateRange(int n) throws DcmValueException {
            return DTF.parseTimeRange(this.getString(n, null));
        }
    }

    private static final class DT
    extends DateString {
        DT(int n, ByteBuffer byteBuffer) {
            super(n, byteBuffer, TRAIL_TRIM);
        }

        public final int vr() {
            return 17492;
        }

        public final Date getDate(int n) throws DcmValueException {
            return DTF.parseDateTime(this.getString(n, null));
        }

        public final Date[] getDates() throws DcmValueException {
            Date[] dateArray = new Date[this.vm()];
            int n = 0;
            while (n < dateArray.length) {
                dateArray[n] = DTF.parseDateTime(this.getString(n, null));
                ++n;
            }
            return dateArray;
        }

        public final Date[] getDateRange(int n) throws DcmValueException {
            return DTF.parseDateTimeRange(this.getString(n, null));
        }
    }

    private static final class DA
    extends DateString {
        DA(int n, ByteBuffer byteBuffer) {
            super(n, byteBuffer, NO_TRIM);
        }

        public final int vr() {
            return 17473;
        }

        public final Date getDate(int n) throws DcmValueException {
            return DTF.parseDate(this.getString(n, null));
        }

        public final Date[] getDates() throws DcmValueException {
            Date[] dateArray = new Date[this.vm()];
            int n = 0;
            while (n < dateArray.length) {
                dateArray[n] = DTF.parseDate(this.getString(n, null));
                ++n;
            }
            return dateArray;
        }

        public final Date[] getDateRange(int n) throws DcmValueException {
            return DTF.parseDateRange(this.getString(n, null));
        }
    }

    private static abstract class DateString
    extends AsciiMultiStringElement {
        DateString(int n, ByteBuffer byteBuffer, Trim trim) {
            super(n, byteBuffer, trim);
        }

        public final boolean isDataRange() {
            int n = 0;
            int n2 = this.data.limit();
            while (n < n2) {
                if (this.data.get(n) == 45) {
                    return true;
                }
                ++n;
            }
            return false;
        }
    }

    private static final class UI
    extends AsciiMultiStringElement {
        UI(int n, ByteBuffer byteBuffer) {
            super(n, byteBuffer, TRAIL_TRIM);
        }

        public final int vr() {
            return 21833;
        }
    }

    private static final class IS
    extends AsciiMultiStringElement {
        IS(int n, ByteBuffer byteBuffer) {
            super(n, byteBuffer, TOT_TRIM);
        }

        public final int vr() {
            return 18771;
        }

        public final int getInt(int n) throws DcmValueException {
            String string = this.getString(n, null);
            try {
                return Integer.parseInt(string);
            }
            catch (NumberFormatException numberFormatException) {
                throw new DcmValueException(string, numberFormatException);
            }
        }

        public final int[] getInts() throws DcmValueException {
            int[] nArray = new int[this.vm()];
            int n = 0;
            while (n < nArray.length) {
                nArray[n] = this.getInt(n);
                ++n;
            }
            return nArray;
        }
    }

    private static final class DS
    extends AsciiMultiStringElement {
        DS(int n, ByteBuffer byteBuffer) {
            super(n, byteBuffer, TOT_TRIM);
        }

        public final int vr() {
            return 17491;
        }

        public final float getFloat(int n) throws DcmValueException {
            return Float.parseFloat(this.getString(n, null));
        }

        public final float[] getFloats() throws DcmValueException {
            float[] fArray = new float[this.vm()];
            int n = 0;
            while (n < fArray.length) {
                fArray[n] = this.getFloat(n);
                ++n;
            }
            return fArray;
        }
    }

    private static final class CS
    extends AsciiMultiStringElement {
        CS(int n, ByteBuffer byteBuffer) {
            super(n, byteBuffer, TOT_TRIM);
        }

        public final int vr() {
            return 17235;
        }
    }

    private static final class AS
    extends AsciiMultiStringElement {
        AS(int n, ByteBuffer byteBuffer) {
            super(n, byteBuffer, NO_TRIM);
        }

        public final int vr() {
            return 16723;
        }
    }

    private static final class AE
    extends AsciiMultiStringElement {
        AE(int n, ByteBuffer byteBuffer) {
            super(n, byteBuffer, TOT_TRIM);
        }

        public final int vr() {
            return 16709;
        }
    }

    private static abstract class AsciiMultiStringElement
    extends MultiStringElement {
        AsciiMultiStringElement(int n, ByteBuffer byteBuffer, Trim trim) {
            super(n, byteBuffer, trim);
        }

        public final String getString(int n, Charset charset) throws DcmValueException {
            return super.getString(n, null);
        }
    }

    private static final class SH
    extends MultiStringElement {
        SH(int n, ByteBuffer byteBuffer) {
            super(n, byteBuffer, TOT_TRIM);
        }

        public final int vr() {
            return 21320;
        }
    }

    private static final class PN
    extends MultiStringElement {
        PN(int n, ByteBuffer byteBuffer) {
            super(n, byteBuffer, TRAIL_TRIM);
        }

        public final int vr() {
            return 20558;
        }

        public final PersonName getPersonName(int n, Charset charset) throws DcmValueException {
            return new PersonNameImpl(this.getString(n, charset));
        }
    }

    private static final class LO
    extends MultiStringElement {
        LO(int n, ByteBuffer byteBuffer) {
            super(n, byteBuffer, TOT_TRIM);
        }

        public final int vr() {
            return 19535;
        }
    }

    private static abstract class MultiStringElement
    extends StringElement {
        private int[] delimPos = null;

        MultiStringElement(int n, ByteBuffer byteBuffer, Trim trim) {
            super(n, byteBuffer, trim);
        }

        public final int vm() {
            if (this.delimPos != null) {
                return this.delimPos.length - 1;
            }
            byte[] byArray = this.data.array();
            if (byArray.length == 0) {
                return 0;
            }
            int n = 1;
            int n2 = 0;
            while (n2 < byArray.length) {
                if (byArray[n2] == 92) {
                    ++n;
                }
                ++n2;
            }
            this.delimPos = new int[n + 1];
            this.delimPos[0] = -1;
            this.delimPos[n] = byArray.length;
            int n3 = 0;
            int n4 = 0;
            while (n3 < byArray.length) {
                if (byArray[n3] == 92) {
                    this.delimPos[++n4] = n3;
                }
                ++n3;
            }
            return n;
        }

        public ByteBuffer getByteBuffer(int n) {
            this.checkIndex(n);
            return this.vm() == 1 ? (ByteBuffer)this.data.rewind() : ByteBuffer.wrap(this.data.array(), this.delimPos[n] + 1, this.delimPos[n + 1] - this.delimPos[n] - 1);
        }
    }

    private static final class UT
    extends StringElement {
        UT(int n, ByteBuffer byteBuffer) {
            super(n, byteBuffer, TRAIL_TRIM);
        }

        public final int vr() {
            return 21844;
        }
    }

    private static final class ST
    extends StringElement {
        ST(int n, ByteBuffer byteBuffer) {
            super(n, byteBuffer, TRAIL_TRIM);
        }

        public final int vr() {
            return 21332;
        }
    }

    private static final class LT
    extends StringElement {
        LT(int n, ByteBuffer byteBuffer) {
            super(n, byteBuffer, TRAIL_TRIM);
        }

        public final int vr() {
            return 19540;
        }
    }

    private static class CheckImpl
    implements Check {
        protected final int maxLen;
        protected final boolean text;

        CheckImpl(int n, boolean bl) {
            this.maxLen = n;
            this.text = bl;
        }

        public String check(String string) {
            char[] cArray = string.toCharArray();
            if (cArray.length > this.maxLen) {
                throw new IllegalArgumentException(string);
            }
            int n = 0;
            while (n < cArray.length) {
                if (!this.check(cArray[n])) {
                    throw new IllegalArgumentException(string);
                }
                ++n;
            }
            return string;
        }

        protected boolean check(char c) {
            return Character.isISOControl(c) ? this.text && StringElement.isDICOMControl(c) : this.text || c != '\\';
        }
    }

    private static interface Check {
        public String check(String var1);
    }

    private static interface Trim {
        public String trim(String var1);
    }
}

