/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4cheri.srom;

import java.util.Date;
import org.dcm4che.data.Dataset;
import org.dcm4che.data.DcmValueException;
import org.dcm4che.srom.Code;
import org.dcm4che.srom.Verification;
import org.dcm4cheri.srom.CodeImpl;

class VerificationImpl
implements Verification {
    static final Verification[] EMPTY_ARRAY = new Verification[0];
    private final long time;
    private final String observerName;
    private final String observerOrg;
    private final Code observerCode;

    public VerificationImpl(Date date, String string, String string2, Code code) {
        this.time = date.getTime();
        this.observerName = string;
        if (this.observerName.length() == 0) {
            throw new IllegalArgumentException();
        }
        this.observerOrg = string2;
        this.observerCode = code;
    }

    public VerificationImpl(Dataset dataset) throws DcmValueException {
        this(dataset.getDate(4235312), dataset.getString(4235381), dataset.getString(4235303), CodeImpl.newCode(dataset.getItem(4235400)));
    }

    public String getVerifyingObserverName() {
        return this.observerName;
    }

    public Code getVerifyingObserverCode() {
        return this.observerCode;
    }

    public String getVerifyingOrganization() {
        return this.observerOrg;
    }

    public Date getVerificationDateTime() {
        return new Date(this.time);
    }

    public String toString() {
        return "Verification[" + this.getVerificationDateTime() + "/" + this.observerName + "]";
    }

    public int compareTo(Object object) {
        VerificationImpl verificationImpl = (VerificationImpl)object;
        return (int)(verificationImpl.time - this.time);
    }

    public void toDataset(Dataset dataset) {
        dataset.putDT(4235312, new Date(this.time));
        dataset.putPN(4235381, this.observerName);
        dataset.putLO(4235303, this.observerOrg);
        this.observerCode.toDataset(dataset.putSQ(4235400).addNewItem());
    }
}

