/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4cheri.srom;

import java.util.Date;
import org.dcm4che.data.Dataset;
import org.dcm4che.data.DcmElement;
import org.dcm4che.data.DcmValueException;
import org.dcm4che.srom.Code;
import org.dcm4che.srom.Content;
import org.dcm4che.srom.KeyObject;
import org.dcm4che.srom.TCoordContent;
import org.dcm4che.srom.Template;
import org.dcm4cheri.srom.NamedContentImpl;

abstract class TCoordContentImpl
extends NamedContentImpl
implements TCoordContent {
    protected final TCoordContent.Positions positions;

    static TCoordContent.Positions newPositions(Dataset dataset) throws DcmValueException {
        DcmElement dcmElement = dataset.get(4235570);
        if (dcmElement != null) {
            return new SamplePositions(dcmElement.getInts());
        }
        dcmElement = dataset.get(4235576);
        if (dcmElement != null) {
            return new RelativePositions(dcmElement.getFloats());
        }
        dcmElement = dataset.get(4235578);
        if (dcmElement != null) {
            return new AbsolutePositions(dcmElement.getDates());
        }
        throw new IllegalArgumentException("Missing Positions");
    }

    TCoordContentImpl(KeyObject keyObject, Date date, Template template, Code code, TCoordContent.Positions positions) {
        super(keyObject, date, template, code);
        this.positions = positions;
    }

    public final Content.ValueType getValueType() {
        return Content.ValueType.TCOORD;
    }

    public final TCoordContent.Positions getPositions() {
        return this.positions;
    }

    public void toDataset(Dataset dataset) {
        super.toDataset(dataset);
        dataset.putCS(4235568, this.getRangeType());
        this.positions.toDataset(dataset);
    }

    static class AbsolutePositions
    implements TCoordContent.Positions.Absolute {
        private final long[] dateTimes;

        AbsolutePositions(Date[] dateArray) {
            this.dateTimes = new long[dateArray.length];
            int n = 0;
            while (n < dateArray.length) {
                this.dateTimes[n] = dateArray[n].getTime();
                ++n;
            }
        }

        public int size() {
            return this.dateTimes.length;
        }

        public Date[] getDateTimes() {
            Date[] dateArray = new Date[this.dateTimes.length];
            int n = 0;
            while (n < this.dateTimes.length) {
                dateArray[n] = new Date(this.dateTimes[n]);
                ++n;
            }
            return dateArray;
        }

        public String toString() {
            return "DateTime[" + this.size() + "]";
        }

        public void toDataset(Dataset dataset) {
            dataset.putDT(4235578, this.getDateTimes());
        }
    }

    static class RelativePositions
    implements TCoordContent.Positions.Relative {
        private final float[] offsets;

        RelativePositions(float[] fArray) {
            this.offsets = (float[])fArray.clone();
        }

        public int size() {
            return this.offsets.length;
        }

        public float[] getOffsets() {
            return (float[])this.offsets.clone();
        }

        public String toString() {
            return "Offset[" + this.size() + "]";
        }

        public void toDataset(Dataset dataset) {
            dataset.putDS(4235576, this.offsets);
        }
    }

    static class SamplePositions
    implements TCoordContent.Positions.Sample {
        private final int[] indexes;

        SamplePositions(int[] nArray) {
            this.indexes = (int[])nArray.clone();
        }

        public int size() {
            return this.indexes.length;
        }

        public int[] getIndexes() {
            return (int[])this.indexes.clone();
        }

        public String toString() {
            return "Sample[" + this.size() + "]";
        }

        public void toDataset(Dataset dataset) {
            dataset.putUL(4235570, this.indexes);
        }
    }

    static class End
    extends TCoordContentImpl
    implements TCoordContent.End {
        End(KeyObject keyObject, Date date, Template template, Code code, TCoordContent.Positions positions) {
            super(keyObject, date, template, code, positions);
            if (positions.size() != 1) {
                throw new IllegalArgumentException("" + positions);
            }
        }

        Content clone(KeyObject keyObject, boolean bl) {
            return new End(keyObject, this.getObservationDateTime(bl), this.template, this.name, this.positions);
        }

        public String getRangeType() {
            return "END";
        }
    }

    static class Begin
    extends TCoordContentImpl
    implements TCoordContent.Begin {
        Begin(KeyObject keyObject, Date date, Template template, Code code, TCoordContent.Positions positions) {
            super(keyObject, date, template, code, positions);
            if (positions.size() != 1) {
                throw new IllegalArgumentException("" + positions);
            }
        }

        Content clone(KeyObject keyObject, boolean bl) {
            return new Begin(keyObject, this.getObservationDateTime(bl), this.template, this.name, this.positions);
        }

        public String getRangeType() {
            return "BEGIN";
        }
    }

    static class MultiSegment
    extends TCoordContentImpl
    implements TCoordContent.MultiSegment {
        MultiSegment(KeyObject keyObject, Date date, Template template, Code code, TCoordContent.Positions positions) {
            super(keyObject, date, template, code, positions);
            if ((positions.size() & 1) != 0) {
                throw new IllegalArgumentException("" + positions);
            }
        }

        Content clone(KeyObject keyObject, boolean bl) {
            return new MultiSegment(keyObject, this.getObservationDateTime(bl), this.template, this.name, this.positions);
        }

        public String getRangeType() {
            return "MULTISEGMENT";
        }
    }

    static class Segment
    extends TCoordContentImpl
    implements TCoordContent.Segment {
        Segment(KeyObject keyObject, Date date, Template template, Code code, TCoordContent.Positions positions) {
            super(keyObject, date, template, code, positions);
            if (positions.size() != 2) {
                throw new IllegalArgumentException("" + positions);
            }
        }

        Content clone(KeyObject keyObject, boolean bl) {
            return new Segment(keyObject, this.getObservationDateTime(bl), this.template, this.name, this.positions);
        }

        public String getRangeType() {
            return "SEGMENT";
        }
    }

    static class MultiPoint
    extends TCoordContentImpl
    implements TCoordContent.MultiPoint {
        MultiPoint(KeyObject keyObject, Date date, Template template, Code code, TCoordContent.Positions positions) {
            super(keyObject, date, template, code, positions);
        }

        Content clone(KeyObject keyObject, boolean bl) {
            return new MultiPoint(keyObject, this.getObservationDateTime(bl), this.template, this.name, this.positions);
        }

        public String getRangeType() {
            return "MULTIPOINT";
        }
    }

    static class Point
    extends TCoordContentImpl
    implements TCoordContent.Point {
        Point(KeyObject keyObject, Date date, Template template, Code code, TCoordContent.Positions positions) {
            super(keyObject, date, template, code, positions);
            if (positions.size() != 1) {
                throw new IllegalArgumentException("" + positions);
            }
        }

        Content clone(KeyObject keyObject, boolean bl) {
            return new Point(keyObject, this.getObservationDateTime(bl), this.template, this.name, this.positions);
        }

        public String getRangeType() {
            return "POINT";
        }
    }
}

