/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4cheri.srom;

import java.util.Date;
import java.util.NoSuchElementException;
import org.dcm4che.data.Dataset;
import org.dcm4che.srom.Code;
import org.dcm4che.srom.Content;
import org.dcm4che.srom.KeyObject;
import org.dcm4che.srom.ReferencedContent;
import org.dcm4che.srom.Template;
import org.dcm4cheri.srom.ContentImpl;

class ReferencedContentImpl
extends ContentImpl
implements ReferencedContent {
    protected Content refContent;
    protected int[] refContentID;

    ReferencedContentImpl(KeyObject keyObject, Content content) {
        super(keyObject);
        if (content.getOwnerDocument() != keyObject) {
            throw new IllegalArgumentException();
        }
        if (content.getParent() == null) {
            throw new IllegalArgumentException();
        }
        if (content instanceof ReferencedContent) {
            throw new IllegalArgumentException();
        }
        this.refContent = content;
    }

    ReferencedContentImpl(KeyObject keyObject, int[] nArray) {
        super(keyObject);
        this.refContentID = nArray;
        this.refContent = keyObject.getContent(nArray);
    }

    Content clone(KeyObject keyObject, boolean bl) {
        if (keyObject != this.owner) {
            throw new IllegalArgumentException("" + keyObject);
        }
        return new ReferencedContentImpl(keyObject, this.getRefContent().getID());
    }

    public String toString() {
        StringBuffer stringBuffer = this.prompt().append(this.refContent != null ? "=>" : "->");
        ContentImpl.appendID(stringBuffer, this.refContent != null ? this.refContent.getID() : this.refContentID);
        return stringBuffer.toString();
    }

    public void toDataset(Dataset dataset) {
        dataset.putCS(4235280, this.relation.toString());
        dataset.putUL(4250483, this.getRefContent().getID());
    }

    public Content getRefContent() {
        if (this.refContent != null) {
            return this.refContent;
        }
        this.refContent = this.owner.getContent(this.refContentID);
        if (this.refContent == null) {
            throw new NoSuchElementException(ContentImpl.promptID(this.refContentID));
        }
        return this.refContent;
    }

    public Content insertBefore(Content.RelationType relationType, Content content, Content content2) {
        throw new UnsupportedOperationException();
    }

    public Content.ValueType getValueType() {
        return this.getRefContent().getValueType();
    }

    public Date getObservationDateTime(boolean bl) {
        return this.getRefContent().getObservationDateTime(bl);
    }

    public Code getName() {
        return this.getRefContent().getName();
    }

    public void setName(Code code) {
        throw new UnsupportedOperationException();
    }

    public Template getTemplate() {
        return this.getRefContent().getTemplate();
    }
}

