/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4cheri.net;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import org.dcm4che.Implementation;
import org.dcm4che.dict.DictionaryFactory;
import org.dcm4che.dict.UIDDictionary;
import org.dcm4che.net.AAssociateRQAC;
import org.dcm4che.net.AsyncOpsWindow;
import org.dcm4che.net.ExtNegotiation;
import org.dcm4che.net.PDUException;
import org.dcm4che.net.PresContext;
import org.dcm4che.net.RoleSelection;
import org.dcm4cheri.net.AAbortImpl;
import org.dcm4cheri.net.AsyncOpsWindowImpl;
import org.dcm4cheri.net.ExtNegotiationImpl;
import org.dcm4cheri.net.PresContextImpl;
import org.dcm4cheri.net.RoleSelectionImpl;
import org.dcm4cheri.net.UnparsedPDUImpl;
import org.dcm4cheri.util.StringUtils;

abstract class AAssociateRQACImpl
implements AAssociateRQAC {
    static UIDDictionary DICT = DictionaryFactory.getInstance().getDefaultUIDDictionary();
    private String appCtxUID = "1.2.840.10008.3.1.1.1";
    private int version = 1;
    private int maxLength = 16352;
    private String callingAET = "ANONYMOUS";
    private String calledAET = "ANONYMOUS";
    private String implClassUID = Implementation.getClassUID();
    private String implVers = Implementation.getVersionName();
    private AsyncOpsWindow asyncOpsWindow = null;
    protected final LinkedHashMap presCtxs = new LinkedHashMap();
    protected final LinkedHashMap roleSels = new LinkedHashMap();
    protected final LinkedHashMap extNegs = new LinkedHashMap();
    private static final byte[] ZERO32 = new byte[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};

    AAssociateRQACImpl() {
    }

    /*
     * Unable to fully structure code
     */
    protected AAssociateRQACImpl init(UnparsedPDUImpl var1_1) throws PDUException {
        if (var1_1.buffer() == null) {
            throw new PDUException("PDU length exceeds supported maximum " + var1_1, new AAbortImpl(2, 0));
        }
        var2_2 = new ByteArrayInputStream(var1_1.buffer(), 6, var1_1.length());
        var3_3 = new DataInputStream(var2_2);
        try {
            this.version = var3_3.readShort();
            var3_3.readUnsignedByte();
            var3_3.readUnsignedByte();
            this.calledAET = AAssociateRQACImpl.readASCII(var3_3, 16).trim();
            this.callingAET = AAssociateRQACImpl.readASCII(var3_3, 16).trim();
            if (var3_3.skip(32L) == 32L) ** GOTO lbl34
            throw new EOFException();
lbl-1000:
            // 1 sources

            {
                var4_4 = var3_3.readUnsignedByte();
                var3_3.readUnsignedByte();
                var5_6 = var3_3.readUnsignedShort();
                switch (var4_4) {
                    case 16: {
                        this.appCtxUID = AAssociateRQACImpl.readASCII(var3_3, var5_6);
                        break;
                    }
                    case 32: 
                    case 33: {
                        if (var4_4 != this.pctype()) {
                            throw new PDUException("unexpected item type " + Integer.toHexString(var4_4) + 'H', new AAbortImpl(2, 5));
                        }
                        this.addPresContext(new PresContextImpl(var4_4, var3_3, var5_6));
                        break;
                    }
                    case 80: {
                        this.readUserInfo(var3_3, var5_6);
                        break;
                    }
                    default: {
                        throw new PDUException("unrecognized item type " + Integer.toHexString(var4_4) + 'H', new AAbortImpl(2, 4));
                    }
                }
lbl34:
                // 4 sources

                ** while (var3_3.available() > 0)
            }
lbl35:
            // 1 sources

        }
        catch (PDUException var4_5) {
            throw var4_5;
        }
        catch (Exception var5_7) {
            throw new PDUException("Failed to parse " + var1_1, var5_7, new AAbortImpl(2, 0));
        }
        return this;
    }

    public final int getProtocolVersion() {
        return this.version;
    }

    public final void setProtocolVersion(int n) {
        this.version = n;
    }

    public String getCalledAET() {
        return this.calledAET;
    }

    public String getCallingAET() {
        return this.callingAET;
    }

    public void setCalledAET(String string) {
        this.calledAET = StringUtils.checkAET(string);
    }

    public void setCallingAET(String string) {
        this.callingAET = StringUtils.checkAET(string);
    }

    public final String getApplicationContext() {
        return this.appCtxUID;
    }

    public final void setApplicationContext(String string) {
        string = StringUtils.checkUID(string);
    }

    public final int nextPCID() {
        int n = this.presCtxs.size();
        if (n == 128) {
            return -1;
        }
        int n2 = n << 1 | 1;
        while (this.presCtxs.containsKey(new Integer(n2))) {
            n2 = (n2 + 2) % 256;
        }
        return n2;
    }

    public final PresContext addPresContext(PresContext presContext) {
        if (((PresContextImpl)presContext).type() != this.pctype()) {
            throw new IllegalArgumentException("wrong type of " + presContext);
        }
        return this.presCtxs.put(new Integer(presContext.pcid()), presContext);
    }

    public final PresContext removePresContext(int n) {
        return (PresContext)this.presCtxs.remove(new Integer(n));
    }

    public final PresContext getPresContext(int n) {
        return (PresContext)this.presCtxs.get(new Integer(n));
    }

    public final Collection listPresContext() {
        return this.presCtxs.values();
    }

    public final void clearPresContext() {
        this.presCtxs.clear();
    }

    public final String getImplClassUID() {
        return this.implClassUID;
    }

    public final void setImplClassUID(String string) {
        this.implClassUID = StringUtils.checkUID(string);
    }

    public final String getImplVersionName() {
        return this.implVers;
    }

    public final void setImplVersionName(String string) {
        this.implVers = string != null ? StringUtils.checkAET(string) : null;
    }

    public final int getMaxPDULength() {
        return this.maxLength;
    }

    public final void setMaxPDULength(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("maxLength:" + n);
        }
        this.maxLength = n;
    }

    public final AsyncOpsWindow getAsyncOpsWindow() {
        return this.asyncOpsWindow;
    }

    public final void setAsyncOpsWindow(AsyncOpsWindow asyncOpsWindow) {
        this.asyncOpsWindow = asyncOpsWindow;
    }

    public final RoleSelection removeRoleSelection(String string) {
        return (RoleSelection)this.roleSels.remove(string);
    }

    public final RoleSelection getRoleSelection(String string) {
        return (RoleSelection)this.roleSels.get(string);
    }

    public Collection listRoleSelections() {
        return this.roleSels.values();
    }

    public void clearRoleSelections() {
        this.roleSels.clear();
    }

    public final ExtNegotiation removeExtNegotiation(String string) {
        return (ExtNegotiation)this.extNegs.remove(string);
    }

    public final ExtNegotiation getExtNegotiation(String string) {
        return (ExtNegotiation)this.extNegs.get(string);
    }

    public Collection listExtNegotiations() {
        return this.extNegs.values();
    }

    public void clearExtNegotiations() {
        this.extNegs.clear();
    }

    static String readASCII(DataInputStream dataInputStream, int n) throws IOException, UnsupportedEncodingException {
        byte[] byArray = new byte[n];
        dataInputStream.readFully(byArray);
        while (n > 0 && byArray[n - 1] == 0) {
            --n;
        }
        return new String(byArray, 0, n, "US-ASCII");
    }

    public RoleSelection addRoleSelection(RoleSelection roleSelection) {
        return this.roleSels.put(roleSelection.getSOPClassUID(), roleSelection);
    }

    public ExtNegotiation addExtNegotiation(ExtNegotiation extNegotiation) {
        return this.extNegs.put(extNegotiation.getSOPClassUID(), extNegotiation);
    }

    /*
     * Unable to fully structure code
     */
    private void readUserInfo(DataInputStream var1_1, int var2_2) throws IOException, PDUException {
        var3_3 = var2_2 - var1_1.available();
        if (var3_3 == 0) ** GOTO lbl33
        throw new PDUException("User info item length=" + var2_2 + " mismatch PDU length (diff=" + var3_3 + ")", new AAbortImpl(2, 6));
lbl-1000:
        // 1 sources

        {
            var4_4 = var1_1.readUnsignedByte();
            var1_1.readUnsignedByte();
            var5_5 = var1_1.readUnsignedShort();
            switch (var4_4) {
                case 81: {
                    if (var5_5 != 4) {
                        throw new PDUException("Illegal length of Maximum length sub-item: " + var5_5, new AAbortImpl(2, 6));
                    }
                    this.maxLength = var1_1.readInt();
                    break;
                }
                case 82: {
                    this.implClassUID = AAssociateRQACImpl.readASCII(var1_1, var5_5);
                    break;
                }
                case 83: {
                    this.asyncOpsWindow = new AsyncOpsWindowImpl(var1_1, var5_5);
                    break;
                }
                case 84: {
                    this.addRoleSelection(new RoleSelectionImpl(var1_1, var5_5));
                    break;
                }
                case 85: {
                    this.implVers = AAssociateRQACImpl.readASCII(var1_1, var5_5);
                    break;
                }
                case 86: {
                    this.addExtNegotiation(new ExtNegotiationImpl(var1_1, var5_5));
                    break;
                }
                default: {
                    throw new PDUException("unrecognized user sub-item type " + Integer.toHexString(var4_4) + 'H', new AAbortImpl(2, 4));
                }
            }
lbl33:
            // 7 sources

            ** while (var1_1.available() > 0)
        }
lbl34:
        // 1 sources

    }

    protected abstract int type();

    protected abstract int pctype();

    private void writeAE(DataOutputStream dataOutputStream, String string) throws IOException {
        dataOutputStream.writeBytes(string);
        int n = string.length();
        while (n < 16) {
            dataOutputStream.write(32);
            ++n;
        }
    }

    public final void writeTo(OutputStream outputStream) throws IOException {
        MyByteArrayOutputStream myByteArrayOutputStream = new MyByteArrayOutputStream();
        DataOutputStream dataOutputStream = new DataOutputStream(myByteArrayOutputStream);
        dataOutputStream.writeShort(this.version);
        dataOutputStream.write(0);
        dataOutputStream.write(0);
        this.writeAE(dataOutputStream, this.calledAET);
        this.writeAE(dataOutputStream, this.callingAET);
        dataOutputStream.write(ZERO32);
        dataOutputStream.write(16);
        dataOutputStream.write(0);
        dataOutputStream.writeShort(this.appCtxUID.length());
        dataOutputStream.writeBytes(this.appCtxUID);
        Iterator iterator = this.presCtxs.values().iterator();
        while (iterator.hasNext()) {
            ((PresContextImpl)iterator.next()).writeTo(dataOutputStream);
        }
        this.writeUserInfo(dataOutputStream);
        myByteArrayOutputStream.writeTo(this.type(), outputStream);
    }

    private void writeUserInfo(DataOutputStream dataOutputStream) throws IOException {
        dataOutputStream.write(80);
        dataOutputStream.write(0);
        dataOutputStream.writeShort(this.getUserInfoLength());
        dataOutputStream.write(81);
        dataOutputStream.write(0);
        dataOutputStream.writeShort(4);
        dataOutputStream.writeInt(this.maxLength);
        dataOutputStream.write(82);
        dataOutputStream.write(0);
        dataOutputStream.writeShort(this.implClassUID.length());
        dataOutputStream.writeBytes(this.implClassUID);
        if (this.asyncOpsWindow != null) {
            ((AsyncOpsWindowImpl)this.asyncOpsWindow).writeTo(dataOutputStream);
        }
        Iterator iterator = this.roleSels.values().iterator();
        while (iterator.hasNext()) {
            ((RoleSelectionImpl)iterator.next()).writeTo(dataOutputStream);
        }
        if (this.implVers != null) {
            dataOutputStream.write(85);
            dataOutputStream.write(0);
            dataOutputStream.writeShort(this.implVers.length());
            dataOutputStream.writeBytes(this.implVers);
        }
        Iterator iterator2 = this.extNegs.values().iterator();
        while (iterator2.hasNext()) {
            ((ExtNegotiationImpl)iterator2.next()).writeTo(dataOutputStream);
        }
    }

    private int getUserInfoLength() {
        Object object;
        int n = 12 + this.implClassUID.length();
        if (this.asyncOpsWindow != null) {
            n += 8;
        }
        Iterator iterator = this.roleSels.values().iterator();
        while (iterator.hasNext()) {
            object = (RoleSelectionImpl)iterator.next();
            n += 4 + ((RoleSelectionImpl)object).length();
        }
        if (this.implVers != null) {
            n += 4 + this.implVers.length();
        }
        object = this.extNegs.values().iterator();
        while (object.hasNext()) {
            ExtNegotiationImpl extNegotiationImpl = (ExtNegotiationImpl)object.next();
            n += 4 + extNegotiationImpl.length();
        }
        return n;
    }

    protected abstract String typeAsString();

    public String toString() {
        return this.toString(false);
    }

    public String toString(boolean bl) {
        return this.toStringBuffer(new StringBuffer(), bl).toString();
    }

    final StringBuffer toStringBuffer(StringBuffer stringBuffer, boolean bl) {
        stringBuffer.append(this.typeAsString()).append("\n\tappCtxName:\t").append(DICT.lookup(this.appCtxUID)).append("\n\timplClass:\t").append(this.implClassUID).append("\n\timplVersion:\t").append(this.implVers).append("\n\tcalledAET:\t").append(this.calledAET).append("\n\tcallingAET:\t").append(this.callingAET).append("\n\tmaxPDULen:\t").append(this.maxLength).append("\n\t").append(this.asyncOpsWindow);
        if (bl) {
            Iterator iterator = this.presCtxs.values().iterator();
            while (iterator.hasNext()) {
                this.append((PresContext)iterator.next(), stringBuffer);
            }
            Iterator iterator2 = this.roleSels.values().iterator();
            while (iterator2.hasNext()) {
                stringBuffer.append("\n\t").append(iterator2.next());
            }
            Iterator iterator3 = this.extNegs.values().iterator();
            while (iterator3.hasNext()) {
                stringBuffer.append("\n\t").append(iterator3.next());
            }
        } else {
            this.appendPresCtxSummary(stringBuffer);
            stringBuffer.append("\n\troleSel:\t#").append(this.roleSels.size()).append("\n\textNego:\t#").append(this.extNegs.size());
        }
        return stringBuffer;
    }

    protected abstract void append(PresContext var1, StringBuffer var2);

    protected abstract void appendPresCtxSummary(StringBuffer var1);

    private static final class MyByteArrayOutputStream
    extends ByteArrayOutputStream {
        MyByteArrayOutputStream() {
            super(4096);
            this.write(0);
            this.write(0);
            this.write(0);
            this.write(0);
            this.write(0);
            this.write(0);
        }

        void writeTo(int n, OutputStream outputStream) throws IOException {
            int n2 = this.count - 6;
            this.buf[0] = (byte)n;
            this.buf[1] = 0;
            this.buf[2] = (byte)(n2 >> 24);
            this.buf[3] = (byte)(n2 >> 16);
            this.buf[4] = (byte)(n2 >> 8);
            this.buf[5] = (byte)(n2 >> 0);
            outputStream.write(this.buf, 0, this.count);
        }
    }
}

