/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4cheri.media;

import java.io.File;
import java.io.IOException;
import javax.imageio.stream.ImageInputStream;
import org.dcm4che.data.Dataset;
import org.dcm4che.data.DcmElement;
import org.dcm4che.data.DcmObjectFactory;
import org.dcm4che.data.DcmParser;
import org.dcm4che.data.DcmParserFactory;
import org.dcm4che.data.DcmValueException;
import org.dcm4che.data.FileFormat;
import org.dcm4che.media.DirReader;
import org.dcm4che.media.DirRecord;
import org.dcm4cheri.media.DirRecordImpl;

class DirReaderImpl
implements DirReader {
    static final DcmParserFactory pfactory = DcmParserFactory.getInstance();
    static final DcmObjectFactory factory = DcmObjectFactory.getInstance();
    protected final File file;
    protected final ImageInputStream in;
    protected final DcmParser parser;
    protected Dataset fsi;
    protected int offFirstRootRec;
    protected int offLastRootRec;
    protected int seqLength;
    protected long offFirstRootRecValPos;
    protected long offLastRootRecValPos;
    protected long seqValuePos;

    DirReaderImpl(File file, ImageInputStream imageInputStream) {
        this.file = file != null ? file.getAbsoluteFile() : null;
        this.in = imageInputStream;
        this.parser = pfactory.newDcmParser(imageInputStream);
    }

    DirReaderImpl initReader() throws IOException {
        this.fsi = factory.newDataset();
        this.parser.setDcmHandler(this.fsi.getDcmHandler());
        this.seqValuePos = this.parser.parseDcmFile(FileFormat.DICOM_FILE, 266784);
        this.parser.setDcmHandler(null);
        if (this.parser.getReadTag() != 266784) {
            throw new DcmValueException("Missing Directory Record Sequence");
        }
        this.seqLength = this.parser.getReadLength();
        DcmElement dcmElement = this.fsi.get(266752);
        if (dcmElement == null || dcmElement.isEmpty()) {
            throw new DcmValueException("Missing Offset of First Directory Record");
        }
        this.offFirstRootRec = dcmElement.getInt();
        this.offFirstRootRecValPos = dcmElement.getStreamPosition() + 8L;
        DcmElement dcmElement2 = this.fsi.get(266754);
        if (dcmElement2 == null || dcmElement2.isEmpty()) {
            throw new DcmValueException("Missing Offset of Last Directory Record");
        }
        this.offLastRootRec = dcmElement2.getInt();
        this.offLastRootRecValPos = dcmElement2.getStreamPosition() + 8L;
        return this;
    }

    public Dataset getFileSetInfo() {
        return this.fsi;
    }

    public File getRefFile(File file, String[] stringArray) {
        File file2 = new File(file, stringArray[0]);
        int n = 1;
        while (n < stringArray.length) {
            file2 = new File(file2, stringArray[n]);
            ++n;
        }
        return file2;
    }

    public File getRefFile(String[] stringArray) {
        if (this.file == null) {
            throw new IllegalStateException("Unkown root directory");
        }
        return this.getRefFile(this.file.getParentFile(), stringArray);
    }

    public File getDescriptorFile(File file) throws DcmValueException {
        String[] stringArray = this.fsi.getStrings(266561);
        if (stringArray == null || stringArray.length == 0) {
            return null;
        }
        return this.getRefFile(file, stringArray);
    }

    public File getDescriptorFile() throws DcmValueException {
        if (this.file == null) {
            throw new IllegalStateException("Unkown root directory");
        }
        return this.getDescriptorFile(this.file.getParentFile());
    }

    public boolean isEmpty(boolean bl) throws IOException {
        return this.getFirstRecord(bl) == null;
    }

    public DirRecord getFirstRecord(boolean bl) throws IOException {
        if (this.offFirstRootRec == 0) {
            return null;
        }
        DirRecordImpl dirRecordImpl = new DirRecordImpl(this.parser, this.offFirstRootRec);
        if (bl && dirRecordImpl.getInUseFlag() == 0) {
            return dirRecordImpl.getNextSibling(bl);
        }
        return dirRecordImpl;
    }

    public void close() throws IOException {
        this.in.close();
    }
}

