/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4cheri.data;

import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import org.dcm4che.data.DateTimeFormat;

public final class DateTimeFormatImpl
implements DateTimeFormat {
    private static final DateFormat DATE_FORMAT = new SimpleDateFormat("yyyyMMdd");
    private static final DateFormat TIME_FORMAT = new SimpleDateFormat("HHmmss.SSS");
    private static final DateFormat DATE_TIME_FORMAT = new SimpleDateFormat("yyyyMMddHHmmss.SSS");
    static final DateTimeFormatImpl inst = new DateTimeFormatImpl();
    private static final int MS_PER_DAY = 86400000;

    private DateTimeFormatImpl() {
    }

    public static DateTimeFormat getInstance() {
        return inst;
    }

    public String formatDate(Date date) {
        return date != null ? DATE_FORMAT.format(date) : "";
    }

    public String formatTime(Date date) {
        return date != null ? TIME_FORMAT.format(date) : "";
    }

    public String formatDateTime(Date date) {
        return date != null ? DATE_TIME_FORMAT.format(date) : "";
    }

    public String formatDateRange(Date date, Date date2) {
        return this.formatDate(date) + '-' + this.formatDate(date2);
    }

    public String formatTimeRange(Date date, Date date2) {
        return this.formatTime(date) + '-' + this.formatTime(date2);
    }

    public String formatDateTimeRange(Date date, Date date2) {
        return this.formatDateTime(date) + '-' + this.formatDateTime(date2);
    }

    public Date parseDate(String string) {
        if (string == null || string.length() == 0) {
            return null;
        }
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(new Date(0L));
        this.parseDate(calendar, string);
        return calendar.getTime();
    }

    private void parseDate(Calendar calendar, String string) {
        switch (string.length()) {
            case 8: {
                this.parseNewDate(calendar, string);
                break;
            }
            case 10: {
                if (string.charAt(4) != '.' || string.charAt(7) != '.') {
                    throw new IllegalArgumentException(string);
                }
                this.parseOldDate(calendar, string);
                break;
            }
            default: {
                throw new IllegalArgumentException(string);
            }
        }
    }

    private void parseNewDate(Calendar calendar, String string) {
        calendar.set(Integer.parseInt(string.substring(0, 4)), Integer.parseInt(string.substring(4, 6)) - 1, Integer.parseInt(string.substring(6, 8)));
    }

    private void parseOldDate(Calendar calendar, String string) {
        calendar.set(Integer.parseInt(string.substring(0, 4)), Integer.parseInt(string.substring(5, 7)) - 1, Integer.parseInt(string.substring(8, 10)));
    }

    public Date parseTime(String string) {
        if (string == null || string.length() == 0) {
            return null;
        }
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(new Date(0L));
        this.parseTime(calendar, string);
        return calendar.getTime();
    }

    private void parseTime(Calendar calendar, String string) {
        switch (string.indexOf(58)) {
            case -1: {
                this.parseNewTime(calendar, string);
                break;
            }
            case 2: {
                this.parseOldTime(calendar, string);
                break;
            }
            default: {
                throw new IllegalArgumentException(string);
            }
        }
    }

    private void parseNewTime(Calendar calendar, String string) {
        int n = string.length();
        calendar.set(11, Integer.parseInt(string.substring(0, 2)));
        if (n > 2) {
            calendar.set(12, Integer.parseInt(string.substring(2, 4)));
            if (n > 4) {
                this.parseSec(calendar, string.substring(4));
            }
        }
    }

    private void parseOldTime(Calendar calendar, String string) {
        int n = string.length();
        calendar.set(11, Integer.parseInt(string.substring(0, 2)));
        if (n > 3) {
            calendar.set(12, Integer.parseInt(string.substring(3, 5)));
            if (n > 5) {
                if (string.charAt(5) != ':') {
                    throw new IllegalArgumentException(string);
                }
                if (n > 6) {
                    this.parseSec(calendar, string.substring(6));
                }
            }
        }
    }

    private void parseSec(Calendar calendar, String string) {
        int n = string.length();
        calendar.set(13, Integer.parseInt(string.substring(0, 2)));
        if (n > 2) {
            if (string.charAt(2) != '.') {
                throw new IllegalArgumentException(string);
            }
            if (n > 3) {
                float f = Float.parseFloat(string.substring(2, Math.min(n, 9)));
                calendar.set(14, (int)(f * 1000.0f));
                if (n > 9) {
                    switch (string.charAt(9)) {
                        case '+': 
                        case '-': {
                            calendar.set(15, Integer.parseInt(string.substring(9, n)));
                            break;
                        }
                        default: {
                            throw new IllegalArgumentException(string);
                        }
                    }
                }
            }
        }
    }

    public Date parseDateTime(String string) {
        if (string == null || string.length() == 0) {
            return null;
        }
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(new Date(0L));
        this.parseNewDate(calendar, string);
        if (string.length() > 8) {
            this.parseNewTime(calendar, string.substring(8));
        }
        return calendar.getTime();
    }

    public Date parseDateTime(String string, String string2) {
        if (string == null || string.length() == 0) {
            return null;
        }
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(new Date(0L));
        this.parseDate(calendar, string);
        if (string2 != null && string2.length() > 0) {
            this.parseTime(calendar, string2);
        }
        return calendar.getTime();
    }

    public boolean isDateRange(String string) {
        return string != null && string.indexOf(45) != -1;
    }

    public Date[] parseDateRange(String string) {
        if (string == null || string.length() == 0) {
            return null;
        }
        int n = string.indexOf(45);
        Date[] dateArray = new Date[2];
        dateArray[1] = this.parseDate(string.substring(n + 1));
        if (n == -1) {
            dateArray[0] = dateArray[1];
        } else if (n != 0) {
            dateArray[0] = this.parseDate(string.substring(0, n));
        }
        return dateArray;
    }

    public Date[] parseTimeRange(String string) {
        if (string == null || string.length() == 0) {
            return null;
        }
        int n = string.indexOf(45);
        Date[] dateArray = new Date[2];
        dateArray[1] = this.parseTime(string.substring(n + 1));
        if (n == -1) {
            dateArray[0] = dateArray[1];
        } else if (n != 0) {
            dateArray[0] = this.parseTime(string.substring(0, n));
        }
        return dateArray;
    }

    public Date[] parseDateTimeRange(String string) {
        if (string == null || string.length() == 0) {
            return null;
        }
        int n = string.indexOf(45);
        Date[] dateArray = new Date[2];
        dateArray[1] = this.parseDateTime(string.substring(n + 1));
        if (n == -1) {
            dateArray[0] = dateArray[1];
        } else if (n != 0) {
            dateArray[0] = this.parseDateTime(string.substring(0, n));
        }
        return dateArray;
    }

    public Date[] parseDateTimeRange(String string, String string2) {
        if (string == null || string.length() == 0) {
            return null;
        }
        Date[] dateArray = this.parseDateRange(string);
        if (string2 == null || string2.length() == 0) {
            return dateArray;
        }
        Date[] dateArray2 = this.parseTimeRange(string2);
        Date[] dateArray3 = new Date[2];
        Date date = dateArray[0] == null ? null : (dateArray3[0] = new Date(dateArray[0].getTime() + (dateArray2[0] == null ? 0L : dateArray2[0].getTime())));
        dateArray3[1] = dateArray[1] == null ? null : new Date(dateArray[1].getTime() + (dateArray2[1] == null ? 86400000L : dateArray2[1].getTime()));
        return dateArray3;
    }
}

