/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4cheri.net;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import org.dcm4che.data.Command;
import org.dcm4che.data.DcmObjectFactory;
import org.dcm4che.data.DcmValueException;
import org.dcm4che.net.AAbort;
import org.dcm4che.net.AReleaseRP;
import org.dcm4che.net.AReleaseRQ;
import org.dcm4che.net.Dimse;
import org.dcm4che.net.PDU;
import org.dcm4che.net.PDUException;
import org.dcm4che.net.PDataTF;
import org.dcm4cheri.net.AAbortImpl;
import org.dcm4cheri.net.AReleaseRPImpl;
import org.dcm4cheri.net.DimseImpl;
import org.dcm4cheri.net.FsmImpl;
import org.dcm4cheri.util.LF_ThreadPool;

final class DimseReaderImpl {
    private static final DcmObjectFactory dcmObjFact = DcmObjectFactory.getInstance();
    private final FsmImpl fsm;
    private int timeout = 0;
    private PDataTF pDataTF = null;
    private PDataTF.PDV pdv = null;
    private Command cmd = null;
    private byte[] buf = null;
    private LF_ThreadPool pool = null;

    public DimseReaderImpl(FsmImpl fsmImpl) {
        this.fsm = fsmImpl;
    }

    public void setThreadPool(LF_ThreadPool lF_ThreadPool) {
        this.pool = lF_ThreadPool;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public synchronized Dimse read(int n) throws IOException {
        boolean bl;
        PDataTFInputStream pDataTFInputStream;
        int n2;
        String string;
        block13: {
            this.timeout = n;
            if (!this.nextPDV()) {
                return null;
            }
            if (!this.pdv.cmd()) {
                this.abort("Command PDV expected, but received " + this.pdv);
            }
            if ((string = this.fsm.getAcceptedTransferSyntaxUID(n2 = this.pdv.pcid())) == null) {
                this.abort("No Presentation Context negotiated with pcid:" + n2);
            }
            pDataTFInputStream = new PDataTFInputStream(this.pdv.getInputStream());
            this.cmd = dcmObjFact.newCommand();
            bl = false;
            try {
                try {
                    this.cmd.read(pDataTFInputStream);
                    bl = this.cmd.hasDataset();
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    this.abort(illegalArgumentException.getMessage());
                    Object var9_7 = null;
                    ((InputStream)pDataTFInputStream).close();
                    break block13;
                }
                catch (DcmValueException dcmValueException) {
                    this.abort(dcmValueException.getMessage());
                    Object var9_8 = null;
                    ((InputStream)pDataTFInputStream).close();
                    break block13;
                }
                Object var9_6 = null;
            }
            catch (Throwable throwable) {
                Object var9_9 = null;
                ((InputStream)pDataTFInputStream).close();
                throw throwable;
            }
            ((InputStream)pDataTFInputStream).close();
        }
        pDataTFInputStream = null;
        if (bl) {
            if (!this.nextPDV()) {
                throw new EOFException("Association released during receive of DIMSE");
            }
            if (this.pdv.cmd()) {
                this.abort("Data PDV expected, but received " + this.pdv);
            }
            if (n2 != this.pdv.pcid()) {
                this.abort("Mismatch between Command PDV pcid: " + n2 + " and " + this.pdv);
            }
            pDataTFInputStream = new PDataTFInputStream(this.pdv.getInputStream());
        } else {
            this.forkNextReadNext();
        }
        DimseImpl dimseImpl = new DimseImpl(n2, string, this.cmd, pDataTFInputStream);
        this.fsm.fireReceived(dimseImpl);
        return dimseImpl;
    }

    private void forkNextReadNext() {
        if (this.pool == null) {
            return;
        }
        if (this.cmd.isRequest()) {
            switch (this.cmd.getCommandField()) {
                case 16: 
                case 32: 
                case 33: 
                case 65535: {
                    break;
                }
                default: {
                    if (this.fsm.getMaxOpsPerformed() != 1) break;
                    return;
                }
            }
        }
        this.pool.promoteNewLeader();
    }

    private InputStream nextStream() throws IOException {
        if (this.pdv != null && this.pdv.last()) {
            if (!this.pdv.cmd()) {
                this.forkNextReadNext();
            }
            return null;
        }
        if (!this.nextPDV()) {
            throw new EOFException("Association released during receive of DIMSE");
        }
        return this.pdv.getInputStream();
    }

    private boolean nextPDV() throws IOException {
        boolean bl = this.pdv != null && !this.pdv.last();
        boolean bl2 = bl && this.pdv.cmd();
        int n = bl ? this.pdv.pcid() : 0;
        while (this.pDataTF == null || (this.pdv = this.pDataTF.readPDV()) == null) {
            if (this.nextPDataTF()) continue;
            return false;
        }
        if (bl && (bl2 != this.pdv.cmd() || n != this.pdv.pcid())) {
            this.abort("Mismatch of following PDVs: " + this.pdv);
        }
        return true;
    }

    private void abort(String string) throws IOException {
        AAbortImpl aAbortImpl = new AAbortImpl(0, 0);
        this.fsm.write(aAbortImpl);
        throw new PDUException(string, aAbortImpl);
    }

    private boolean nextPDataTF() throws IOException {
        PDU pDU;
        if (this.buf == null) {
            this.buf = new byte[this.fsm.getReadMaxLength() + 6];
        }
        if ((pDU = this.fsm.read(this.timeout, this.buf)) instanceof PDataTF) {
            this.pDataTF = (PDataTF)pDU;
            return true;
        }
        if (pDU instanceof AReleaseRP) {
            return false;
        }
        if (pDU instanceof AReleaseRQ) {
            this.fsm.write(AReleaseRPImpl.getInstance());
            return false;
        }
        throw new PDUException("Received " + pDU, (AAbort)pDU);
    }

    private class PDataTFInputStream
    extends InputStream {
        private InputStream in;

        PDataTFInputStream(InputStream inputStream) {
            this.in = inputStream;
        }

        public int available() throws IOException {
            if (this.in == null) {
                return 0;
            }
            return this.in.available();
        }

        public int read() throws IOException {
            if (this.in == null) {
                return -1;
            }
            int n = this.in.read();
            if (n == -1) {
                this.in = DimseReaderImpl.this.nextStream();
                return this.read();
            }
            return n;
        }

        public int read(byte[] byArray, int n, int n2) throws IOException {
            if (this.in == null) {
                return -1;
            }
            if (byArray == null) {
                throw new NullPointerException();
            }
            if (n < 0 || n > byArray.length || n2 < 0 || n + n2 > byArray.length || n + n2 < 0) {
                throw new IndexOutOfBoundsException();
            }
            if (n2 == 0) {
                return 0;
            }
            int n3 = this.in.read(byArray, n, n2);
            if (n3 <= 0) {
                this.in = DimseReaderImpl.this.nextStream();
                return this.read(byArray, n, n2);
            }
            return n3;
        }

        public void close() throws IOException {
            while (this.in != null) {
                this.in = DimseReaderImpl.this.nextStream();
            }
        }
    }
}

