/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4cheri.srom;

import java.util.Date;
import org.dcm4che.data.Dataset;
import org.dcm4che.data.DcmElement;
import org.dcm4che.data.DcmValueException;
import org.dcm4che.srom.Code;
import org.dcm4che.srom.Study;
import org.dcm4cheri.srom.CodeImpl;

class StudyImpl
implements Study {
    private final String studyInstanceUID;
    private final String studyID;
    private final Long studyDateTime;
    private final String referringPhysicianName;
    private final String accessionNumber;
    private final String studyDescription;
    private final Code[] procedureCodes;

    public StudyImpl(String string, String string2, Date date, String string3, String string4, String string5, Code[] codeArray) {
        if (string.length() == 0) {
            throw new IllegalArgumentException(string);
        }
        this.studyInstanceUID = string;
        this.studyID = string2;
        this.studyDateTime = date != null ? new Long(date.getTime()) : null;
        this.referringPhysicianName = string3;
        this.accessionNumber = string4;
        this.studyDescription = string5;
        this.procedureCodes = codeArray != null ? (Code[])codeArray.clone() : CodeImpl.EMPTY_ARRAY;
    }

    public StudyImpl(Dataset dataset) throws DcmValueException {
        this(dataset.getString(0x20000D), dataset.getString(0x200010), dataset.getDateTime(524320, 524336), dataset.getString(524432), dataset.getString(524368), dataset.getString(528432), CodeImpl.newCodes(dataset.get(528434)));
    }

    public final String getStudyInstanceUID() {
        return this.studyInstanceUID;
    }

    public final String getStudyID() {
        return this.studyID;
    }

    public final Date getStudyDateTime() {
        return this.studyDateTime != null ? new Date(this.studyDateTime) : null;
    }

    public final String getReferringPhysicianName() {
        return this.referringPhysicianName;
    }

    public final String getAccessionNumber() {
        return this.accessionNumber;
    }

    public final String getStudyDescription() {
        return this.studyDescription;
    }

    public final Code[] getProcedureCodes() {
        return (Code[])this.procedureCodes.clone();
    }

    public int hashCode() {
        return this.studyInstanceUID.hashCode();
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof Study)) {
            return false;
        }
        Study study = (Study)object;
        return this.studyInstanceUID.equals(study.getStudyInstanceUID());
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("Study[").append(this.studyInstanceUID);
        stringBuffer.append(",ID=").append(this.studyID);
        stringBuffer.append(",A#=").append(this.accessionNumber);
        int n = 0;
        while (n < this.procedureCodes.length) {
            stringBuffer.append(",PC=").append(this.procedureCodes[n]);
            ++n;
        }
        stringBuffer.append("]");
        return stringBuffer.toString();
    }

    public void toDataset(Dataset dataset) {
        dataset.putUI(0x20000D, this.studyInstanceUID);
        dataset.putSH(0x200010, this.studyID);
        Date date = this.getStudyDateTime();
        dataset.putDA(524320, date);
        dataset.putTM(524336, date);
        dataset.putPN(524432, this.referringPhysicianName);
        dataset.putLO(524368, this.accessionNumber);
        if (this.studyDescription != null) {
            dataset.putLO(528432, this.studyDescription);
        }
        if (this.procedureCodes.length != 0) {
            DcmElement dcmElement = dataset.putSQ(528434);
            int n = 0;
            while (n < this.procedureCodes.length) {
                this.procedureCodes[n].toDataset(dcmElement.addNewItem());
                ++n;
            }
        }
    }
}

