/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4cheri.media;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import org.dcm4che.data.Dataset;
import org.dcm4che.data.FileFormat;
import org.dcm4che.data.FileMetaInfo;
import org.dcm4che.media.DirBuilder;
import org.dcm4che.media.DirBuilderPref;
import org.dcm4che.media.DirRecord;
import org.dcm4che.media.DirWriter;
import org.dcm4cheri.media.DirReaderImpl;

final class DirBuilderImpl
implements DirBuilder {
    private final DirWriter writer;
    private final DirBuilderPref pref;
    private String curPatID;
    private DirRecord curPatRec;
    private String curStudyUID;
    private DirRecord curStudyRec;
    private String curSeriesUID;
    private DirRecord curSeriesRec;
    private static HashMap REC_TYPE_MAP = new HashMap(79);

    public DirBuilderImpl(DirWriter dirWriter, DirBuilderPref dirBuilderPref) {
        this.writer = dirWriter;
        this.pref = dirBuilderPref;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int addFileRef(File file) throws IOException {
        BufferedInputStream bufferedInputStream = new BufferedInputStream(new FileInputStream(file));
        Dataset dataset = DirReaderImpl.factory.newDataset();
        try {
            dataset.readFile(bufferedInputStream, FileFormat.DICOM_FILE, 2145386512);
            Object var5_4 = null;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            ((InputStream)bufferedInputStream).close();
            throw throwable;
        }
        ((InputStream)bufferedInputStream).close();
        return this.addFileRef(this.writer.toFileIDs(file), dataset);
    }

    public int addFileRef(String[] stringArray, Dataset dataset) throws IOException {
        FileMetaInfo fileMetaInfo = dataset.getFileMetaInfo();
        if (fileMetaInfo == null) {
            throw new IllegalArgumentException("Missing File Meta Information");
        }
        String string = fileMetaInfo.getTransferSyntaxUID();
        if (string == null) {
            throw new IllegalArgumentException("Missing Transfer Syntax UID");
        }
        String string2 = fileMetaInfo.getMediaStorageSOPClassUID();
        if (string2 == null) {
            throw new IllegalArgumentException("Missing SOP Class UID");
        }
        if (!string2.equals(dataset.getString(524310))) {
            throw new IllegalArgumentException("Mismatch SOP Class UID");
        }
        String string3 = (String)REC_TYPE_MAP.get(string2);
        if (string3 == null) {
            throw new UnsupportedOperationException("classUID:" + string2);
        }
        Dataset dataset2 = this.pref.getFilterForRecordType(string3);
        if (dataset2 == null) {
            return 0;
        }
        String string4 = fileMetaInfo.getMediaStorageSOPInstanceUID();
        if (string4 == null) {
            throw new IllegalArgumentException("Missing SOP Instance UID");
        }
        if (!string4.equals(dataset.getString(524312))) {
            throw new IllegalArgumentException("Mismatch SOP Instance UID");
        }
        String string5 = dataset.getString(0x20000E);
        if (string5 == null) {
            throw new IllegalArgumentException("Missing Series Instance UID");
        }
        String string6 = dataset.getString(0x20000D);
        if (string6 == null) {
            throw new IllegalArgumentException("Missing Study Instance UID");
        }
        String string7 = dataset.getString(0x100020, "");
        int n = 0;
        if (!string7.equals(this.curPatID)) {
            n += this.addPatRec(dataset, string7);
        }
        if (!string6.equals(this.curStudyUID)) {
            n += this.addStudyRec(dataset, string6);
        }
        if (!string5.equals(this.curSeriesUID)) {
            n += this.addSeriesRec(dataset, string5);
        }
        this.writer.add(this.curSeriesRec, string3, dataset.subSet(dataset2), stringArray, string2, string4, string);
        return ++n;
    }

    private int addPatRec(Dataset dataset, String string) throws IOException {
        this.writer.commit();
        this.curSeriesUID = null;
        this.curSeriesRec = null;
        this.curStudyUID = null;
        this.curStudyRec = null;
        this.curPatID = string;
        DirRecord dirRecord = this.writer.getFirstRecord(true);
        while (dirRecord != null) {
            if ("PATIENT".equals(dirRecord.getType()) && string.equals(dirRecord.getDataset().getString(0x100020))) {
                this.curPatRec = dirRecord;
                return 0;
            }
            dirRecord = dirRecord.getNextSibling(true);
        }
        this.curPatRec = this.writer.add(null, "PATIENT", dataset.subSet(this.pref.getFilterForRecordType("PATIENT")));
        return 1;
    }

    private int addStudyRec(Dataset dataset, String string) throws IOException {
        this.writer.commit();
        this.curSeriesUID = null;
        this.curSeriesRec = null;
        this.curStudyUID = string;
        DirRecord dirRecord = this.curPatRec.getFirstChild(true);
        while (dirRecord != null) {
            if ("STUDY".equals(dirRecord.getType()) && string.equals(dirRecord.getDataset().getString(0x20000D))) {
                this.curStudyRec = dirRecord;
                return 0;
            }
            dirRecord = dirRecord.getNextSibling(true);
        }
        this.curStudyRec = this.writer.add(this.curPatRec, "STUDY", dataset.subSet(this.pref.getFilterForRecordType("STUDY")));
        return 1;
    }

    private int addSeriesRec(Dataset dataset, String string) throws IOException {
        this.writer.commit();
        this.curSeriesUID = string;
        DirRecord dirRecord = this.curStudyRec.getFirstChild(true);
        while (dirRecord != null) {
            if ("SERIES".equals(dirRecord.getType()) && string.equals(dirRecord.getDataset().getString(0x20000E))) {
                this.curSeriesRec = dirRecord;
                return 0;
            }
            dirRecord = dirRecord.getNextSibling(true);
        }
        this.curSeriesRec = this.writer.add(this.curStudyRec, "SERIES", dataset.subSet(this.pref.getFilterForRecordType("SERIES")));
        return 1;
    }

    public void close() throws IOException {
        this.writer.close();
    }

    static {
        REC_TYPE_MAP.put("1.2.840.10008.5.1.1.27", "STORED PRINT");
        REC_TYPE_MAP.put("1.2.840.10008.5.1.1.29", "IMAGE");
        REC_TYPE_MAP.put("1.2.840.10008.5.1.1.29", "IMAGE");
        REC_TYPE_MAP.put("1.2.840.10008.5.1.1.30", "IMAGE");
        REC_TYPE_MAP.put("1.2.840.10008.5.1.4.1.1.1", "IMAGE");
        REC_TYPE_MAP.put("1.2.840.10008.5.1.4.1.1.1.1", "IMAGE");
        REC_TYPE_MAP.put("1.2.840.10008.5.1.4.1.1.1.1.1", "IMAGE");
        REC_TYPE_MAP.put("1.2.840.10008.5.1.4.1.1.1.2", "IMAGE");
        REC_TYPE_MAP.put("1.2.840.10008.5.1.4.1.1.1.2.1", "IMAGE");
        REC_TYPE_MAP.put("1.2.840.10008.5.1.4.1.1.1.3", "IMAGE");
        REC_TYPE_MAP.put("1.2.840.10008.5.1.4.1.1.1.3.1", "IMAGE");
        REC_TYPE_MAP.put("1.2.840.10008.5.1.4.1.1.2", "IMAGE");
        REC_TYPE_MAP.put("1.2.840.10008.5.1.4.1.1.3", "IMAGE");
        REC_TYPE_MAP.put("1.2.840.10008.5.1.4.1.1.3.1", "IMAGE");
        REC_TYPE_MAP.put("1.2.840.10008.5.1.4.1.1.4", "IMAGE");
        REC_TYPE_MAP.put("1.2.840.10008.5.1.4.1.1.5", "IMAGE");
        REC_TYPE_MAP.put("1.2.840.10008.5.1.4.1.1.6", "IMAGE");
        REC_TYPE_MAP.put("1.2.840.10008.5.1.4.1.1.6.1", "IMAGE");
        REC_TYPE_MAP.put("1.2.840.10008.5.1.4.1.1.7", "IMAGE");
        REC_TYPE_MAP.put("1.2.840.10008.5.1.4.1.1.7.1", "IMAGE");
        REC_TYPE_MAP.put("1.2.840.10008.5.1.4.1.1.7.2", "IMAGE");
        REC_TYPE_MAP.put("1.2.840.10008.5.1.4.1.1.7.3", "IMAGE");
        REC_TYPE_MAP.put("1.2.840.10008.5.1.4.1.1.7.4", "IMAGE");
        REC_TYPE_MAP.put("1.2.840.10008.5.1.4.1.1.8", "OVERLAY");
        REC_TYPE_MAP.put("1.2.840.10008.5.1.4.1.1.9", "CURVE");
        REC_TYPE_MAP.put("1.2.840.10008.5.1.4.1.1.9.1.1", "WAVEFORM");
        REC_TYPE_MAP.put("1.2.840.10008.5.1.4.1.1.9.1.2", "WAVEFORM");
        REC_TYPE_MAP.put("1.2.840.10008.5.1.4.1.1.9.1.3", "WAVEFORM");
        REC_TYPE_MAP.put("1.2.840.10008.5.1.4.1.1.9.2.1", "WAVEFORM");
        REC_TYPE_MAP.put("1.2.840.10008.5.1.4.1.1.9.3.1", "WAVEFORM");
        REC_TYPE_MAP.put("1.2.840.10008.5.1.4.1.1.9.4.1", "WAVEFORM");
        REC_TYPE_MAP.put("1.2.840.10008.5.1.4.1.1.10", "MODALITY LUT");
        REC_TYPE_MAP.put("1.2.840.10008.5.1.4.1.1.11", "VOI LUT");
        REC_TYPE_MAP.put("1.2.840.10008.5.1.4.1.1.11.1", "PRESENTATION");
        REC_TYPE_MAP.put("1.2.840.10008.5.1.4.1.1.12.1", "IMAGE");
        REC_TYPE_MAP.put("1.2.840.10008.5.1.4.1.1.12.2", "IMAGE");
        REC_TYPE_MAP.put("1.2.840.10008.5.1.4.1.1.12.3", "IMAGE");
        REC_TYPE_MAP.put("1.2.840.10008.5.1.4.1.1.20", "IMAGE");
        REC_TYPE_MAP.put("1.2.840.10008.5.1.4.1.1.77.1", "IMAGE");
        REC_TYPE_MAP.put("1.2.840.10008.5.1.4.1.1.77.2", "IMAGE");
        REC_TYPE_MAP.put("1.2.840.10008.5.1.4.1.1.77.1.1", "IMAGE");
        REC_TYPE_MAP.put("1.2.840.10008.5.1.4.1.1.77.1.2", "IMAGE");
        REC_TYPE_MAP.put("1.2.840.10008.5.1.4.1.1.77.1.3", "IMAGE");
        REC_TYPE_MAP.put("1.2.840.10008.5.1.4.1.1.77.1.4", "IMAGE");
        REC_TYPE_MAP.put("1.2.840.10008.5.1.4.1.1.88.11", "SR DOCUMENT");
        REC_TYPE_MAP.put("1.2.840.10008.5.1.4.1.1.88.22", "SR DOCUMENT");
        REC_TYPE_MAP.put("1.2.840.10008.5.1.4.1.1.88.33", "SR DOCUMENT");
        REC_TYPE_MAP.put("1.2.840.10008.5.1.4.1.1.88.50", "SR DOCUMENT");
        REC_TYPE_MAP.put("1.2.840.10008.5.1.4.1.1.88.59", "KEY OBJECT DOC");
        REC_TYPE_MAP.put("1.2.840.10008.5.1.4.1.1.128", "IMAGE");
        REC_TYPE_MAP.put("1.2.840.10008.5.1.4.1.1.129", "CURVE");
        REC_TYPE_MAP.put("1.2.840.10008.5.1.4.1.1.481.1", "IMAGE");
        REC_TYPE_MAP.put("1.2.840.10008.5.1.4.1.1.481.2", "RT DOSE");
        REC_TYPE_MAP.put("1.2.840.10008.5.1.4.1.1.481.3", "RT STRUCTURE SET");
        REC_TYPE_MAP.put("1.2.840.10008.5.1.4.1.1.481.4", "RT TREAT RECORD");
        REC_TYPE_MAP.put("1.2.840.10008.5.1.4.1.1.481.5", "RT PLAN");
        REC_TYPE_MAP.put("1.2.840.10008.5.1.4.1.1.481.6", "RT TREAT RECORD");
        REC_TYPE_MAP.put("1.2.840.10008.5.1.4.1.1.481.7", "RT TREAT RECORD");
    }
}

