/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4cheri.data;

import java.io.IOException;
import java.nio.charset.Charset;
import org.dcm4che.data.DcmDecodeParam;
import org.dcm4che.data.DcmHandler;
import org.dcm4che.dict.VRs;
import org.dcm4cheri.util.StringUtils;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

class SAXHandlerAdapter
extends DefaultHandler {
    private final DcmHandler handler;
    private int vr;
    static final Charset ISO_8859_1 = Charset.forName("ISO-8859-1");

    public SAXHandlerAdapter(DcmHandler dcmHandler) {
        this.handler = dcmHandler;
    }

    public void startDocument() throws SAXException {
        this.handler.setDcmDecodeParam(DcmDecodeParam.EVR_LE);
    }

    public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
        try {
            if ("elm".equals(string3)) {
                this.element(attributes.getValue("tag"), attributes.getValue("vr"), attributes.getValue("pos"));
            } else if ("val".equals(string3)) {
                this.value(attributes.getValue("len"), attributes.getValue("data"));
            } else if ("seq".equals(string3)) {
                this.handler.startSequence(-1);
            } else if ("item".equals(string3)) {
                this.item(attributes.getValue("id"), attributes.getValue("pos"));
            } else if ("frag".equals(string3)) {
                this.fragment(attributes.getValue("id"), attributes.getValue("pos"), attributes.getValue("len"), attributes.getValue("data"));
            } else if ("filemetainfo".equals(string3)) {
                this.handler.startFileMetaInfo(this.preamble(attributes.getValue("preamble")));
            } else if ("dataset".equals(string3)) {
                this.handler.startDataset();
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new SAXException(string3, exception);
        }
    }

    private byte[] preamble(String string) {
        return string == null ? null : StringUtils.parseBytes(string);
    }

    public void endElement(String string, String string2, String string3) throws SAXException {
        try {
            if ("elm".equals(string3)) {
                this.handler.endElement();
            } else if ("seq".equals(string3)) {
                this.handler.endSequence(-1);
            } else if ("item".equals(string3)) {
                this.handler.endItem(-1);
            } else if ("filemetainfo".equals(string3)) {
                this.handler.endFileMetaInfo();
            } else if ("dataset".equals(string3)) {
                this.handler.endDataset();
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new SAXException(string3, exception);
        }
    }

    private void element(String string, String string2, String string3) throws IOException {
        this.vr = VRs.valueOf(string2);
        this.handler.startElement(Integer.parseInt(string, 16), this.vr, string3 != null ? (long)Integer.parseInt(string3) : -1L);
    }

    private void value(String string, String string2) throws IOException {
        int n = Integer.parseInt(string);
        byte[] byArray = StringUtils.parseValue(this.vr, string2, ISO_8859_1);
        this.handler.value(byArray, 0, byArray.length);
    }

    private void sequence(String string) throws IOException {
        this.handler.startSequence(-1);
    }

    private void item(String string, String string2) throws IOException {
        this.handler.startItem(Integer.parseInt(string), string2 != null ? (long)Integer.parseInt(string2) : -1L, -1);
    }

    private void fragment(String string, String string2, String string3, String string4) throws IOException {
        int n = Integer.parseInt(string3);
        byte[] byArray = StringUtils.parseValue(this.vr, string4, null);
        this.handler.fragment(Integer.parseInt(string), string2 != null ? (long)Integer.parseInt(string2) : -1L, byArray, 0, n);
    }
}

