var eccet_cmd_commands;
var eccet_cmd_cnt;
var eccet_cmd_total;
var eccet_cmd_curcommand;
var eccet_cmd_cbcmd=eccet_cmd_cbcmd_dummy;
var eccet_cmd_cbfinal;

//
// Cookie handling
//
function eccet_create_cookie(name,value,days) {
	if (days) {
		var date = new Date();
		date.setTime(date.getTime()+(days*24*60*60*1000));
		var expires = "; expires="+date.toGMTString();
	} else var expires = "";
	document.cookie = name+"="+value+expires+"; path=/";
}

function eccet_read_cookie(name) {
	var nameEQ = name + "=";
	var ca = document.cookie.split(';');
	for(var i=0;i < ca.length;i++) {
		var c = ca[i];
		while (c.charAt(0)==' ') c = c.substring(1,c.length);
		if (c.indexOf(nameEQ) == 0) return c.substring(nameEQ.length,c.length);
	}
	return null;
}

function eccet_erase_cookie(name) {
	eccet_create_cookie(name,"",-1);
}

// Eccet specific "Port" cookie handling
function eccet_set_port(port) {
	eccet_create_cookie("Port",port);
}

function eccet_get_port() {
	var rc=eccet_read_cookie("Port");
	if ( rc=="-1" ) return rc;
	if ( rc[0]!='8' || rc[1]!='0' ) return "8034";
	return rc;
}

//
// Parsing search parameters
//
function eccet_get_searchparm(name) {
	var nameEQ = name + "=";
	var ca = window.location.search.substr(1).split('&');
	for(var i=0;i < ca.length;i++) {
		var c = ca[i];
		if (c.indexOf(nameEQ) == 0) return c.substring(nameEQ.length,c.length);
	}
	return null;
}

function eccet_get_port_from_searchparm() {
	var port=eccet_get_searchparm("Port");
	if (port!=null)
		eccet_set_port(port);
	else 	eccet_set_port("8034"); /* Reasonable default */
}

//
// Eccet script command bridge
//
function eccet_cmd_cbcmd_dummy(step,of,cmd) { /* alert('Doing '+step+'/'+of+': '+cmd); */ }
function eccet_cmd_cbcmd_progress(step,of,cmd) { 
	document.getElementById("progress").width=step/of*100+'%'; 
	document.getElementById("notprogress").width=100-step/of*100+'%'; 
}
function eccet_cmd_cbfinal_dummy() { /* alert('All done.'); */ }
function eccet_cmd_cbfinal_enable_continue() { 
	document.getElementById("continue").disabled=0;
}
function eccet_cmd_have_err() {	  alert('Error while executing Eccet command "'+eccet_cmd_curcommand+'"'); }
function eccet_cmd_have_abort() { alert('Abort while executing Eccet command "'+eccet_cmd_curcommand+'"'); }
function eccet_cmd_have_done() {
	if (eccet_cmd_cnt!=eccet_cmd_total) {
		eccet_cmd_curcommand=eccet_cmd_commands[eccet_cmd_cnt];
		eccet_cmd_cbcmd(eccet_cmd_cnt++,eccet_cmd_total,eccet_cmd_curcommand);
		eccet_cmd_run1command(eccet_cmd_curcommand);
	} else {
		eccet_cmd_cbcmd(eccet_cmd_cnt,eccet_cmd_total,'Done.');
		eccet_cmd_cbfinal();
		eccet_cmd_total=-1;
	}
}
function eccet_cmd_run1command(cmd) {

	var port=eccet_get_port();

	if (port=="-1") {
		setTimeout("eccet_cmd_have_done();",100);
		return;
	}

	var image = new Image;
	var time = new Date();
	image.onabort=eccet_cmd_have_abort;
	image.onerror=eccet_cmd_have_err;
	image.onload=eccet_cmd_have_done;
	image.bLoaded=false;
	image.src="http://localhost:"+port+"/CMD/PNG/"+time.getTime()+'/'+encodeURI(cmd);
}

function eccet_cmd_runscript(cmdarray,cbcmd,cbfinal)
{
	eccet_cmd_commands = cmdarray;
	eccet_cmd_cnt = 0;
	eccet_cmd_total = eccet_cmd_commands.length;
	eccet_cmd_cbcmd = cbcmd ? cbcmd : eccet_cmd_cbcmd_dummy;
	eccet_cmd_cbfinal = cbfinal ? cbfinal : eccet_cmd_cbfinal_dummy;
	eccet_cmd_have_done();
}

// run a single command
// DANGER! NEVER use this in a row to execute a set of commands.
// the function returns _immediately_, thus making successive calls
// interfere.
function eccet_cmd_run_single(command) {
	var mycmd=new Array( "ERROR" );
	mycmd[0]=command;
	eccet_cmd_runscript(mycmd);
}

function eccet_cmd_run_single_with_return(command) {

	var port=eccet_get_port();

	if (port=="-1") {
		alert("No Eccet connection. Can't get return value.");
		return null;
	}

	netscape.security.PrivilegeManager.enablePrivilege("UniversalBrowserRead");
	var req = new XMLHttpRequest();
	var time = new Date();
	req.open("GET", "http://localhost:"+eccet_get_port()+"/CMD/XML/"+time.getTime()+'/'+escape(command),false);
	req.send(null);
	if (req.status==200) {
		var xmldoc = req.responseXML;
		var root_node = xmldoc.getElementsByTagName('success')[0].firstChild.data;
		if (root_node==1) {
			return xmldoc.getElementsByTagName('result')[0].firstChild.data;
		} else return null;
	} else return null;
}

//
// Window handling
//
function eccet_window_open(x,y,w,h,target,url) {
	window.open(url,target,'width='+w+',height='+h+',left='+x+',top='+y+',scrollbars=yes');
}

// String quoting

function eccet_string_quote(str) {
	return "\""+str.replace(/"/g,"\\\"")+"\"";
}
