/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4cheri.util;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import org.dcm4che.dict.Tags;
import org.dcm4che.dict.VRs;

public class StringUtils {
    static final Charset ISO_8859_1 = Charset.forName("ISO-8859-1");
    static final byte[] b0 = new byte[0];
    static final String[] NULL_STRINGS = new String[0];
    private static final int UID_DIGIT1 = 0;
    private static final int UID_DIGIT = 1;
    private static final int UID_DOT = 2;
    private static final int UID_ERROR = -1;

    private StringUtils() {
    }

    public static StringBuffer promptBytes(StringBuffer stringBuffer, byte[] byArray, int n, int n2, int n3) {
        if (n2 == 0) {
            return stringBuffer;
        }
        Tags.toHexString(stringBuffer, byArray[n] & 0xFF, 2);
        int n4 = n + 1;
        int n5 = Math.min(n2, (n3 - 2) / 3);
        while (--n5 > 0) {
            Tags.toHexString(stringBuffer.append('\\'), byArray[n4] & 0xFF, 2);
            ++n4;
        }
        if (stringBuffer.length() < 3 * n2 - 1) {
            stringBuffer.setLength(n3 - 2);
            stringBuffer.append("..");
        }
        return stringBuffer;
    }

    public static String promptBytes(byte[] byArray, int n, int n2, int n3) {
        if (n2 == 0) {
            return "";
        }
        return StringUtils.promptBytes(new StringBuffer(Math.min(n3, n2 * 3 - 1)), byArray, n, n2, n3).toString();
    }

    public static String promptBytes(byte[] byArray, int n, int n2) {
        return StringUtils.promptBytes(byArray, n, n2, Integer.MAX_VALUE);
    }

    public static String truncate(String string, int n) {
        return string.length() > n ? string.substring(0, n - 2) + ".." : string;
    }

    public static String promptValue(int n, ByteBuffer byteBuffer) {
        return StringUtils.promptValue(n, byteBuffer, ISO_8859_1, Integer.MAX_VALUE);
    }

    public static String promptValue(int n, ByteBuffer byteBuffer, Charset charset) {
        return StringUtils.promptValue(n, byteBuffer, charset, Integer.MAX_VALUE);
    }

    public static String promptValue(int n, ByteBuffer byteBuffer, int n2) {
        return StringUtils.promptValue(n, byteBuffer, ISO_8859_1, n2);
    }

    public static String promptValue(int n, ByteBuffer byteBuffer, Charset charset, int n2) {
        if (byteBuffer.limit() == 0) {
            return "";
        }
        if (VRs.isStringValue(n)) {
            if (byteBuffer.get(byteBuffer.limit() - 1) == 0) {
                byteBuffer.limit(byteBuffer.limit() - 1);
            }
            return StringUtils.truncate(charset.decode(byteBuffer).toString(), n2);
        }
        switch (n) {
            case 16724: {
                return StringUtils.promptAT(byteBuffer, n2);
            }
            case 17988: {
                return StringUtils.promptFD(byteBuffer, n2);
            }
            case 17996: {
                return StringUtils.promptFL(byteBuffer, n2);
            }
            case 20290: 
            case 21838: {
                return StringUtils.promptOB(byteBuffer, n2);
            }
            case 20294: {
                return StringUtils.promptOF(byteBuffer, n2);
            }
            case 20311: {
                return StringUtils.promptOW(byteBuffer, n2);
            }
            case 21324: {
                return StringUtils.promptSL(byteBuffer, n2);
            }
            case 21331: {
                return StringUtils.promptSS(byteBuffer, n2);
            }
            case 21836: {
                return StringUtils.promptUL(byteBuffer, n2);
            }
            case 21843: {
                return StringUtils.promptUS(byteBuffer, n2);
            }
        }
        throw new IllegalArgumentException("VR:" + VRs.toString(n));
    }

    public static String promptAT(ByteBuffer byteBuffer, int n) {
        int n2 = byteBuffer.limit() / 4 * 9 - 1;
        if (n2 < 0) {
            return "";
        }
        StringBuffer stringBuffer = new StringBuffer(n2);
        byteBuffer.rewind();
        Tags.toHexString(stringBuffer, byteBuffer.getShort() & 0xFFFF, 4);
        Tags.toHexString(stringBuffer, byteBuffer.getShort() & 0xFFFF, 4);
        while (byteBuffer.remaining() >= 4 && stringBuffer.length() < n) {
            Tags.toHexString(stringBuffer.append('\\'), byteBuffer.getShort() & 0xFFFF, 4);
            Tags.toHexString(stringBuffer, byteBuffer.getShort() & 0xFFFF, 4);
        }
        return StringUtils.truncate(stringBuffer.toString(), n);
    }

    public static String promptFD(ByteBuffer byteBuffer, int n) {
        if (byteBuffer.limit() < 8) {
            return "";
        }
        StringBuffer stringBuffer = new StringBuffer(byteBuffer.limit());
        byteBuffer.rewind();
        stringBuffer.append(byteBuffer.getDouble());
        while (byteBuffer.remaining() >= 8 && stringBuffer.length() < n) {
            stringBuffer.append('\\').append(byteBuffer.getDouble());
        }
        return StringUtils.truncate(stringBuffer.toString(), n);
    }

    public static String promptFL(ByteBuffer byteBuffer, int n) {
        if (byteBuffer.limit() < 4) {
            return "";
        }
        StringBuffer stringBuffer = new StringBuffer(byteBuffer.limit());
        byteBuffer.rewind();
        stringBuffer.append(byteBuffer.getFloat());
        while (byteBuffer.remaining() >= 4 && stringBuffer.length() < n) {
            stringBuffer.append('\\').append(byteBuffer.getFloat());
        }
        return StringUtils.truncate(stringBuffer.toString(), n);
    }

    public static String promptOB(ByteBuffer byteBuffer, int n) {
        return StringUtils.promptBytes(byteBuffer.array(), byteBuffer.arrayOffset(), byteBuffer.limit(), n);
    }

    public static String promptOF(ByteBuffer byteBuffer, int n) {
        return StringUtils.promptFL(byteBuffer, n);
    }

    public static String promptOW(ByteBuffer byteBuffer, int n) {
        int n2 = byteBuffer.limit() / 2 * 5 - 1;
        if (n2 < 0) {
            return "";
        }
        StringBuffer stringBuffer = new StringBuffer(n2);
        byteBuffer.rewind();
        Tags.toHexString(stringBuffer, byteBuffer.getShort() & 0xFFFF, 4);
        while (byteBuffer.remaining() >= 2 && stringBuffer.length() < n) {
            Tags.toHexString(stringBuffer.append('\\'), byteBuffer.getShort() & 0xFFFF, 4);
        }
        return StringUtils.truncate(stringBuffer.toString(), n);
    }

    public static String promptSL(ByteBuffer byteBuffer, int n) {
        if (byteBuffer.limit() < 4) {
            return "";
        }
        StringBuffer stringBuffer = new StringBuffer(byteBuffer.limit());
        byteBuffer.rewind();
        stringBuffer.append(byteBuffer.getInt());
        while (byteBuffer.remaining() >= 4 && stringBuffer.length() < n) {
            stringBuffer.append('\\').append(byteBuffer.getInt());
        }
        return StringUtils.truncate(stringBuffer.toString(), n);
    }

    public static String promptSS(ByteBuffer byteBuffer, int n) {
        if (byteBuffer.limit() < 2) {
            return "";
        }
        StringBuffer stringBuffer = new StringBuffer(byteBuffer.limit());
        byteBuffer.rewind();
        stringBuffer.append(byteBuffer.getShort());
        while (byteBuffer.remaining() >= 2 && stringBuffer.length() < n) {
            stringBuffer.append('\\').append(byteBuffer.getShort());
        }
        return StringUtils.truncate(stringBuffer.toString(), n);
    }

    public static String promptUL(ByteBuffer byteBuffer, int n) {
        if (byteBuffer.limit() < 4) {
            return "";
        }
        StringBuffer stringBuffer = new StringBuffer(byteBuffer.limit());
        byteBuffer.rewind();
        stringBuffer.append((long)byteBuffer.getInt() & 0xFFFFFFFFL);
        while (byteBuffer.remaining() >= 4 && stringBuffer.length() < n) {
            stringBuffer.append('\\').append((long)byteBuffer.getInt() & 0xFFFFFFFFL);
        }
        return StringUtils.truncate(stringBuffer.toString(), n);
    }

    public static String promptUS(ByteBuffer byteBuffer, int n) {
        if (byteBuffer.limit() < 2) {
            return "";
        }
        StringBuffer stringBuffer = new StringBuffer(byteBuffer.limit());
        byteBuffer.rewind();
        stringBuffer.append(byteBuffer.getShort() & 0xFFFF);
        while (byteBuffer.remaining() >= 2 && stringBuffer.length() < n) {
            stringBuffer.append('\\').append(byteBuffer.getShort() & 0xFFFF);
        }
        return StringUtils.truncate(stringBuffer.toString(), n);
    }

    public static byte[] parseValue(int n, String string, Charset charset) {
        if (string.length() == 0) {
            return b0;
        }
        if (VRs.isStringValue(n)) {
            return charset.encode(CharBuffer.wrap(string)).array();
        }
        switch (n) {
            case 16724: {
                return StringUtils.parseAT(string);
            }
            case 17988: {
                return StringUtils.parseFD(string);
            }
            case 17996: {
                return StringUtils.parseFL(string);
            }
            case 20290: 
            case 21838: {
                return StringUtils.parseBytes(string);
            }
            case 20294: {
                return StringUtils.parseOF(string);
            }
            case 20311: {
                return StringUtils.parseOW(string);
            }
            case 21331: 
            case 21843: {
                return StringUtils.parseSS_US(string);
            }
            case 21324: 
            case 21836: {
                return StringUtils.parseSL_UL(string);
            }
        }
        throw new IllegalArgumentException("VR:" + VRs.toString(n));
    }

    public static String[] toStringArray(String string, char c) {
        if (string == null || string.length() == 0) {
            return NULL_STRINGS;
        }
        char[] cArray = string.toCharArray();
        int n = 1;
        int n2 = 0;
        while (n2 < cArray.length) {
            if (cArray[n2] == c) {
                ++n;
            }
            ++n2;
        }
        String[] stringArray = new String[n];
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        while (n5 < cArray.length) {
            if (cArray[n5] == c) {
                stringArray[n4++] = new String(cArray, n3, n5 - n3);
                n3 = n5 + 1;
            }
            ++n5;
        }
        stringArray[n4] = new String(cArray, n3, cArray.length - n3);
        return stringArray;
    }

    public static byte[] parseAT(String string) {
        String[] stringArray = StringUtils.toStringArray(string, '\\');
        byte[] byArray = new byte[stringArray.length * 4];
        ByteBuffer byteBuffer = ByteBuffer.wrap(byArray, 0, byArray.length).order(ByteOrder.LITTLE_ENDIAN);
        int n = 0;
        while (n < stringArray.length) {
            int n2 = Integer.parseInt(stringArray[n], 16);
            byteBuffer.putShort((short)(n2 >>> 16));
            byteBuffer.putShort((short)n2);
            ++n;
        }
        return byArray;
    }

    public static byte[] parseFD(String string) {
        String[] stringArray = StringUtils.toStringArray(string, '\\');
        byte[] byArray = new byte[stringArray.length * 8];
        ByteBuffer byteBuffer = ByteBuffer.wrap(byArray, 0, byArray.length).order(ByteOrder.LITTLE_ENDIAN);
        int n = 0;
        while (n < stringArray.length) {
            byteBuffer.putDouble(Double.parseDouble(stringArray[n]));
            ++n;
        }
        return byArray;
    }

    public static byte[] parseFL(String string) {
        String[] stringArray = StringUtils.toStringArray(string, '\\');
        byte[] byArray = new byte[stringArray.length * 4];
        ByteBuffer byteBuffer = ByteBuffer.wrap(byArray, 0, byArray.length).order(ByteOrder.LITTLE_ENDIAN);
        int n = 0;
        while (n < stringArray.length) {
            byteBuffer.putFloat(Float.parseFloat(stringArray[n]));
            ++n;
        }
        return byArray;
    }

    public static byte[] parseOF(String string) {
        return StringUtils.parseFL(string);
    }

    public static byte[] parseBytes(String string) {
        byte[] byArray = new byte[(string.length() + 1) / 3];
        int n = 0;
        int n2 = 0;
        while (n < byArray.length) {
            byArray[n++] = Byte.parseByte(string.substring(n2, n2 + 2), 16);
            ++n;
            n2 += 3;
        }
        return byArray;
    }

    public static byte[] parseOW(String string) {
        byte[] byArray = new byte[(string.length() + 1) / 5];
        int n = 0;
        int n2 = 0;
        while (n < byArray.length) {
            short s = Short.parseShort(string.substring(n2, n2 + 4), 16);
            byArray[n++] = (byte)s;
            byArray[n++] = (byte)(s >>> 8);
            n2 += 5;
        }
        return byArray;
    }

    public static byte[] parseSS_US(String string) {
        String[] stringArray = StringUtils.toStringArray(string, '\\');
        byte[] byArray = new byte[stringArray.length * 2];
        ByteBuffer byteBuffer = ByteBuffer.wrap(byArray, 0, byArray.length).order(ByteOrder.LITTLE_ENDIAN);
        int n = 0;
        while (n < stringArray.length) {
            byteBuffer.putShort((short)Integer.parseInt(stringArray[n]));
            ++n;
        }
        return byArray;
    }

    public static byte[] parseSL_UL(String string) {
        String[] stringArray = StringUtils.toStringArray(string, '\\');
        byte[] byArray = new byte[stringArray.length * 4];
        ByteBuffer byteBuffer = ByteBuffer.wrap(byArray, 0, byArray.length).order(ByteOrder.LITTLE_ENDIAN);
        int n = 0;
        while (n < stringArray.length) {
            byteBuffer.putInt((int)Long.parseLong(stringArray[n]));
            ++n;
        }
        return byArray;
    }

    public static float[] parseFloats(String[] stringArray) {
        float[] fArray = new float[stringArray.length];
        int n = 0;
        while (n < fArray.length) {
            fArray[n] = Float.parseFloat(stringArray[n]);
            ++n;
        }
        return fArray;
    }

    public static double[] parseDoubles(String[] stringArray) {
        double[] dArray = new double[stringArray.length];
        int n = 0;
        while (n < dArray.length) {
            dArray[n] = Double.parseDouble(stringArray[n]);
            ++n;
        }
        return dArray;
    }

    public static int parseInt(String string, long l, long l2) {
        long l3 = Long.parseLong(string);
        if (l3 < l || l3 > l2) {
            throw new NumberFormatException("value: " + string + ", min:" + l + ", max:" + l2);
        }
        return (int)l3;
    }

    public static int[] parseInts(String[] stringArray, long l, long l2) {
        int[] nArray = new int[stringArray.length];
        int n = 0;
        while (n < nArray.length) {
            nArray[n] = StringUtils.parseInt(stringArray[n], l, l2);
            ++n;
        }
        return nArray;
    }

    private static int nextState(int n, char c) {
        switch (n) {
            case 0: {
                if (c > '0' && c <= '9') {
                    return 1;
                }
                if (c == '0') {
                    return 2;
                }
                return -1;
            }
            case 1: {
                if (c >= '0' && c <= '9') {
                    return 1;
                }
            }
            case 2: {
                if (c != '.') break;
                return 0;
            }
        }
        return -1;
    }

    public static String checkUID(String string) {
        char[] cArray = string.toCharArray();
        if (cArray.length == 0 || cArray.length > 64) {
            throw new IllegalArgumentException(string);
        }
        int n = 0;
        int n2 = 0;
        while (n2 < cArray.length) {
            if ((n = StringUtils.nextState(n, cArray[n2])) == -1) {
                throw new IllegalArgumentException(string);
            }
            ++n2;
        }
        if (n == 0) {
            throw new IllegalArgumentException(string);
        }
        return string;
    }

    public static String[] checkUIDs(String[] stringArray) {
        int n = 0;
        while (n < stringArray.length) {
            StringUtils.checkUID(stringArray[n]);
            ++n;
        }
        return stringArray;
    }

    public static String checkAET(String string) {
        char[] cArray = string.toCharArray();
        if (cArray.length == 0 || cArray.length > 16) {
            throw new IllegalArgumentException(string);
        }
        int n = 0;
        while (n < cArray.length) {
            if (cArray[n] < ' ' || cArray[n] >= '\u007f') {
                throw new IllegalArgumentException(string);
            }
            ++n;
        }
        return string;
    }

    public static String[] checkAETs(String[] stringArray) {
        int n = 0;
        while (n < stringArray.length) {
            StringUtils.checkAET(stringArray[n]);
            ++n;
        }
        return stringArray;
    }
}

