/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4cheri.util;

import org.apache.log4j.Logger;

public class LF_ThreadPool {
    private static final Logger log = Logger.getLogger("org.dcm4cheri.util.LF_ThreadPool");
    private final Handler handler;
    private boolean shutdown = false;
    private Thread leader = null;
    private Object mutex = new Object();
    private int waiting = 0;
    private int running = 0;
    private int maxRunning = Integer.MAX_VALUE;
    private final int instNo = ++instCount;
    private static int instCount = 0;

    public LF_ThreadPool(Handler handler) {
        if (handler == null) {
            throw new NullPointerException();
        }
        this.handler = handler;
    }

    public int waiting() {
        return this.waiting;
    }

    public int running() {
        return this.running;
    }

    public boolean isShutdown() {
        return this.shutdown;
    }

    public int getMaxRunning() {
        return this.maxRunning;
    }

    public void setMaxRunning(int n) {
        if (n <= 0) {
            throw new IllegalArgumentException("maxRunning: " + n);
        }
        this.maxRunning = n;
    }

    public String toString() {
        return "LF_ThreadPool-" + this.instNo + "[leader:" + (this.leader == null ? "null" : this.leader.getName()) + ", waiting:" + this.waiting + ", running: " + this.running + "(" + this.maxRunning + "), shutdown: " + this.shutdown + "]";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void join() {
        while (!this.shutdown && this.waiting + this.running < this.maxRunning) {
            Object var7_4;
            Object object = this.mutex;
            synchronized (object) {
                while (this.leader != null) {
                    Object var4_3;
                    if (log.isDebugEnabled()) {
                        log.debug("" + this + " - " + Thread.currentThread().getName() + " enter wait()");
                    }
                    ++this.waiting;
                    try {
                        try {
                            this.mutex.wait();
                        }
                        catch (InterruptedException interruptedException) {
                            interruptedException.printStackTrace();
                            var4_3 = null;
                            --this.waiting;
                        }
                        var4_3 = null;
                        --this.waiting;
                    }
                    catch (Throwable throwable) {
                        var4_3 = null;
                        --this.waiting;
                        throw throwable;
                    }
                    if (!log.isDebugEnabled()) continue;
                    log.debug("" + this + " - " + Thread.currentThread().getName() + " awaked");
                }
                if (this.shutdown) {
                    return;
                }
                this.leader = Thread.currentThread();
                if (log.isDebugEnabled()) {
                    log.debug("" + this + " - New Leader");
                }
            }
            ++this.running;
            try {
                do {
                    this.handler.run(this);
                    if (this.shutdown) break;
                } while (this.leader == Thread.currentThread());
                var7_4 = null;
                --this.running;
            }
            catch (Throwable throwable) {
                var7_4 = null;
                --this.running;
                throw throwable;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive exception aggregation
     */
    public boolean promoteNewLeader() {
        if (this.shutdown) {
            return false;
        }
        if (this.leader != Thread.currentThread()) {
            throw new IllegalStateException();
        }
        this.leader = null;
        Object object = this.mutex;
        synchronized (object) {
            if (this.waiting > 0) {
                if (log.isDebugEnabled()) {
                    log.debug("" + this + " - promote new leader by notify");
                }
                this.mutex.notify();
                boolean bl = true;
                return bl;
            }
        }
        if (this.running >= this.maxRunning) {
            if (log.isDebugEnabled()) {
                log.debug("" + this + " - Max number of threads reached");
            }
            return false;
        }
        if (log.isDebugEnabled()) {
            log.debug("" + this + " - promote new leader by add new Thread");
        }
        this.addThread(new Runnable(){

            public void run() {
                LF_ThreadPool.this.join();
            }
        });
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() {
        if (log.isDebugEnabled()) {
            log.debug("" + this + " - shutdown");
        }
        this.shutdown = true;
        this.leader = null;
        Object object = this.mutex;
        synchronized (object) {
            this.mutex.notifyAll();
        }
    }

    protected void addThread(Runnable runnable) {
        new Thread(runnable).start();
    }

    public static interface Handler {
        public void run(LF_ThreadPool var1);
    }
}

