/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4cheri.util;

import java.util.Iterator;
import java.util.NoSuchElementException;

public final class IntHashtable2 {
    private int primeIndex;
    private static final float highWaterFactor = 0.4f;
    private int highWaterMark;
    private static final float lowWaterFactor = 0.0f;
    private int lowWaterMark;
    private int count;
    private int mask = -1;
    private Object[] values;
    private int[] keyList;
    private static final int EMPTY = Integer.MIN_VALUE;
    private static final int DELETED = -2147483647;
    private static final int MAX_UNUSED = -2147483647;
    private static final int[] PRIMES = new int[]{17, 37, 67, 131, 257, 521, 1031, 2053, 4099, 8209, 16411, 32771, 65537, 131101, 262147, 524309, 0x100007, 0x200011, 0x40000F, 0x800009, 16777259, 0x2000023, 0x400000F, 134217757, 0x10000003, 0x2000000B, 0x40000003, Integer.MAX_VALUE};

    public IntHashtable2() {
        this.initialize(3);
    }

    public IntHashtable2(int n) {
        this.initialize(IntHashtable2.leastGreaterPrimeIndex((int)((float)n / 0.4f)));
    }

    public void clear() {
        this.initialize(3);
    }

    public int size() {
        return this.count;
    }

    public void mask(int n) {
        this.mask = n;
    }

    public int mask() {
        return this.mask;
    }

    public boolean isEmpty() {
        return this.count == 0;
    }

    public Iterator iterator() {
        return new Iter();
    }

    public Object put(int n, Object object) {
        int n2;
        if (this.count > this.highWaterMark) {
            this.rehash();
        }
        if (this.keyList[n2 = this.find(n & this.mask)] <= -2147483647) {
            this.keyList[n2] = n & this.mask;
            ++this.count;
        }
        Object object2 = this.values[n2];
        this.values[n2] = object;
        return object2;
    }

    public Object get(int n) {
        return this.values[this.find(n & this.mask)];
    }

    public Object remove(int n) {
        int n2 = this.find(n & this.mask);
        Object object = this.values[n2];
        if (this.keyList[n2] > -2147483647) {
            this.keyList[n2] = -2147483647;
            this.values[n2] = null;
            --this.count;
            if (this.count < this.lowWaterMark) {
                this.rehash();
            }
        }
        return object;
    }

    public boolean equals(Object object) {
        if (object.getClass() != this.getClass()) {
            return false;
        }
        IntHashtable2 intHashtable2 = (IntHashtable2)object;
        if (intHashtable2.size() != this.count) {
            return false;
        }
        int n = 0;
        while (n < this.keyList.length) {
            Object object2;
            int n2 = this.keyList[n];
            if (n2 > -2147483647 && ((object2 = intHashtable2.get(n2)) == null ? this.values[n] != null : !object2.equals(this.values[n]))) {
                return false;
            }
            ++n;
        }
        return true;
    }

    public int hashCode() {
        int n = 465;
        int n2 = 1362796821;
        int n3 = 0;
        while (n3 < this.keyList.length) {
            n = n * n2 + 1;
            n += this.keyList[n3];
            ++n3;
        }
        int n4 = 0;
        while (n4 < this.values.length) {
            n = n * n2 + 1;
            n += this.values[n4].hashCode();
            ++n4;
        }
        return n;
    }

    public Object clone() throws CloneNotSupportedException {
        IntHashtable2 intHashtable2 = (IntHashtable2)super.clone();
        this.values = (Object[])this.values.clone();
        this.keyList = (int[])this.keyList.clone();
        return intHashtable2;
    }

    private void initialize(int n) {
        if (n < 0) {
            n = 0;
        } else if (n >= PRIMES.length) {
            System.out.println("TOO BIG");
            n = PRIMES.length - 1;
        }
        this.primeIndex = n;
        int n2 = PRIMES[n];
        this.values = new Object[n2];
        this.keyList = new int[n2];
        int n3 = 0;
        while (n3 < n2) {
            this.keyList[n3] = Integer.MIN_VALUE;
            this.values[n3] = null;
            ++n3;
        }
        this.count = 0;
        this.lowWaterMark = (int)((float)n2 * 0.0f);
        this.highWaterMark = (int)((float)n2 * 0.4f);
    }

    private void rehash() {
        Object[] objectArray = this.values;
        int[] nArray = this.keyList;
        int n = this.primeIndex;
        if (this.count > this.highWaterMark) {
            ++n;
        } else if (this.count < this.lowWaterMark) {
            n -= 2;
        }
        this.initialize(n);
        int n2 = objectArray.length - 1;
        while (n2 >= 0) {
            int n3 = nArray[n2];
            if (n3 > -2147483647) {
                this.putInternal(n3, objectArray[n2]);
            }
            --n2;
        }
    }

    public void putInternal(int n, Object object) {
        int n2 = this.find(n);
        if (this.keyList[n2] < -2147483647) {
            this.keyList[n2] = n;
            ++this.count;
        }
        this.values[n2] = object;
    }

    private int find(int n) {
        if (n <= -2147483647) {
            throw new IllegalArgumentException("key can't be less than 0xFFFFFFFE");
        }
        int n2 = -1;
        int n3 = (n ^ 0x4000000) % this.keyList.length;
        if (n3 < 0) {
            n3 = -n3;
        }
        int n4 = 0;
        do {
            int n5;
            if ((n5 = this.keyList[n3]) == n) {
                return n3;
            }
            if (n5 <= -2147483647) {
                if (n5 == Integer.MIN_VALUE) {
                    if (n2 >= 0) {
                        n3 = n2;
                    }
                    return n3;
                }
                if (n2 < 0) {
                    n2 = n3;
                }
            }
            if (n4 != 0) continue;
            n4 = n % (this.keyList.length - 1);
            if (n4 < 0) {
                n4 = -n4;
            }
            ++n4;
        } while ((n3 = (n3 + n4) % this.keyList.length) != n2);
        return n3;
    }

    private static int leastGreaterPrimeIndex(int n) {
        int n2 = 0;
        while (n2 < PRIMES.length) {
            if (n < PRIMES[n2]) break;
            ++n2;
        }
        return n2 == 0 ? 0 : n2 - 1;
    }

    static /* synthetic */ int[] access$200(IntHashtable2 intHashtable2) {
        return intHashtable2.keyList;
    }

    static /* synthetic */ Object[] access$300(IntHashtable2 intHashtable2) {
        return intHashtable2.values;
    }

    private final class Iter
    implements Iterator {
        private int remain;
        private int index;

        private Iter() {
            this.remain = IntHashtable2.this.count;
            this.index = 0;
        }

        public boolean hasNext() {
            return this.remain > 0;
        }

        /*
         * Unable to fully structure code
         */
        public Object next() {
            if (this.remain > 0) ** GOTO lbl4
            throw new NoSuchElementException();
lbl-1000:
            // 1 sources

            {
                ++this.index;
lbl4:
                // 2 sources

                ** while (IntHashtable2.access$200((IntHashtable2)IntHashtable2.this)[this.index] <= -2147483647)
            }
lbl5:
            // 1 sources

            --this.remain;
            return IntHashtable2.access$300(IntHashtable2.this)[this.index++];
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

