/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4cheri.srom;

import java.util.Date;
import org.dcm4che.data.Dataset;
import org.dcm4che.srom.Code;
import org.dcm4che.srom.Content;
import org.dcm4che.srom.KeyObject;
import org.dcm4che.srom.Template;
import org.dcm4che.srom.TextContent;
import org.dcm4cheri.srom.NamedContentImpl;

class TextContentImpl
extends NamedContentImpl
implements TextContent {
    private static final int TEXT_PROMPT_LEN = 20;
    private String text;

    TextContentImpl(KeyObject keyObject, Date date, Template template, Code code, String string) {
        super(keyObject, date, template, NamedContentImpl.checkNotNull(code));
        this.setText(string);
    }

    Content clone(KeyObject keyObject, boolean bl) {
        return new TextContentImpl(keyObject, this.getObservationDateTime(bl), this.template, this.name, this.text);
    }

    public final void setName(Code code) {
        this.name = NamedContentImpl.checkNotNull(code);
    }

    public String toString() {
        StringBuffer stringBuffer = this.prompt().append('\"');
        if (this.text.length() <= 20) {
            stringBuffer.append(this.text);
        } else {
            stringBuffer.append(this.text.substring(0, 20)).append("..");
        }
        return stringBuffer.append('\"').toString();
    }

    public final Content.ValueType getValueType() {
        return Content.ValueType.TEXT;
    }

    public final String getText() {
        return this.text;
    }

    public final void setText(String string) {
        if (string.length() == 0) {
            throw new IllegalArgumentException();
        }
        this.text = string;
    }

    public void toDataset(Dataset dataset) {
        super.toDataset(dataset);
        dataset.putUT(4235616, this.text);
    }
}

