/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4cheri.srom;

import org.dcm4che.data.Dataset;
import org.dcm4che.data.DcmElement;
import org.dcm4che.data.DcmValueException;
import org.dcm4che.srom.RefSOP;
import org.dcm4che.srom.Series;
import org.dcm4cheri.srom.RefSOPImpl;

class SeriesImpl
implements Series {
    private final String modality;
    private final String seriesInstanceUID;
    private final int seriesNumber;
    private final RefSOP refStudyComponent;

    public SeriesImpl(String string, String string2, int n, RefSOP refSOP) {
        if (string.length() == 0) {
            throw new IllegalArgumentException(string);
        }
        if (string2.length() == 0) {
            throw new IllegalArgumentException(string2);
        }
        this.modality = string;
        this.seriesInstanceUID = string2;
        this.seriesNumber = n;
        this.refStudyComponent = refSOP;
    }

    public SeriesImpl(Dataset dataset) throws DcmValueException {
        this(dataset.getString(524384), dataset.getString(0x20000E), dataset.getInt(0x200011, -1), RefSOPImpl.newRefSOP(dataset.getItem(528657)));
    }

    public String getModality() {
        return this.modality;
    }

    public String getSeriesInstanceUID() {
        return this.seriesInstanceUID;
    }

    public int getSeriesNumber() {
        return this.seriesNumber;
    }

    public RefSOP getRefStudyComponent() {
        return this.refStudyComponent;
    }

    public int hashCode() {
        return this.seriesInstanceUID.hashCode();
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof Series)) {
            return false;
        }
        Series series = (Series)object;
        return this.seriesInstanceUID.equals(series.getSeriesInstanceUID());
    }

    public String toString() {
        return "Series[" + this.seriesInstanceUID + ",#" + this.seriesNumber + ",PPS=" + this.refStudyComponent + "]";
    }

    public void toDataset(Dataset dataset) {
        dataset.putCS(524384, this.modality);
        dataset.putUI(0x20000E, this.seriesInstanceUID);
        dataset.putIS(0x200011, this.seriesNumber);
        DcmElement dcmElement = dataset.putSQ(528657);
        if (this.refStudyComponent != null) {
            this.refStudyComponent.toDataset(dcmElement.addNewItem());
        }
    }
}

