/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4cheri.srom;

import org.dcm4che.data.Dataset;
import org.dcm4che.data.DcmValueException;
import org.dcm4che.dict.DictionaryFactory;
import org.dcm4che.dict.UIDDictionary;
import org.dcm4che.srom.RefSOP;

class RefSOPImpl
implements RefSOP {
    private static UIDDictionary uidDict = DictionaryFactory.getInstance().getDefaultUIDDictionary();
    private final String refSOPClassUID;
    private final String refSOPInstanceUID;

    public RefSOPImpl(String string, String string2) {
        if (string.length() == 0) {
            throw new IllegalArgumentException(string);
        }
        if (string2.length() == 0) {
            throw new IllegalArgumentException(string2);
        }
        this.refSOPClassUID = string;
        this.refSOPInstanceUID = string2;
    }

    public RefSOPImpl(Dataset dataset) throws DcmValueException {
        this(dataset.getString(528720), dataset.getString(528725));
    }

    public static RefSOP newRefSOP(Dataset dataset) throws DcmValueException {
        return dataset != null ? new RefSOPImpl(dataset) : null;
    }

    public String toString() {
        return uidDict.lookup(this.refSOPClassUID) + "[" + this.refSOPInstanceUID + "]";
    }

    public void toDataset(Dataset dataset) {
        dataset.putUI(528725, this.refSOPClassUID);
        dataset.putUI(528720, this.refSOPInstanceUID);
    }

    public final String getRefSOPClassUID() {
        return this.refSOPClassUID;
    }

    public final String getRefSOPInstanceUID() {
        return this.refSOPInstanceUID;
    }

    public final int hashCode() {
        return this.refSOPInstanceUID.hashCode();
    }

    public final boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof RefSOP)) {
            return false;
        }
        RefSOP refSOP = (RefSOP)object;
        return this.refSOPInstanceUID.equals(refSOP.getRefSOPInstanceUID());
    }
}

