/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4cheri.srom;

import java.util.Date;
import org.dcm4che.data.Dataset;
import org.dcm4che.srom.Code;
import org.dcm4che.srom.Content;
import org.dcm4che.srom.DateTimeContent;
import org.dcm4che.srom.KeyObject;
import org.dcm4che.srom.Template;
import org.dcm4cheri.srom.NamedContentImpl;

class DateTimeContentImpl
extends NamedContentImpl
implements DateTimeContent {
    private long time;

    DateTimeContentImpl(KeyObject keyObject, Date date, Template template, Code code, long l) {
        super(keyObject, date, template, NamedContentImpl.checkNotNull(code));
        this.time = l;
    }

    DateTimeContentImpl(KeyObject keyObject, Date date, Template template, Code code, Date date2) {
        this(keyObject, date, template, code, date2.getTime());
    }

    Content clone(KeyObject keyObject, boolean bl) {
        return new DateTimeContentImpl(keyObject, this.getObservationDateTime(bl), this.template, this.name, this.time);
    }

    public final void setName(Code code) {
        this.name = NamedContentImpl.checkNotNull(code);
    }

    public String toString() {
        return this.prompt().append('(').append(this.getDateTime()).append(')').toString();
    }

    public final Content.ValueType getValueType() {
        return Content.ValueType.DATETIME;
    }

    public final Date getDateTime() {
        return new Date(this.time);
    }

    public final void setDateTime(Date date) {
        this.time = date.getTime();
    }

    public void toDataset(Dataset dataset) {
        super.toDataset(dataset);
        dataset.putDT(4235552, this.getDateTime());
    }
}

