/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4cheri.srom;

import java.util.Date;
import org.dcm4che.data.Dataset;
import org.dcm4che.data.DcmElement;
import org.dcm4che.data.DcmObjectFactory;
import org.dcm4che.data.DcmValueException;
import org.dcm4che.srom.Code;
import org.dcm4che.srom.Content;
import org.dcm4che.srom.KeyObject;
import org.dcm4che.srom.TCoordContent;
import org.dcm4che.srom.Template;
import org.dcm4cheri.srom.CodeContentImpl;
import org.dcm4cheri.srom.CodeImpl;
import org.dcm4cheri.srom.CompositeContentImpl;
import org.dcm4cheri.srom.ContainerContentImpl;
import org.dcm4cheri.srom.DateContentImpl;
import org.dcm4cheri.srom.DateTimeContentImpl;
import org.dcm4cheri.srom.ImageContentImpl;
import org.dcm4cheri.srom.KeyObjectImpl;
import org.dcm4cheri.srom.NumContentImpl;
import org.dcm4cheri.srom.PNameContentImpl;
import org.dcm4cheri.srom.RefSOPImpl;
import org.dcm4cheri.srom.ReferencedContentImpl;
import org.dcm4cheri.srom.SCoordContentImpl;
import org.dcm4cheri.srom.TCoordContentImpl;
import org.dcm4cheri.srom.TemplateImpl;
import org.dcm4cheri.srom.TextContentImpl;
import org.dcm4cheri.srom.TimeContentImpl;
import org.dcm4cheri.srom.UIDRefContentImpl;
import org.dcm4cheri.srom.WaveformContentImpl;

abstract class ContentImpl
implements Content {
    static final DcmObjectFactory dsfact = DcmObjectFactory.getInstance();
    protected KeyObjectImpl owner;
    protected Content.RelationType relation;
    protected ContentImpl parent;
    protected ContentImpl firstChild;
    protected ContentImpl lastChild;
    protected ContentImpl next;
    protected ContentImpl prev;

    ContentImpl(KeyObject keyObject) {
        this.owner = (KeyObjectImpl)keyObject;
    }

    static ContentImpl newContent(KeyObject keyObject, Dataset dataset) throws DcmValueException {
        int[] nArray = dataset.getInts(4250483);
        if (nArray != null) {
            return new ReferencedContentImpl(keyObject, nArray);
        }
        ContentImpl contentImpl = ContentImpl.newContent(keyObject, dataset, dataset.getDate(4235314), TemplateImpl.newTemplate(dataset.getItem(4236548)), CodeImpl.newCode(dataset.getItem(4235331)), dataset.getString(0x40A040));
        contentImpl.initChilds(keyObject, dataset);
        return contentImpl;
    }

    static ContentImpl newContent(KeyObject keyObject, Dataset dataset, Date date, Template template, Code code, String string) throws DcmValueException {
        if ("CONTAINER".equals(string)) {
            return new ContainerContentImpl(keyObject, date, template, code, "SEPARATE".equals(dataset.getString(4235344)));
        }
        if ("TEXT".equals(string)) {
            return new TextContentImpl(keyObject, date, template, code, dataset.getString(4235616));
        }
        if ("NUM".equals(string)) {
            Dataset dataset2 = dataset.getItem(4236032);
            return new NumContentImpl(keyObject, date, template, code, dataset2.getFloat(4236042, 0.0f), CodeImpl.newCode(dataset2.getItem(4196586)));
        }
        if ("CODE".equals(string)) {
            return new CodeContentImpl(keyObject, date, template, code, CodeImpl.newCode(dataset.getItem(4235624)));
        }
        if ("DATETIME".equals(string)) {
            return new DateTimeContentImpl(keyObject, date, template, code, dataset.getDate(4235552));
        }
        if ("DATE".equals(string)) {
            return new DateContentImpl(keyObject, date, template, code, dataset.getDate(4235553));
        }
        if ("TIME".equals(string)) {
            return new TimeContentImpl(keyObject, date, template, code, dataset.getDate(4235554));
        }
        if ("UIDREF".equals(string)) {
            return new UIDRefContentImpl(keyObject, date, template, code, dataset.getString(4235556));
        }
        if ("PNAME".equals(string)) {
            return new PNameContentImpl(keyObject, date, template, code, dataset.getString(4235555));
        }
        if ("COMPOSITE".equals(string)) {
            return new CompositeContentImpl(keyObject, date, template, code, RefSOPImpl.newRefSOP(dataset.getItem(528793)));
        }
        if ("IMAGE".equals(string)) {
            Dataset dataset3 = dataset.getItem(528793);
            Dataset dataset4 = dataset3.getItem(528793);
            return new ImageContentImpl(keyObject, date, template, code, RefSOPImpl.newRefSOP(dataset3), dataset3.getInts(528736), RefSOPImpl.newRefSOP(dataset4));
        }
        if ("WAVEFORM".equals(string)) {
            Dataset dataset5 = dataset.getItem(528793);
            return new WaveformContentImpl(keyObject, date, template, code, RefSOPImpl.newRefSOP(dataset5), dataset5.getInts(4235440));
        }
        if ("SCOORD".equals(string)) {
            String string2 = dataset.getString(7340067);
            if ("POINT".equals(string2)) {
                return new SCoordContentImpl.Point(keyObject, date, template, code, dataset.getFloats(0x700022));
            }
            if ("MULTIPOINT".equals(string2)) {
                return new SCoordContentImpl.MultiPoint(keyObject, date, template, code, dataset.getFloats(0x700022));
            }
            if ("POLYLINE".equals(string2)) {
                return new SCoordContentImpl.Polyline(keyObject, date, template, code, dataset.getFloats(0x700022));
            }
            if ("CIRCLE".equals(string2)) {
                return new SCoordContentImpl.Circle(keyObject, date, template, code, dataset.getFloats(0x700022));
            }
            if ("ELLIPSE".equals(string2)) {
                return new SCoordContentImpl.Ellipse(keyObject, date, template, code, dataset.getFloats(0x700022));
            }
            throw new IllegalArgumentException(string2);
        }
        if ("TCOORD".equals(string)) {
            String string3 = dataset.getString(4235568);
            TCoordContent.Positions positions = TCoordContentImpl.newPositions(dataset);
            if ("POINT".equals(string3)) {
                return new TCoordContentImpl.Point(keyObject, date, template, code, positions);
            }
            if ("MULTIPOINT".equals(string3)) {
                return new TCoordContentImpl.MultiPoint(keyObject, date, template, code, positions);
            }
            if ("SEGMENT".equals(string3)) {
                return new TCoordContentImpl.Segment(keyObject, date, template, code, positions);
            }
            if ("MULTISEGMENT".equals(string3)) {
                return new TCoordContentImpl.MultiSegment(keyObject, date, template, code, positions);
            }
            if ("BEGIN".equals(string3)) {
                return new TCoordContentImpl.Begin(keyObject, date, template, code, positions);
            }
            if ("END".equals(string3)) {
                return new TCoordContentImpl.End(keyObject, date, template, code, positions);
            }
            throw new IllegalArgumentException(string3);
        }
        throw new IllegalArgumentException(string);
    }

    StringBuffer prompt() {
        StringBuffer stringBuffer = ContentImpl.appendID(new StringBuffer(), this.getID());
        if (this.relation != null) {
            stringBuffer.append(this.relation.toString().toLowerCase()).append(' ');
        }
        return stringBuffer;
    }

    static StringBuffer appendID(StringBuffer stringBuffer, int[] nArray) {
        if (nArray == null) {
            return stringBuffer.append("(null)");
        }
        stringBuffer.append('(').append(nArray[0]);
        int n = 1;
        while (n < nArray.length) {
            stringBuffer.append('.').append(nArray[n]);
            ++n;
        }
        return stringBuffer.append(')');
    }

    static String promptID(int[] nArray) {
        return ContentImpl.appendID(new StringBuffer(), nArray).toString();
    }

    public int[] getID() {
        int n = 1;
        ContentImpl contentImpl = this;
        ContentImpl contentImpl2 = this.parent;
        while (contentImpl2 != null) {
            ++n;
            contentImpl = contentImpl2;
            contentImpl2 = contentImpl2.parent;
        }
        if (contentImpl != this.owner) {
            return null;
        }
        int[] nArray = new int[n];
        ContentImpl contentImpl3 = this.parent;
        ContentImpl contentImpl4 = this;
        while (contentImpl3 != null) {
            nArray[--n] = 1;
            ContentImpl contentImpl5 = contentImpl3.firstChild;
            while (contentImpl5 != contentImpl4) {
                int n2 = n;
                nArray[n2] = nArray[n2] + 1;
                contentImpl5 = contentImpl5.next;
            }
            contentImpl4 = contentImpl3;
            contentImpl3 = contentImpl3.parent;
        }
        nArray[0] = 1;
        return nArray;
    }

    public KeyObject getOwnerDocument() {
        return this.owner;
    }

    public Content.RelationType getRelationType() {
        return this.relation;
    }

    public Content getParent() {
        return this.parent;
    }

    public boolean hasChildren() {
        return this.getFirstChild() != null;
    }

    public Content getFirstChild() {
        return this.firstChild;
    }

    private static Content find(Content.RelationType relationType, Code code, Content content) {
        Content content2 = content;
        while (content2 != null) {
            if (!(relationType != null && relationType != content2.getRelationType() || code != null && !code.equals(content2.getName()))) {
                return content2;
            }
            content2 = content2.getNextSibling();
        }
        return null;
    }

    public Content getFirstChildBy(Content.RelationType relationType, Code code) {
        return ContentImpl.find(relationType, code, this.getFirstChild());
    }

    public Content getLastChild() {
        return this.lastChild;
    }

    public Content getPreviousSibling() {
        return this.prev;
    }

    public Content getNextSibling() {
        return this.next;
    }

    public Content getNextSiblingBy(Content.RelationType relationType, Code code) {
        return ContentImpl.find(relationType, code, this.next);
    }

    public Content appendChild(Content.RelationType relationType, Content content) {
        return this.insertBefore(relationType, content, null);
    }

    public Content insertBefore(Content.RelationType relationType, Content content, Content content2) {
        if (relationType == null) {
            throw new NullPointerException();
        }
        if (content == null) {
            throw new NullPointerException();
        }
        ContentImpl contentImpl = (ContentImpl)content;
        ContentImpl contentImpl2 = (ContentImpl)content2;
        if (contentImpl == this.owner) {
            throw new IllegalArgumentException();
        }
        if (contentImpl.owner != this.owner) {
            throw new IllegalArgumentException();
        }
        if (contentImpl.parent != null) {
            throw new IllegalArgumentException();
        }
        if (content2 != null && contentImpl2.parent != this) {
            throw new IllegalArgumentException();
        }
        if (this.owner.getRelationConstraints() != null) {
            this.owner.getRelationConstraints().check(this, relationType, content);
        }
        contentImpl.parent = this;
        contentImpl.relation = relationType;
        contentImpl.next = contentImpl2;
        if (contentImpl2 == null) {
            contentImpl.prev = this.lastChild;
            this.lastChild = contentImpl;
        } else {
            contentImpl.prev = contentImpl2.prev;
            contentImpl2.prev = contentImpl;
        }
        if (contentImpl.prev == null) {
            this.firstChild = contentImpl;
        } else {
            contentImpl.prev.next = contentImpl;
        }
        return content;
    }

    public Content replaceChild(Content.RelationType relationType, Content content, Content content2) {
        if (content2 == null) {
            throw new NullPointerException();
        }
        if (content == content2) {
            return content;
        }
        this.insertBefore(relationType, content, content2);
        return this.removeChild(content2);
    }

    public Content removeChild(Content content) {
        ContentImpl contentImpl = (ContentImpl)content;
        if (contentImpl == null) {
            throw new NullPointerException();
        }
        if (contentImpl.parent != this) {
            throw new IllegalArgumentException("" + content + " is NOT a child of " + this);
        }
        if (contentImpl.prev != null) {
            contentImpl.prev.next = contentImpl.next;
        } else {
            this.firstChild = contentImpl.next;
        }
        if (contentImpl.next != null) {
            contentImpl.next.prev = contentImpl.prev;
        } else {
            this.lastChild = contentImpl.prev;
        }
        contentImpl.next = null;
        contentImpl.prev = null;
        contentImpl.parent = null;
        return content;
    }

    public Content clone(boolean bl) {
        return this.clone(this.owner, bl, true);
    }

    Content clone(KeyObject keyObject, boolean bl, boolean bl2) {
        Content content = this.clone(keyObject, bl2);
        if (bl) {
            ContentImpl contentImpl = this.firstChild;
            while (contentImpl != null) {
                content.appendChild(contentImpl.relation, contentImpl.clone(keyObject, true, false));
                contentImpl = contentImpl.next;
            }
        }
        return content;
    }

    abstract Content clone(KeyObject var1, boolean var2);

    public void toDataset(Dataset dataset) {
        Date date;
        Template template;
        if (this.relation != null) {
            dataset.putCS(4235280, this.relation.toString());
        }
        dataset.putCS(0x40A040, this.getValueType().toString());
        DcmElement dcmElement = dataset.putSQ(4235331);
        Code code = this.getName();
        if (code != null) {
            code.toDataset(dcmElement.addNewItem());
        }
        if ((template = this.getTemplate()) != null) {
            template.toDataset(dataset.putSQ(4236548).addNewItem());
        }
        if ((date = this.getObservationDateTime(false)) != null) {
            dataset.putDT(4235314, date);
        }
        if (this.firstChild != null) {
            DcmElement dcmElement2 = dataset.putSQ(4237104);
            Content content = this.firstChild;
            while (content != null) {
                content.toDataset(dcmElement2.addNewItem());
                content = content.getNextSibling();
            }
        }
    }

    protected void initChilds(KeyObject keyObject, Dataset dataset) throws DcmValueException {
        DcmElement dcmElement = dataset.get(4237104);
        if (dcmElement == null) {
            return;
        }
        int n = 0;
        int n2 = dcmElement.vm();
        while (n < n2) {
            Dataset dataset2 = dcmElement.getItem(n);
            this.appendChild(Content.RelationType.valueOf(dataset2.getString(4235280)), ContentImpl.newContent(keyObject, dataset2));
            ++n;
        }
    }
}

