/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4cheri.server;

import java.io.File;
import java.io.FileFilter;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Timer;
import java.util.TimerTask;
import org.apache.log4j.Logger;
import org.apache.log4j.NDC;
import org.dcm4che.server.PollDirSrv;

public class PollDirSrvImpl
implements PollDirSrv {
    static final Logger log = Logger.getLogger("dcm4che.server.PollDirSrv");
    private static int instCount = 0;
    private String name = "PollDirSrv-" + ++instCount;
    private final PollDirSrv.Handler handler;
    private Timer timer = null;
    private Comparator sortCrit = null;
    private File pollDir = null;
    private File doneDir = null;
    private long pollPeriod;
    private int counter = 0;
    private int doneCount = 0;
    private int failCount = 0;
    private int openCount = 0;
    private int failOpenCount = 0;
    private long deltaLastModified = 1000L;
    private long openRetryPeriod = 60000L;
    private final FileFilter filter = new FileFilter(){

        public boolean accept(File file) {
            String string = file.getName();
            int n = 0;
            while (string.charAt(n) == '#') {
                if ((PollDirSrvImpl.this.counter >> n & 1) != 0) {
                    return false;
                }
                ++n;
            }
            return file.lastModified() + PollDirSrvImpl.this.deltaLastModified < System.currentTimeMillis();
        }
    };

    public PollDirSrvImpl(PollDirSrv.Handler handler) {
        if (handler == null) {
            throw new NullPointerException();
        }
        this.handler = handler;
    }

    public String toString() {
        return this.timer == null ? this.name + "[not running]" : this.name + "[poll " + this.pollDir + " all " + (float)this.pollPeriod / 1000.0f + " s]";
    }

    public void setSortCrit(Comparator comparator) {
        this.sortCrit = comparator;
    }

    public File getDoneDir() {
        return this.doneDir;
    }

    public void setDoneDir(File file) {
        this.doneDir = file;
    }

    public long getOpenRetryPeriod() {
        return this.openRetryPeriod;
    }

    public void setOpenRetryPeriod(long l) {
        this.openRetryPeriod = l;
    }

    public long getDeltaLastModified() {
        return this.deltaLastModified;
    }

    public void setDeltaLastModified(long l) {
        this.deltaLastModified = l;
    }

    public final int getDoneCount() {
        return this.doneCount;
    }

    public final int getFailCount() {
        return this.failCount;
    }

    public final int getOpenCount() {
        return this.openCount;
    }

    public final int getFailOpenCount() {
        return this.failOpenCount;
    }

    public void resetCounter() {
        this.counter = 0;
        this.doneCount = 0;
        this.failCount = 0;
        this.openCount = 0;
        this.failOpenCount = 0;
    }

    public void start(File file, long l) {
        if (!file.isDirectory()) {
            throw new IllegalArgumentException("pollDir: " + file);
        }
        if (l < 0L) {
            throw new IllegalArgumentException("pollPeriod: " + l);
        }
        if (this.timer != null) {
            throw new IllegalStateException("Already running");
        }
        this.pollDir = file;
        this.pollPeriod = l;
        this.timer = new Timer(false);
        log.info("Start " + this);
        this.timer.schedule(new TimerTask(){

            public void run() {
                PollDirSrvImpl.this.execute();
            }
        }, 0L, l);
    }

    public void stop() {
        if (this.timer == null) {
            return;
        }
        log.info("Stop " + this);
        this.timer.cancel();
        this.timer = null;
    }

    private void execute() {
        File[] fileArray;
        NDC.push(this.name);
        if (log.isDebugEnabled()) {
            log.debug("poll " + this.pollDir);
        }
        if ((fileArray = this.pollDir.listFiles(this.filter)).length > 0) {
            while (true) {
                try {
                    log.debug("open session");
                    this.handler.openSession();
                    ++this.openCount;
                }
                catch (Exception exception) {
                    ++this.failOpenCount;
                    log.error("open session failed:", exception);
                    try {
                        Thread.sleep(this.openRetryPeriod);
                    }
                    catch (InterruptedException interruptedException) {
                        log.warn(interruptedException);
                    }
                    continue;
                }
                break;
            }
            do {
                if (this.sortCrit != null) {
                    Arrays.sort(fileArray, this.sortCrit);
                }
                int n = 0;
                while (n < fileArray.length) {
                    try {
                        log.info("process " + fileArray[n]);
                        if (this.handler.process(fileArray[n])) {
                            ++this.doneCount;
                            this.success(fileArray[n]);
                        }
                    }
                    catch (Exception exception) {
                        ++this.failCount;
                        log.error("process " + fileArray[n] + " failed!", exception);
                        this.failed(fileArray[n]);
                    }
                    ++n;
                }
            } while ((fileArray = this.pollDir.listFiles(this.filter)).length > 0);
            this.handler.closeSession();
        }
        ++this.counter;
        NDC.pop();
    }

    private void success(File file) {
        if (this.doneDir != null) {
            this.moveFile(file, new File(this.doneDir, file.getName()));
        } else if (!file.delete()) {
            log.error("could not delete " + file);
        }
    }

    private void failed(File file) {
        this.moveFile(file, new File(file.getParentFile(), "#" + file.getName()));
    }

    private void moveFile(File file, File file2) {
        if (file.renameTo(file2)) {
            if (log.isDebugEnabled()) {
                log.debug("rename " + file + " to " + file2);
            }
        } else {
            log.error("could not rename " + file + " to " + file2);
        }
    }
}

