/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4cheri.net;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Iterator;
import java.util.LinkedList;
import org.dcm4che.net.PDUException;
import org.dcm4che.net.PDataTF;
import org.dcm4cheri.net.AAbortImpl;
import org.dcm4cheri.net.UnparsedPDUImpl;

final class PDataTFImpl
implements PDataTF {
    private static final int DEF_MAX_LENGTH = 65535;
    private static final int MIN_MAX_LENGTH = 128;
    private final byte[] buf;
    private int pdulen;
    private int wpos;
    private final LinkedList pdvs = new LinkedList();
    private final Iterator it;
    private PDVImpl curPDV = null;

    static PDataTFImpl parse(UnparsedPDUImpl unparsedPDUImpl) throws PDUException {
        if (unparsedPDUImpl.buffer() == null) {
            throw new PDUException("PDU length exceeds supported maximum " + unparsedPDUImpl, new AAbortImpl(2, 0));
        }
        return new PDataTFImpl(unparsedPDUImpl.length(), unparsedPDUImpl.buffer());
    }

    private PDataTFImpl(int n, byte[] byArray) throws PDUException {
        this.pdulen = n;
        this.wpos = n + 12;
        this.buf = byArray;
        int n2 = 6;
        while (n2 <= n) {
            PDVImpl pDVImpl = new PDVImpl(n2);
            this.pdvs.add(pDVImpl);
            n2 += 4 + pDVImpl.length();
        }
        if (n2 != n + 6) {
            throw new PDUException("Illegal " + this.toString(), new AAbortImpl(2, 6));
        }
        this.it = this.pdvs.iterator();
    }

    PDataTFImpl(int n) {
        if (n == 0) {
            n = 65535;
        }
        if (n < 128 || (long)n > 0x100000L) {
            throw new IllegalArgumentException("maxLength:" + n);
        }
        this.pdulen = 0;
        this.wpos = 12;
        this.buf = new byte[6 + n];
        this.it = null;
    }

    public void clear() {
        if (this.it != null) {
            throw new IllegalStateException("P-DATA-TF read only");
        }
        this.pdulen = 0;
        this.wpos = 12;
        this.pdvs.clear();
    }

    public PDataTF.PDV readPDV() {
        if (this.it == null) {
            throw new IllegalStateException("P-DATA-TF write only");
        }
        return this.it.hasNext() ? (PDataTF.PDV)this.it.next() : null;
    }

    public String toString(boolean bl) {
        return this.toString();
    }

    public String toString() {
        return this.toStringBuffer(new StringBuffer()).toString();
    }

    StringBuffer toStringBuffer(StringBuffer stringBuffer) {
        stringBuffer.append("P-DATA-TF[pdulen=").append(this.pdulen).append("]");
        Iterator iterator = this.pdvs.iterator();
        while (iterator.hasNext()) {
            stringBuffer.append("\n\t").append(iterator.next());
        }
        return stringBuffer;
    }

    public final int free() {
        return this.buf.length - this.wpos;
    }

    public void openPDV(int n, boolean bl) {
        if (this.it != null) {
            throw new IllegalStateException("P-DATA-TF read only");
        }
        if ((n & 1) == 0) {
            throw new IllegalArgumentException("pcid=" + n);
        }
        if (this.curPDV != null) {
            throw new IllegalStateException("Open PDV " + this.curPDV);
        }
        if (this.free() < 0) {
            throw new IllegalStateException("Maximal length of PDU reached");
        }
        this.curPDV = new PDVImpl(6 + this.pdulen);
        this.curPDV.pcid(n);
        this.curPDV.cmd(bl);
        this.pdulen += 6;
    }

    boolean isOpenPDV() {
        return this.curPDV != null;
    }

    boolean isEmpty() {
        return this.pdvs.isEmpty();
    }

    public void closePDV(boolean bl) {
        if (this.curPDV == null) {
            throw new IllegalStateException("No open PDV");
        }
        this.curPDV.last(bl);
        this.curPDV.close();
        this.pdvs.add(this.curPDV);
        this.curPDV = null;
        this.wpos += 6;
    }

    public final boolean write(int n) {
        if (this.curPDV == null) {
            throw new IllegalStateException("No open PDV");
        }
        if (this.wpos >= this.buf.length) {
            return false;
        }
        this.buf[this.wpos++] = (byte)n;
        ++this.pdulen;
        return true;
    }

    public final int write(byte[] byArray, int n, int n2) {
        if (this.curPDV == null) {
            throw new IllegalStateException("No open PDV");
        }
        int n3 = Math.min(n2, this.buf.length - this.wpos);
        System.arraycopy(byArray, n, this.buf, this.wpos, n3);
        this.wpos += n3;
        this.pdulen += n3;
        return n3;
    }

    public void writeTo(OutputStream outputStream) throws IOException {
        if (this.curPDV != null) {
            throw new IllegalStateException("Open PDV " + this.curPDV);
        }
        this.buf[0] = 4;
        this.buf[1] = 0;
        this.buf[2] = (byte)(this.pdulen >> 24);
        this.buf[3] = (byte)(this.pdulen >> 16);
        this.buf[4] = (byte)(this.pdulen >> 8);
        this.buf[5] = (byte)(this.pdulen >> 0);
        outputStream.write(this.buf, 0, this.pdulen + 6);
    }

    final class PDVImpl
    implements PDataTF.PDV {
        final int off;

        PDVImpl(int n) {
            this.off = n;
        }

        final void pcid(int n) {
            ((PDataTFImpl)PDataTFImpl.this).buf[this.off + 4] = (byte)n;
        }

        final void length(int n) {
            ((PDataTFImpl)PDataTFImpl.this).buf[this.off] = (byte)(n >> 24);
            ((PDataTFImpl)PDataTFImpl.this).buf[this.off + 1] = (byte)(n >> 16);
            ((PDataTFImpl)PDataTFImpl.this).buf[this.off + 2] = (byte)(n >> 8);
            ((PDataTFImpl)PDataTFImpl.this).buf[this.off + 3] = (byte)(n >> 0);
        }

        final void cmd(boolean bl) {
            if (bl) {
                byte[] byArray = PDataTFImpl.this.buf;
                int n = this.off + 5;
                byArray[n] = (byte)(byArray[n] | 1);
            } else {
                byte[] byArray = PDataTFImpl.this.buf;
                int n = this.off + 5;
                byArray[n] = (byte)(byArray[n] & 0xFFFFFFFE);
            }
        }

        final void last(boolean bl) {
            if (bl) {
                byte[] byArray = PDataTFImpl.this.buf;
                int n = this.off + 5;
                byArray[n] = (byte)(byArray[n] | 2);
            } else {
                byte[] byArray = PDataTFImpl.this.buf;
                int n = this.off + 5;
                byArray[n] = (byte)(byArray[n] & 0xFFFFFFFD);
            }
        }

        final void close() {
            this.length(PDataTFImpl.this.wpos - this.off - 4);
        }

        public final int length() {
            return (PDataTFImpl.this.buf[this.off] & 0xFF) << 24 | (PDataTFImpl.this.buf[this.off + 1] & 0xFF) << 16 | (PDataTFImpl.this.buf[this.off + 2] & 0xFF) << 8 | (PDataTFImpl.this.buf[this.off + 3] & 0xFF) << 0;
        }

        public final int pcid() {
            return PDataTFImpl.this.buf[this.off + 4] & 0xFF;
        }

        public final boolean cmd() {
            return (PDataTFImpl.this.buf[this.off + 5] & 1) != 0;
        }

        public final boolean last() {
            return (PDataTFImpl.this.buf[this.off + 5] & 2) != 0;
        }

        public final InputStream getInputStream() {
            return new ByteArrayInputStream(PDataTFImpl.this.buf, this.off + 6, this.length() - 2);
        }

        public String toString() {
            return this.toStringBuffer(new StringBuffer()).toString();
        }

        StringBuffer toStringBuffer(StringBuffer stringBuffer) {
            return stringBuffer.append("PDV[pc-").append(this.pcid()).append(this.cmd() ? ",cmd" : ",data").append(this.last() ? "(last),off=" : ",off=").append(this.off).append(",pdvlen=").append(this.length()).append("]");
        }
    }
}

