/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4cheri.net;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.util.Iterator;
import java.util.Timer;
import java.util.TimerTask;
import org.apache.log4j.Logger;
import org.apache.log4j.NDC;
import org.dcm4che.net.AAbort;
import org.dcm4che.net.AAssociateAC;
import org.dcm4che.net.AAssociateRJ;
import org.dcm4che.net.AAssociateRQ;
import org.dcm4che.net.AReleaseRP;
import org.dcm4che.net.AReleaseRQ;
import org.dcm4che.net.Association;
import org.dcm4che.net.AssociationListener;
import org.dcm4che.net.AsyncOpsWindow;
import org.dcm4che.net.Dimse;
import org.dcm4che.net.PDU;
import org.dcm4che.net.PDUException;
import org.dcm4che.net.PDataTF;
import org.dcm4che.net.PresContext;
import org.dcm4cheri.net.AAbortImpl;
import org.dcm4cheri.net.AAssociateACImpl;
import org.dcm4cheri.net.AAssociateRJImpl;
import org.dcm4cheri.net.AAssociateRQImpl;
import org.dcm4cheri.net.AReleaseRPImpl;
import org.dcm4cheri.net.AReleaseRQImpl;
import org.dcm4cheri.net.AssociationImpl;
import org.dcm4cheri.net.Multicaster;
import org.dcm4cheri.net.PDataTFImpl;
import org.dcm4cheri.net.UnparsedPDUImpl;
import org.dcm4cheri.util.LF_ThreadPool;

final class FsmImpl {
    static final Logger log = Logger.getLogger("dcm4che.net.Association");
    private final AssociationImpl assoc;
    private final boolean requestor;
    private final Socket s;
    private final InputStream in;
    private final OutputStream out;
    private static final Timer timer = new Timer(true);
    private int tcpCloseTimeout = 500;
    private AAssociateRQ rq = null;
    private AAssociateAC ac = null;
    private AAssociateRJ rj = null;
    private AAbort aa = null;
    private AssociationListener assocListener = null;
    private LF_ThreadPool pool = null;
    private final State STA1;
    private State state = this.STA1 = new State(1){

        public String toString() {
            return "Sta 1 - Idle";
        }

        void entry() {
            if (FsmImpl.this.pool != null) {
                FsmImpl.this.pool.shutdown();
            }
            if (FsmImpl.this.assocListener != null) {
                FsmImpl.this.assocListener.close(FsmImpl.this.assoc);
            }
            if (log.isInfoEnabled()) {
                log.info("closing connection - " + FsmImpl.this.s);
            }
            try {
                FsmImpl.this.in.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            try {
                FsmImpl.this.out.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            try {
                FsmImpl.this.s.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }

        void write(AAbort aAbort) throws IOException {
        }
    };
    private final State STA2 = new State(2){

        public String toString() {
            return "Sta 2 - Transport connection open (Awaiting A-ASSOCIATE-RQ PDU)";
        }

        PDU parse(UnparsedPDUImpl unparsedPDUImpl) throws PDUException {
            try {
                switch (unparsedPDUImpl.type()) {
                    case 1: {
                        FsmImpl.this.fireReceived(FsmImpl.this.rq = AAssociateRQImpl.parse(unparsedPDUImpl));
                        FsmImpl.this.changeState(FsmImpl.this.STA3);
                        return FsmImpl.this.rq;
                    }
                    case 2: 
                    case 3: 
                    case 4: 
                    case 5: 
                    case 6: {
                        throw new PDUException("Unexpected " + unparsedPDUImpl, new AAbortImpl(2, 2));
                    }
                    case 7: {
                        FsmImpl.this.fireReceived(FsmImpl.this.aa = AAbortImpl.parse(unparsedPDUImpl));
                        FsmImpl.this.changeState(FsmImpl.this.STA1);
                        return FsmImpl.this.aa;
                    }
                }
                throw new PDUException("Unrecognized " + unparsedPDUImpl, new AAbortImpl(2, 1));
            }
            catch (PDUException pDUException) {
                try {
                    this.write(pDUException.getAAbort());
                }
                catch (Exception exception) {
                    // empty catch block
                }
                throw pDUException;
            }
        }
    };
    private final State STA3 = new State(3){

        public String toString() {
            return "Sta 3 - Awaiting local A-ASSOCIATE response primitive";
        }

        void write(AAssociateAC aAssociateAC) throws IOException {
            try {
                aAssociateAC.writeTo(FsmImpl.this.out);
            }
            catch (IOException iOException) {
                FsmImpl.this.changeState(FsmImpl.this.STA1);
                throw iOException;
            }
            FsmImpl.this.changeState(FsmImpl.this.STA6);
        }

        void write(AAssociateRJ aAssociateRJ) throws IOException {
            try {
                aAssociateRJ.writeTo(FsmImpl.this.out);
            }
            catch (IOException iOException) {
                FsmImpl.this.changeState(FsmImpl.this.STA1);
                throw iOException;
            }
            FsmImpl.this.changeState(FsmImpl.this.STA13);
        }
    };
    private final State STA4 = new State(4){

        public String toString() {
            return "Sta 4 - Awaiting transport connection opening to complete";
        }

        void write(AAssociateRQ aAssociateRQ) throws IOException {
            try {
                aAssociateRQ.writeTo(FsmImpl.this.out);
            }
            catch (IOException iOException) {
                FsmImpl.this.changeState(FsmImpl.this.STA1);
                throw iOException;
            }
            FsmImpl.this.changeState(FsmImpl.this.STA5);
        }

        void write(AAbort aAbort) throws IOException {
            FsmImpl.this.changeState(FsmImpl.this.STA1);
        }
    };
    private final State STA5 = new State(5){

        public String toString() {
            return "Sta 5 - Awaiting A-ASSOCIATE-AC or A-ASSOCIATE-RJ PDU";
        }

        PDU parse(UnparsedPDUImpl unparsedPDUImpl) throws PDUException {
            try {
                switch (unparsedPDUImpl.type()) {
                    case 1: {
                        throw new PDUException("Unexpected " + unparsedPDUImpl, new AAbortImpl(2, 2));
                    }
                    case 2: {
                        FsmImpl.this.fireReceived(FsmImpl.this.ac = AAssociateACImpl.parse(unparsedPDUImpl));
                        FsmImpl.this.changeState(FsmImpl.this.STA6);
                        return FsmImpl.this.ac;
                    }
                    case 3: {
                        FsmImpl.this.fireReceived(FsmImpl.this.rj = AAssociateRJImpl.parse(unparsedPDUImpl));
                        FsmImpl.this.changeState(FsmImpl.this.STA13);
                        return FsmImpl.this.rj;
                    }
                    case 4: 
                    case 5: 
                    case 6: {
                        throw new PDUException("Unexpected " + unparsedPDUImpl, new AAbortImpl(2, 2));
                    }
                    case 7: {
                        FsmImpl.this.fireReceived(FsmImpl.this.aa = AAbortImpl.parse(unparsedPDUImpl));
                        FsmImpl.this.changeState(FsmImpl.this.STA1);
                        return FsmImpl.this.aa;
                    }
                }
                throw new PDUException("Unrecognized " + unparsedPDUImpl, new AAbortImpl(2, 1));
            }
            catch (PDUException pDUException) {
                try {
                    this.write(pDUException.getAAbort());
                }
                catch (Exception exception) {
                    // empty catch block
                }
                throw pDUException;
            }
        }
    };
    private final State STA6 = new State(6){

        public String toString() {
            return "Sta 6 - Association established and ready for data transfer";
        }

        public boolean isOpen() {
            return true;
        }

        public boolean canWritePDataTF() {
            return true;
        }

        public boolean canReadPDataTF() {
            return true;
        }

        PDU parse(UnparsedPDUImpl unparsedPDUImpl) throws PDUException {
            try {
                switch (unparsedPDUImpl.type()) {
                    case 1: 
                    case 2: 
                    case 3: {
                        throw new PDUException("Unexpected " + unparsedPDUImpl, new AAbortImpl(2, 2));
                    }
                    case 4: {
                        return FsmImpl.this.fireReceived(PDataTFImpl.parse(unparsedPDUImpl));
                    }
                    case 5: {
                        PDU pDU = FsmImpl.this.fireReceived(AReleaseRQImpl.parse(unparsedPDUImpl));
                        FsmImpl.this.changeState(FsmImpl.this.STA8);
                        return pDU;
                    }
                    case 6: {
                        throw new PDUException("Unexpected " + unparsedPDUImpl, new AAbortImpl(2, 2));
                    }
                    case 7: {
                        FsmImpl.this.fireReceived(FsmImpl.this.aa = AAbortImpl.parse(unparsedPDUImpl));
                        FsmImpl.this.changeState(FsmImpl.this.STA1);
                        return FsmImpl.this.aa;
                    }
                }
                throw new PDUException("Unrecognized " + unparsedPDUImpl, new AAbortImpl(2, 1));
            }
            catch (PDUException pDUException) {
                try {
                    this.write(pDUException.getAAbort());
                }
                catch (Exception exception) {
                    // empty catch block
                }
                throw pDUException;
            }
        }

        void write(PDataTF pDataTF) throws IOException {
            try {
                pDataTF.writeTo(FsmImpl.this.out);
            }
            catch (IOException iOException) {
                FsmImpl.this.changeState(FsmImpl.this.STA1);
                throw iOException;
            }
        }

        void write(AReleaseRQ aReleaseRQ) throws IOException {
            try {
                FsmImpl.this.changeState(FsmImpl.this.STA7);
                aReleaseRQ.writeTo(FsmImpl.this.out);
            }
            catch (IOException iOException) {
                FsmImpl.this.changeState(FsmImpl.this.STA1);
                throw iOException;
            }
        }
    };
    private final State STA7 = new State(7){

        public String toString() {
            return "Sta 7 - Awaiting A-RELEASE-RP PDU";
        }

        public boolean canReadPDataTF() {
            return true;
        }

        PDU parse(UnparsedPDUImpl unparsedPDUImpl) throws PDUException {
            try {
                switch (unparsedPDUImpl.type()) {
                    case 1: 
                    case 2: 
                    case 3: {
                        throw new PDUException("Unexpected " + unparsedPDUImpl, new AAbortImpl(2, 2));
                    }
                    case 4: {
                        return FsmImpl.this.fireReceived(PDataTFImpl.parse(unparsedPDUImpl));
                    }
                    case 5: {
                        PDU pDU = FsmImpl.this.fireReceived(AReleaseRQImpl.parse(unparsedPDUImpl));
                        FsmImpl.this.changeState(FsmImpl.this.requestor ? FsmImpl.this.STA9 : FsmImpl.this.STA10);
                        return pDU;
                    }
                    case 6: {
                        AReleaseRPImpl aReleaseRPImpl = AReleaseRPImpl.parse(unparsedPDUImpl);
                        FsmImpl.this.fireReceived(aReleaseRPImpl);
                        FsmImpl.this.changeState(FsmImpl.this.STA1);
                        return aReleaseRPImpl;
                    }
                    case 7: {
                        FsmImpl.this.fireReceived(FsmImpl.this.aa = AAbortImpl.parse(unparsedPDUImpl));
                        FsmImpl.this.changeState(FsmImpl.this.STA1);
                        return FsmImpl.this.aa;
                    }
                }
                throw new PDUException("Unrecognized " + unparsedPDUImpl, new AAbortImpl(2, 1));
            }
            catch (PDUException pDUException) {
                try {
                    this.write(pDUException.getAAbort());
                }
                catch (Exception exception) {
                    // empty catch block
                }
                throw pDUException;
            }
        }
    };
    private final State STA8 = new State(8){

        public String toString() {
            return "Sta 8 - Awaiting local A-RELEASE response primitive";
        }

        public boolean canWritePDataTF() {
            return true;
        }

        void write(PDataTF pDataTF) throws IOException {
            try {
                pDataTF.writeTo(FsmImpl.this.out);
            }
            catch (IOException iOException) {
                FsmImpl.this.changeState(FsmImpl.this.STA1);
                throw iOException;
            }
        }

        void write(AReleaseRP aReleaseRP) throws IOException {
            try {
                aReleaseRP.writeTo(FsmImpl.this.out);
            }
            catch (IOException iOException) {
                FsmImpl.this.changeState(FsmImpl.this.STA1);
                throw iOException;
            }
            FsmImpl.this.changeState(FsmImpl.this.STA13);
        }
    };
    private final State STA9 = new State(9){

        public String toString() {
            return "Sta 9 - Release collision requestor side; awaiting A-RELEASE response";
        }

        void write(AReleaseRP aReleaseRP) throws IOException {
            try {
                aReleaseRP.writeTo(FsmImpl.this.out);
            }
            catch (IOException iOException) {
                FsmImpl.this.changeState(FsmImpl.this.STA1);
                throw iOException;
            }
            FsmImpl.this.changeState(FsmImpl.this.STA11);
        }
    };
    private final State STA10 = new State(10){

        public String toString() {
            return "Sta 10 - Release collision acceptor side; awaiting A-RELEASE response";
        }

        PDU parse(UnparsedPDUImpl unparsedPDUImpl) throws PDUException {
            try {
                switch (unparsedPDUImpl.type()) {
                    case 1: 
                    case 2: 
                    case 3: 
                    case 4: 
                    case 5: {
                        throw new PDUException("Unexpected " + unparsedPDUImpl, new AAbortImpl(2, 2));
                    }
                    case 6: {
                        PDU pDU = FsmImpl.this.fireReceived(AReleaseRPImpl.parse(unparsedPDUImpl));
                        FsmImpl.this.changeState(FsmImpl.this.STA12);
                        return pDU;
                    }
                    case 7: {
                        FsmImpl.this.fireReceived(FsmImpl.this.aa = AAbortImpl.parse(unparsedPDUImpl));
                        FsmImpl.this.changeState(FsmImpl.this.STA1);
                        return FsmImpl.this.aa;
                    }
                }
                throw new PDUException("Unrecognized " + unparsedPDUImpl, new AAbortImpl(2, 1));
            }
            catch (PDUException pDUException) {
                try {
                    this.write(pDUException.getAAbort());
                }
                catch (Exception exception) {
                    // empty catch block
                }
                throw pDUException;
            }
        }
    };
    private final State STA11 = new State(11){

        public String toString() {
            return "Sta 11 - Release collision requestor side; awaiting A-RELEASE-RP PDU";
        }

        PDU parse(UnparsedPDUImpl unparsedPDUImpl) throws PDUException {
            try {
                switch (unparsedPDUImpl.type()) {
                    case 1: 
                    case 2: 
                    case 3: 
                    case 4: 
                    case 5: {
                        throw new PDUException("Unexpected " + unparsedPDUImpl, new AAbortImpl(2, 2));
                    }
                    case 6: {
                        PDU pDU = FsmImpl.this.fireReceived(AReleaseRPImpl.parse(unparsedPDUImpl));
                        FsmImpl.this.changeState(FsmImpl.this.STA1);
                        return pDU;
                    }
                    case 7: {
                        FsmImpl.this.fireReceived(FsmImpl.this.aa = AAbortImpl.parse(unparsedPDUImpl));
                        FsmImpl.this.changeState(FsmImpl.this.STA1);
                        return FsmImpl.this.aa;
                    }
                }
                throw new PDUException("Unrecognized " + unparsedPDUImpl, new AAbortImpl(2, 1));
            }
            catch (PDUException pDUException) {
                try {
                    this.write(pDUException.getAAbort());
                }
                catch (Exception exception) {
                    // empty catch block
                }
                throw pDUException;
            }
        }
    };
    private final State STA12 = new State(12){

        public String toString() {
            return "Sta 12 - Release collision acceptor side; awaiting A-RELEASE-RP PDU";
        }

        void write(AReleaseRP aReleaseRP) throws IOException {
            try {
                aReleaseRP.writeTo(FsmImpl.this.out);
            }
            catch (IOException iOException) {
                FsmImpl.this.changeState(FsmImpl.this.STA1);
                throw iOException;
            }
            FsmImpl.this.changeState(FsmImpl.this.STA13);
        }
    };
    private final State STA13 = new State(13){

        public String toString() {
            return "Sta 13 - Awaiting Transport Connection Close Indication";
        }

        void entry() {
            if (FsmImpl.this.pool != null) {
                FsmImpl.this.pool.shutdown();
            }
            timer.schedule(new TimerTask(this){
                private final /* synthetic */ 3 this$1;
                {
                    this.this$1 = var1_1;
                }

                public void run() {
                    NDC.push(FsmImpl.access$800(3.access$2400(this.this$1)).getName());
                    FsmImpl.access$300(3.access$2400(this.this$1), FsmImpl.access$200(3.access$2400(this.this$1)));
                    NDC.pop();
                }
            }, FsmImpl.this.tcpCloseTimeout);
        }

        static /* synthetic */ FsmImpl access$2400(3 var0) {
            return var0.FsmImpl.this;
        }
    };

    public FsmImpl(AssociationImpl associationImpl, Socket socket, boolean bl) throws IOException {
        this.assoc = associationImpl;
        this.requestor = bl;
        this.s = socket;
        this.in = socket.getInputStream();
        this.out = socket.getOutputStream();
        log.info(socket.toString());
        this.changeState(bl ? this.STA4 : this.STA2);
    }

    public synchronized void addAssociationListener(AssociationListener associationListener) {
        this.assocListener = Multicaster.add(this.assocListener, associationListener);
    }

    public synchronized void removeAssociationListener(AssociationListener associationListener) {
        this.assocListener = Multicaster.remove(this.assocListener, associationListener);
    }

    public void setThreadPool(LF_ThreadPool lF_ThreadPool) {
        this.pool = lF_ThreadPool;
    }

    final Socket socket() {
        return this.s;
    }

    final boolean isRequestor() {
        return this.requestor;
    }

    final void setTCPCloseTimeout(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("tcpCloseTimeout:" + n);
        }
        this.tcpCloseTimeout = n;
    }

    final int getTCPCloseTimeout() {
        return this.tcpCloseTimeout;
    }

    public int getState() {
        return this.state.getType();
    }

    public String getStateAsString() {
        return this.state.toString();
    }

    final int getWriteMaxLength() {
        if (this.ac == null || this.rq == null) {
            throw new IllegalStateException(this.state.toString());
        }
        return this.requestor ? this.ac.getMaxPDULength() : this.rq.getMaxPDULength();
    }

    final int getReadMaxLength() {
        if (this.ac == null || this.rq == null) {
            throw new IllegalStateException(this.state.toString());
        }
        return this.requestor ? this.rq.getMaxPDULength() : this.ac.getMaxPDULength();
    }

    final String getAcceptedTransferSyntaxUID(int n) {
        if (this.ac == null) {
            throw new IllegalStateException(this.state.toString());
        }
        PresContext presContext = this.ac.getPresContext(n);
        if (presContext == null || presContext.result() != 0) {
            return null;
        }
        return presContext.getTransferSyntaxUID();
    }

    final PresContext getAcceptedPresContext(String string, String string2) {
        if (this.ac == null) {
            throw new IllegalStateException(this.state.toString());
        }
        Iterator iterator = this.rq.listPresContext().iterator();
        while (iterator.hasNext()) {
            PresContext presContext;
            PresContext presContext2 = (PresContext)iterator.next();
            if (!string.equals(presContext2.getAbstractSyntaxUID()) || (presContext = this.ac.getPresContext(presContext2.pcid())) == null || presContext.result() != 0 || !string2.equals(presContext.getTransferSyntaxUID())) continue;
            return presContext;
        }
        return null;
    }

    int getMaxOpsInvoked() {
        if (this.ac == null) {
            throw new IllegalStateException(this.state.toString());
        }
        AsyncOpsWindow asyncOpsWindow = this.ac.getAsyncOpsWindow();
        if (asyncOpsWindow == null) {
            return 1;
        }
        return this.requestor ? asyncOpsWindow.getMaxOpsInvoked() : asyncOpsWindow.getMaxOpsPerformed();
    }

    int getMaxOpsPerformed() {
        if (this.ac == null) {
            throw new IllegalStateException(this.state.toString());
        }
        AsyncOpsWindow asyncOpsWindow = this.ac.getAsyncOpsWindow();
        if (asyncOpsWindow == null) {
            return 1;
        }
        return this.requestor ? asyncOpsWindow.getMaxOpsPerformed() : asyncOpsWindow.getMaxOpsInvoked();
    }

    private synchronized void changeState(State state) {
        if (this.state != state) {
            State state2 = this.state;
            this.state = state;
            state.entry();
            if (log.isInfoEnabled()) {
                log.info(state.toString());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PDU read(int n, byte[] byArray) throws IOException {
        try {
            UnparsedPDUImpl unparsedPDUImpl = null;
            InputStream inputStream = this.in;
            synchronized (inputStream) {
                this.s.setSoTimeout(n);
                try {
                    unparsedPDUImpl = new UnparsedPDUImpl(this.in, byArray);
                }
                catch (IOException iOException) {
                    this.changeState(this.STA1);
                    throw iOException;
                }
            }
            return this.state.parse(unparsedPDUImpl);
        }
        catch (IOException iOException) {
            if (this.assocListener != null) {
                this.assocListener.error(this.assoc, iOException);
            }
            throw iOException;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(AAssociateRQ aAssociateRQ) throws IOException {
        this.fireWrite(aAssociateRQ);
        try {
            OutputStream outputStream = this.out;
            synchronized (outputStream) {
                this.state.write(aAssociateRQ);
            }
        }
        catch (IOException iOException) {
            if (this.assocListener != null) {
                this.assocListener.error(this.assoc, iOException);
            }
            throw iOException;
        }
        this.rq = aAssociateRQ;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(AAssociateAC aAssociateAC) throws IOException {
        this.fireWrite(aAssociateAC);
        try {
            OutputStream outputStream = this.out;
            synchronized (outputStream) {
                this.state.write(aAssociateAC);
            }
        }
        catch (IOException iOException) {
            if (this.assocListener != null) {
                this.assocListener.error(this.assoc, iOException);
            }
            throw iOException;
        }
        this.ac = aAssociateAC;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(AAssociateRJ aAssociateRJ) throws IOException {
        this.fireWrite(aAssociateRJ);
        try {
            OutputStream outputStream = this.out;
            synchronized (outputStream) {
                this.state.write(aAssociateRJ);
            }
        }
        catch (IOException iOException) {
            if (this.assocListener != null) {
                this.assocListener.error(this.assoc, iOException);
            }
            throw iOException;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(PDataTF pDataTF) throws IOException {
        this.fireWrite(pDataTF);
        try {
            OutputStream outputStream = this.out;
            synchronized (outputStream) {
                this.state.write(pDataTF);
            }
        }
        catch (IOException iOException) {
            if (this.assocListener != null) {
                this.assocListener.error(this.assoc, iOException);
            }
            throw iOException;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(AReleaseRQ aReleaseRQ) throws IOException {
        this.fireWrite(aReleaseRQ);
        try {
            OutputStream outputStream = this.out;
            synchronized (outputStream) {
                this.state.write(aReleaseRQ);
            }
        }
        catch (IOException iOException) {
            if (this.assocListener != null) {
                this.assocListener.error(this.assoc, iOException);
            }
            throw iOException;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(AReleaseRP aReleaseRP) throws IOException {
        this.fireWrite(aReleaseRP);
        try {
            OutputStream outputStream = this.out;
            synchronized (outputStream) {
                this.state.write(aReleaseRP);
            }
        }
        catch (IOException iOException) {
            if (this.assocListener != null) {
                this.assocListener.error(this.assoc, iOException);
            }
            throw iOException;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(AAbort aAbort) throws IOException {
        this.fireWrite(aAbort);
        try {
            OutputStream outputStream = this.out;
            synchronized (outputStream) {
                this.state.write(aAbort);
            }
        }
        catch (IOException iOException) {
            if (this.assocListener != null) {
                this.assocListener.error(this.assoc, iOException);
            }
            throw iOException;
        }
    }

    void fireReceived(Dimse dimse) {
        if (log.isInfoEnabled()) {
            log.info("received " + dimse);
        }
        if (this.assocListener != null) {
            this.assocListener.received((Association)this.assoc, dimse);
        }
    }

    void fireWrite(Dimse dimse) {
        if (log.isInfoEnabled()) {
            log.info("sending " + dimse);
        }
        if (this.assocListener != null) {
            this.assocListener.write((Association)this.assoc, dimse);
        }
    }

    private void fireWrite(PDU pDU) {
        if (pDU instanceof PDataTF) {
            if (log.isDebugEnabled()) {
                log.debug("sending " + pDU);
            }
        } else if (log.isInfoEnabled()) {
            log.info("sending " + pDU.toString(log.isDebugEnabled()));
        }
        if (this.assocListener != null) {
            this.assocListener.write((Association)this.assoc, pDU);
        }
    }

    private PDU fireReceived(PDU pDU) {
        if (pDU instanceof PDataTF) {
            if (log.isDebugEnabled()) {
                log.debug("received " + pDU);
            }
        } else if (log.isInfoEnabled()) {
            log.info("received " + pDU.toString(log.isDebugEnabled()));
        }
        if (this.assocListener != null) {
            this.assocListener.received((Association)this.assoc, pDU);
        }
        return pDU;
    }

    private abstract class State {
        private final int type;

        State(int n) {
            this.type = n;
        }

        public final int getType() {
            return this.type;
        }

        public boolean isOpen() {
            return false;
        }

        public boolean canWritePDataTF() {
            return false;
        }

        public boolean canReadPDataTF() {
            return false;
        }

        void entry() {
        }

        PDU parse(UnparsedPDUImpl unparsedPDUImpl) throws PDUException {
            try {
                switch (unparsedPDUImpl.type()) {
                    case 1: 
                    case 2: 
                    case 3: 
                    case 4: 
                    case 5: 
                    case 6: {
                        throw new PDUException("Unexpected " + unparsedPDUImpl, new AAbortImpl(2, 2));
                    }
                    case 7: {
                        FsmImpl.this.fireReceived(FsmImpl.this.aa = AAbortImpl.parse(unparsedPDUImpl));
                        FsmImpl.this.changeState(FsmImpl.this.STA1);
                        return FsmImpl.this.aa;
                    }
                }
                throw new PDUException("Unrecognized " + unparsedPDUImpl, new AAbortImpl(2, 1));
            }
            catch (PDUException pDUException) {
                try {
                    this.write(pDUException.getAAbort());
                }
                catch (Exception exception) {
                    // empty catch block
                }
                throw pDUException;
            }
        }

        void write(AAssociateRQ aAssociateRQ) throws IOException {
            throw new IllegalStateException();
        }

        void write(AAssociateAC aAssociateAC) throws IOException {
            throw new IllegalStateException();
        }

        void write(AAssociateRJ aAssociateRJ) throws IOException {
            throw new IllegalStateException();
        }

        void write(PDataTF pDataTF) throws IOException {
            throw new IllegalStateException();
        }

        void write(AReleaseRQ aReleaseRQ) throws IOException {
            throw new IllegalStateException();
        }

        void write(AReleaseRP aReleaseRP) throws IOException {
            throw new IllegalStateException();
        }

        void write(AAbort aAbort) throws IOException {
            try {
                aAbort.writeTo(FsmImpl.this.out);
            }
            catch (IOException iOException) {
                FsmImpl.this.changeState(FsmImpl.this.STA1);
                throw iOException;
            }
            FsmImpl.this.changeState(FsmImpl.this.STA13);
        }
    }
}

