/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4cheri.net;

import java.io.IOException;
import java.io.OutputStream;
import org.dcm4che.data.Command;
import org.dcm4che.net.Dimse;
import org.dcm4cheri.net.DimseImpl;
import org.dcm4cheri.net.FsmImpl;
import org.dcm4cheri.net.PDataTFImpl;

final class DimseWriterImpl {
    private final FsmImpl fsm;
    private PDataTFImpl pDataTF = null;
    private int pcid;
    private boolean cmd;

    public DimseWriterImpl(FsmImpl fsmImpl) {
        this.fsm = fsmImpl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void write(Dimse dimse) throws IOException {
        this.pcid = dimse.pcid();
        String string = this.fsm.getAcceptedTransferSyntaxUID(this.pcid);
        if (string == null) {
            throw new IllegalStateException();
        }
        ((DimseImpl)dimse).setTransferSyntaxUID(string);
        this.fsm.fireWrite(dimse);
        if (this.pDataTF == null) {
            this.pDataTF = new PDataTFImpl(this.fsm.getWriteMaxLength());
        }
        this.cmd = true;
        this.pDataTF.openPDV(this.pcid, true);
        PDataTFOutputStream pDataTFOutputStream = new PDataTFOutputStream();
        Command command = dimse.getCommand();
        try {
            command.write(pDataTFOutputStream);
            Object var6_5 = null;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            ((OutputStream)pDataTFOutputStream).close();
            throw throwable;
        }
        ((OutputStream)pDataTFOutputStream).close();
        if (command.hasDataset()) {
            this.cmd = false;
            this.pDataTF.openPDV(this.pcid, false);
            pDataTFOutputStream = new PDataTFOutputStream();
            try {
                dimse.writeTo(pDataTFOutputStream, string);
                Object var8_8 = null;
            }
            catch (Throwable throwable) {
                Object var8_9 = null;
                ((OutputStream)pDataTFOutputStream).close();
                throw throwable;
            }
            ((OutputStream)pDataTFOutputStream).close();
            {
            }
        }
        this.flushPDataTF();
    }

    public void flushPDataTF() throws IOException {
        boolean bl = this.pDataTF.isOpenPDV();
        if (bl) {
            this.pDataTF.closePDV(false);
        }
        if (!this.pDataTF.isEmpty()) {
            this.fsm.write(this.pDataTF);
        }
        this.pDataTF.clear();
        if (bl) {
            this.pDataTF.openPDV(this.pcid, this.cmd);
        }
    }

    private void closeStream() throws IOException {
        this.pDataTF.closePDV(true);
        if (!this.cmd) {
            this.flushPDataTF();
        }
    }

    private class PDataTFOutputStream
    extends OutputStream {
        private PDataTFOutputStream() {
        }

        public final void write(int n) throws IOException {
            if (DimseWriterImpl.this.pDataTF.free() == 0) {
                DimseWriterImpl.this.flushPDataTF();
            }
            DimseWriterImpl.this.pDataTF.write(n);
        }

        public final void write(byte[] byArray, int n, int n2) throws IOException {
            if (n2 == 0) {
                return;
            }
            int n3 = 0;
            while (true) {
                int n4 = Math.min(DimseWriterImpl.this.pDataTF.free(), n2 - n3);
                DimseWriterImpl.this.pDataTF.write(byArray, n + n3, n4);
                if ((n3 += n4) == n2) {
                    return;
                }
                DimseWriterImpl.this.flushPDataTF();
            }
        }

        public void close() throws IOException {
            DimseWriterImpl.this.closeStream();
        }
    }
}

