/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4cheri.net;

import java.io.IOException;
import java.net.Socket;
import org.apache.log4j.NDC;
import org.dcm4che.net.AAbort;
import org.dcm4che.net.AAssociateAC;
import org.dcm4che.net.AAssociateRJ;
import org.dcm4che.net.AAssociateRQ;
import org.dcm4che.net.AcceptorPolicy;
import org.dcm4che.net.Association;
import org.dcm4che.net.AssociationListener;
import org.dcm4che.net.Dimse;
import org.dcm4che.net.PDU;
import org.dcm4che.net.PresContext;
import org.dcm4cheri.net.AReleaseRQImpl;
import org.dcm4cheri.net.DimseReaderImpl;
import org.dcm4cheri.net.DimseWriterImpl;
import org.dcm4cheri.net.FsmImpl;
import org.dcm4cheri.util.LF_ThreadPool;

final class AssociationImpl
implements Association {
    private final FsmImpl fsm;
    private final DimseReaderImpl reader;
    private final DimseWriterImpl writer;
    private int msgID = 0;
    private final byte[] b10 = new byte[10];
    private String name = "Assoc-" + ++assocCount;
    private static int assocCount = 0;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AssociationImpl(Socket socket, boolean bl) throws IOException {
        NDC.push(this.name);
        try {
            this.fsm = new FsmImpl(this, socket, bl);
            this.reader = new DimseReaderImpl(this.fsm);
            this.writer = new DimseWriterImpl(this.fsm);
            Object var4_3 = null;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            NDC.pop();
            throw throwable;
        }
        NDC.pop();
    }

    public void setName(String string) {
        this.name = string;
    }

    public final String getName() {
        return this.name;
    }

    public final String toString() {
        return this.name + "[" + this.getStateAsString() + "]";
    }

    public void addAssociationListener(AssociationListener associationListener) {
        this.fsm.addAssociationListener(associationListener);
    }

    public void removeAssociationListener(AssociationListener associationListener) {
        this.fsm.removeAssociationListener(associationListener);
    }

    public final int getState() {
        return this.fsm.getState();
    }

    public final String getStateAsString() {
        return this.fsm.getStateAsString();
    }

    public final synchronized int nextMsgID() {
        return ++this.msgID;
    }

    public int getMaxOpsInvoked() {
        return this.fsm.getMaxOpsInvoked();
    }

    public int getMaxOpsPerformed() {
        return this.fsm.getMaxOpsPerformed();
    }

    public void setThreadPool(LF_ThreadPool lF_ThreadPool) {
        this.fsm.setThreadPool(lF_ThreadPool);
        this.reader.setThreadPool(lF_ThreadPool);
    }

    public final void setTCPCloseTimeout(int n) {
        this.fsm.setTCPCloseTimeout(n);
    }

    public final int getTCPCloseTimeout() {
        return this.fsm.getTCPCloseTimeout();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final PDU connect(AAssociateRQ aAssociateRQ, int n) throws IOException {
        PDU pDU;
        NDC.push(this.name);
        try {
            this.fsm.write(aAssociateRQ);
            pDU = this.fsm.read(n, this.b10);
            Object var5_4 = null;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            NDC.pop();
            throw throwable;
        }
        NDC.pop();
        return pDU;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final PDU accept(AcceptorPolicy acceptorPolicy, int n) throws IOException {
        PDU pDU;
        block5: {
            AAbort aAbort;
            NDC.push(this.name);
            try {
                pDU = this.fsm.read(n, this.b10);
                if (pDU instanceof AAssociateRQ) break block5;
                aAbort = (AAbort)pDU;
                Object var8_5 = null;
            }
            catch (Throwable throwable) {
                Object var8_7 = null;
                NDC.pop();
                throw throwable;
            }
            NDC.pop();
            return aAbort;
        }
        PDU pDU2 = acceptorPolicy.negotiate((AAssociateRQ)pDU);
        if (pDU2 instanceof AAssociateAC) {
            this.fsm.write((AAssociateAC)pDU2);
        } else {
            this.fsm.write((AAssociateRJ)pDU2);
        }
        PDU pDU3 = pDU2;
        Object var8_6 = null;
        NDC.pop();
        return pDU3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Dimse read(int n) throws IOException {
        Dimse dimse;
        NDC.push(this.name);
        try {
            Dimse dimse2 = this.reader.read(n);
            if (dimse2 != null) {
                this.msgID = Math.max(dimse2.getCommand().getMessageID(), this.msgID);
            }
            dimse = dimse2;
            Object var5_4 = null;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            NDC.pop();
            throw throwable;
        }
        NDC.pop();
        return dimse;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void write(Dimse dimse) throws IOException {
        NDC.push(this.name);
        try {
            this.msgID = Math.max(dimse.getCommand().getMessageID(), this.msgID);
            this.writer.write(dimse);
            Object var3_2 = null;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            NDC.pop();
            throw throwable;
        }
        NDC.pop();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final PDU release(int n) throws IOException {
        PDU pDU;
        NDC.push(this.name);
        try {
            this.fsm.write(AReleaseRQImpl.getInstance());
            pDU = this.fsm.read(n, this.b10);
            Object var4_3 = null;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            NDC.pop();
            throw throwable;
        }
        NDC.pop();
        return pDU;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void writeReleaseRQ() throws IOException {
        NDC.push(this.name);
        try {
            this.fsm.write(AReleaseRQImpl.getInstance());
            Object var2_1 = null;
        }
        catch (Throwable throwable) {
            Object var2_2 = null;
            NDC.pop();
            throw throwable;
        }
        NDC.pop();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void abort(AAbort aAbort) throws IOException {
        NDC.push(this.name);
        try {
            this.fsm.write(aAbort);
            Object var3_2 = null;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            NDC.pop();
            throw throwable;
        }
        NDC.pop();
    }

    public final String getAcceptedTransferSyntaxUID(int n) {
        return this.fsm.getAcceptedTransferSyntaxUID(n);
    }

    public final PresContext getAcceptedPresContext(String string, String string2) {
        return this.fsm.getAcceptedPresContext(string, string2);
    }
}

