/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4cheri.imageio.plugins;

import javax.imageio.metadata.IIOMetadataNode;
import javax.xml.transform.sax.SAXResult;
import javax.xml.transform.sax.TransformerHandler;
import org.dcm4che.data.Dataset;
import org.dcm4che.data.DcmObjectFactory;
import org.dcm4che.dict.DictionaryFactory;
import org.dcm4che.dict.TagDictionary;
import org.dcm4che.imageio.plugins.DcmMetadata;
import org.dcm4cheri.imageio.plugins.DcmImageReaderConf;
import org.w3c.dom.Node;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.helpers.DefaultHandler;

final class DcmMetadataImpl
extends DcmMetadata {
    static final DcmImageReaderConf conf = DcmImageReaderConf.getInstance();
    private Dataset ds;
    private TagDictionary dict = DictionaryFactory.getInstance().getDefaultTagDictionary();

    public DcmMetadataImpl(Dataset dataset) {
        super(false, conf.getExtraStreamMetadataFormatNames(), conf.getExtraStreamMetadataFormatClassNames());
        this.ds = dataset;
    }

    public final Dataset getDataset() {
        return this.ds;
    }

    public final void setDataset(Dataset dataset) {
        this.ds = dataset;
    }

    public final void setDictionary(TagDictionary tagDictionary) {
        this.dict = tagDictionary;
    }

    public final boolean isReadOnly() {
        return false;
    }

    public Node getAsTree(String string) {
        if (string.equals("dcm4che_imageio_dicom_1.0")) {
            return this.getTree(string, null, null);
        }
        if (string.equals("javax_imageio_1.0")) {
            throw new IllegalArgumentException("javax_imageio_1.0 not supported!");
        }
        if (conf.contains(string)) {
            return this.getTree(string, conf.getFilterDataset(string), conf.getTransformerHandler(string));
        }
        throw new IllegalArgumentException("Not a recognized format: " + string);
    }

    private Node getTree(String string, Dataset dataset, TransformerHandler transformerHandler) {
        final IIOMetadataNode iIOMetadataNode = new IIOMetadataNode(string);
        ContentHandler contentHandler = new DefaultHandler(){
            Node curNode;
            {
                this.curNode = iIOMetadataNode;
            }

            public void startElement(String string, String string2, String string3, Attributes attributes) {
                if ("dicomfile".equals(string3)) {
                    return;
                }
                IIOMetadataNode iIOMetadataNode2 = new IIOMetadataNode(string3);
                int n = 0;
                int n2 = attributes.getLength();
                while (n < n2) {
                    String string4 = attributes.getQName(n);
                    if (!"pos".equals(string4)) {
                        iIOMetadataNode2.setAttribute(string4, attributes.getValue(n));
                    }
                    ++n;
                }
                this.curNode.appendChild(iIOMetadataNode2);
                this.curNode = iIOMetadataNode2;
            }

            public void endElement(String string, String string2, String string3) {
                if ("dicomfile".equals(string3)) {
                    return;
                }
                this.curNode = this.curNode.getParentNode();
            }
        };
        try {
            if (transformerHandler != null) {
                transformerHandler.setResult(new SAXResult(contentHandler));
                contentHandler = transformerHandler;
            }
            this.ds.subSet(dataset).writeFile(contentHandler, this.dict);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new RuntimeException("Exception in getTree", exception);
        }
        return iIOMetadataNode;
    }

    public void mergeTree(String string, Node node) {
        throw new IllegalStateException("Metadata is read-only!");
    }

    public void reset() {
        this.ds = DcmObjectFactory.getInstance().newDataset();
    }

    public void setFromTree(String string, Node node) {
        this.reset();
        this.mergeTree(string, node);
    }
}

