/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4cheri.hl7;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.dcm4che.hl7.HL7Message;
import org.dcm4che.hl7.MSHSegment;
import org.dcm4cheri.hl7.HL7SegmentImpl;
import org.dcm4cheri.hl7.MSHSegmentImpl;

public class HL7MessageImpl
implements HL7Message {
    private final MSHSegmentImpl msh;
    private final ArrayList segs = new ArrayList(4);

    private static int indexOfNextCRorLF(byte[] byArray, int n) {
        int n2 = n;
        while (n2 < byArray.length) {
            if (byArray[n2] == 13 || byArray[n2] == 10) {
                return n2;
            }
            if (byArray[n2] == 92) {
                ++n2;
            }
            ++n2;
        }
        return byArray.length;
    }

    HL7MessageImpl(byte[] byArray) {
        int n = HL7MessageImpl.indexOfNextCRorLF(byArray, 0);
        this.msh = new MSHSegmentImpl(byArray, 0, n);
        while (++n < byArray.length) {
            int n2 = HL7MessageImpl.indexOfNextCRorLF(byArray, n);
            int n3 = n2 - n;
            if (n3 > 0) {
                this.segs.add(new HL7SegmentImpl(byArray, n, n3));
            }
            n = n2;
        }
    }

    public MSHSegment header() {
        return this.msh;
    }

    public List segments() {
        return Collections.unmodifiableList(this.segs);
    }

    public String toString() {
        return this.segs.toString();
    }

    StringBuffer toVerboseStringBuffer(StringBuffer stringBuffer) {
        stringBuffer.append(this.msh.getMessageType()).append('^').append(this.msh.getTriggerEvent()).append(" message\t// ").append(HL7SegmentImpl.getName(this.msh.getMessageType(), "????")).append(" - ").append(HL7SegmentImpl.getName(this.msh.getTriggerEvent(), "????"));
        stringBuffer.append("\n\t");
        this.msh.toVerboseStringBuffer(stringBuffer);
        Iterator iterator = this.segs.iterator();
        while (iterator.hasNext()) {
            stringBuffer.append("\n\t");
            ((HL7SegmentImpl)iterator.next()).toVerboseStringBuffer(stringBuffer);
        }
        return stringBuffer;
    }

    public String toVerboseString() {
        return this.toVerboseStringBuffer(new StringBuffer()).toString();
    }
}

