/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4cheri.dict;

import java.io.File;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Iterator;
import org.dcm4che.dict.UIDDictionary;
import org.dcm4cheri.dict.UIDDictionaryLoader;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class UIDDictionaryImpl
implements UIDDictionary,
Serializable {
    static final long serialVersionUID = -4793624142653062179L;
    private transient HashMap map = new HashMap(257);

    public UIDDictionary.Entry lookup(String string) {
        UIDDictionary.Entry entry = (UIDDictionary.Entry)this.map.get(string);
        return entry != null ? entry : new UIDDictionary.Entry(string, "");
    }

    public String toString(String string) {
        return this.lookup(string).toString();
    }

    public final void add(UIDDictionary.Entry entry) {
        this.map.put(entry.uid, entry);
    }

    public int size() {
        return this.map.size();
    }

    public void load(InputSource inputSource) throws IOException, SAXException {
        new UIDDictionaryLoader(this).parse(inputSource);
    }

    public void load(File file) throws IOException, SAXException {
        new UIDDictionaryLoader(this).parse(file);
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.writeInt(this.map.size());
        Iterator iterator = this.map.values().iterator();
        while (iterator.hasNext()) {
            UIDDictionary.Entry entry = (UIDDictionary.Entry)iterator.next();
            objectOutputStream.writeUTF(entry.uid);
            objectOutputStream.writeUTF(entry.name);
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException {
        int n = objectInputStream.readInt();
        this.map = new HashMap(n * 4 / 3 + 1);
        int n2 = 0;
        while (n2 < n) {
            this.add(new UIDDictionary.Entry(objectInputStream.readUTF(), objectInputStream.readUTF()));
            ++n2;
        }
    }
}

