/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4cheri.dict;

import java.io.File;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Iterator;
import org.dcm4che.dict.TagDictionary;
import org.dcm4che.dict.Tags;
import org.dcm4cheri.dict.TagDictionaryLoader;
import org.dcm4cheri.util.IntHashtable2;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class TagDictionaryImpl
implements TagDictionary,
Serializable {
    static final long serialVersionUID = 5940638712350400261L;
    private transient IntHashtable2[] tables = new IntHashtable2[]{new IntHashtable2()};

    public TagDictionary.Entry lookup(int n) {
        int n2 = 0;
        while (n2 < this.tables.length) {
            Object object = this.tables[n2].get(n);
            if (object != null) {
                return (TagDictionary.Entry)object;
            }
            ++n2;
        }
        return null;
    }

    public String toString(int n) {
        TagDictionary.Entry entry = this.lookup(n);
        return entry != null ? Tags.toString(n) + " " + entry.name : Tags.toString(n);
    }

    public final void add(TagDictionary.Entry entry) {
        this.getTableForMask(entry.mask).put(entry.tag, entry);
    }

    public int size() {
        int n = 0;
        int n2 = 0;
        while (n2 < this.tables.length) {
            n += this.tables[n2].size();
            ++n2;
        }
        return n;
    }

    private IntHashtable2 getTableForMask(int n) {
        int n2 = 0;
        while (n2 < this.tables.length) {
            if (n == this.tables[n2].mask()) {
                return this.tables[n2];
            }
            ++n2;
        }
        IntHashtable2[] intHashtable2Array = this.tables;
        this.tables = new IntHashtable2[intHashtable2Array.length + 1];
        System.arraycopy(intHashtable2Array, 0, this.tables, 0, intHashtable2Array.length);
        IntHashtable2 intHashtable2 = new IntHashtable2();
        intHashtable2.mask(n);
        this.tables[intHashtable2Array.length] = intHashtable2;
        intHashtable2Array = null;
        return intHashtable2;
    }

    public void load(InputSource inputSource) throws IOException, SAXException {
        new TagDictionaryLoader(this).parse(inputSource);
    }

    public void load(File file) throws IOException, SAXException {
        new TagDictionaryLoader(this).parse(file);
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.writeInt(this.tables.length);
        int n = 0;
        while (n < this.tables.length) {
            this.writeTable(objectOutputStream, this.tables[n]);
            ++n;
        }
    }

    private void writeTable(ObjectOutputStream objectOutputStream, IntHashtable2 intHashtable2) throws IOException {
        objectOutputStream.writeInt(intHashtable2.mask());
        objectOutputStream.writeInt(intHashtable2.size());
        Iterator iterator = intHashtable2.iterator();
        while (iterator.hasNext()) {
            TagDictionary.Entry entry = (TagDictionary.Entry)iterator.next();
            objectOutputStream.writeInt(entry.tag);
            objectOutputStream.writeUTF(entry.vr);
            objectOutputStream.writeUTF(entry.vm);
            objectOutputStream.writeUTF(entry.name);
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException {
        this.tables = new IntHashtable2[objectInputStream.readInt()];
        int n = 0;
        while (n < this.tables.length) {
            this.tables[n] = this.readTable(objectInputStream);
            ++n;
        }
    }

    private IntHashtable2 readTable(ObjectInputStream objectInputStream) throws IOException {
        int n = objectInputStream.readInt();
        int n2 = objectInputStream.readInt();
        IntHashtable2 intHashtable2 = new IntHashtable2(n2);
        intHashtable2.mask(n);
        int n3 = 0;
        while (n3 < n2) {
            TagDictionary.Entry entry = new TagDictionary.Entry(objectInputStream.readInt(), n, objectInputStream.readUTF(), objectInputStream.readUTF(), objectInputStream.readUTF());
            intHashtable2.put(entry.tag, entry);
            ++n3;
        }
        return intHashtable2;
    }
}

