/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4cheri.data;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.charset.Charset;
import org.dcm4che.data.DcmElement;
import org.dcm4che.data.DcmValueException;
import org.dcm4che.dict.Tags;
import org.dcm4cheri.data.DcmElementImpl;
import org.dcm4cheri.util.StringUtils;

abstract class ValueElement
extends DcmElementImpl {
    protected final ByteBuffer data;

    ValueElement(int n, ByteBuffer byteBuffer) {
        super(n);
        this.data = byteBuffer;
    }

    public final int length() {
        return this.data.limit() + 1 & 0xFFFFFFFE;
    }

    public final ByteBuffer getByteBuffer() {
        return (ByteBuffer)this.data.rewind();
    }

    public final ByteBuffer getByteBuffer(ByteOrder byteOrder) {
        if (this.data.order() != byteOrder) {
            this.swapOrder();
        }
        return (ByteBuffer)this.data.rewind();
    }

    public int vm() {
        return this.data.limit() == 0 ? 0 : 1;
    }

    public String getString(int n, Charset charset) throws DcmValueException {
        if (n >= this.vm()) {
            return n == 0 ? "" : null;
        }
        return String.valueOf(this.getInt(n));
    }

    public String[] getStrings(Charset charset) throws DcmValueException {
        String[] stringArray = new String[this.vm()];
        int n = 0;
        while (n < stringArray.length) {
            stringArray[n] = String.valueOf(this.getInt(n));
            ++n;
        }
        return stringArray;
    }

    protected void swapOrder() {
        this.data.order(DcmElementImpl.swap(this.data.order()));
    }

    private static ByteBuffer setShort(int n) {
        return ByteBuffer.wrap(new byte[2]).order(ByteOrder.LITTLE_ENDIAN).putShort((short)n);
    }

    private static ByteBuffer setShorts(int[] nArray) {
        if (nArray.length == 0) {
            return DcmElementImpl.EMPTY_VALUE;
        }
        if (nArray.length == 1) {
            return ValueElement.setShort(nArray[0]);
        }
        ByteBuffer byteBuffer = ByteBuffer.wrap(new byte[nArray.length << 1]).order(ByteOrder.LITTLE_ENDIAN);
        int n = 0;
        while (n < nArray.length) {
            byteBuffer.putShort((short)nArray[n]);
            ++n;
        }
        return byteBuffer;
    }

    static DcmElement createSS(int n, ByteBuffer byteBuffer) {
        if ((byteBuffer.limit() & 1) != 0) {
            DcmElementImpl.log.warn("Ignore illegal value of " + Tags.toString(n) + " SS #" + byteBuffer.limit());
            return new SS(n, DcmElementImpl.EMPTY_VALUE);
        }
        return new SS(n, byteBuffer);
    }

    static DcmElement createSS(int n) {
        return new SS(n, DcmElementImpl.EMPTY_VALUE);
    }

    static DcmElement createSS(int n, int n2) {
        return new SS(n, ValueElement.setShort(n2));
    }

    static DcmElement createSS(int n, int[] nArray) {
        return new SS(n, ValueElement.setShorts(nArray));
    }

    static DcmElement createUS(int n, ByteBuffer byteBuffer) {
        if ((byteBuffer.limit() & 1) != 0) {
            DcmElementImpl.log.warn("Ignore illegal value of " + Tags.toString(n) + " US #" + byteBuffer.limit());
            return new US(n, DcmElementImpl.EMPTY_VALUE);
        }
        return new US(n, byteBuffer);
    }

    static DcmElement createUS(int n) {
        return new US(n, DcmElementImpl.EMPTY_VALUE);
    }

    static DcmElement createUS(int n, int n2) {
        return new US(n, ValueElement.setShort(n2));
    }

    static DcmElement createUS(int n, int[] nArray) {
        return new US(n, ValueElement.setShorts(nArray));
    }

    private static ByteBuffer setInt(int n) {
        return ByteBuffer.wrap(new byte[4]).order(ByteOrder.LITTLE_ENDIAN).putInt(n);
    }

    private static ByteBuffer setInts(int[] nArray) {
        if (nArray.length == 0) {
            return DcmElementImpl.EMPTY_VALUE;
        }
        if (nArray.length == 1) {
            return ValueElement.setInt(nArray[0]);
        }
        ByteBuffer byteBuffer = ByteBuffer.wrap(new byte[nArray.length << 2]).order(ByteOrder.LITTLE_ENDIAN);
        int n = 0;
        while (n < nArray.length) {
            byteBuffer.putInt(nArray[n]);
            ++n;
        }
        return byteBuffer;
    }

    static DcmElement createSL(int n, ByteBuffer byteBuffer) {
        if ((byteBuffer.limit() & 3) != 0) {
            DcmElementImpl.log.warn("Ignore illegal value of " + Tags.toString(n) + " SL #" + byteBuffer.limit());
            return new SL(n, DcmElementImpl.EMPTY_VALUE);
        }
        return new SL(n, byteBuffer);
    }

    static DcmElement createSL(int n) {
        return new SL(n, DcmElementImpl.EMPTY_VALUE);
    }

    static DcmElement createSL(int n, int n2) {
        return new SL(n, ValueElement.setInt(n2));
    }

    static DcmElement createSL(int n, int[] nArray) {
        return new SL(n, ValueElement.setInts(nArray));
    }

    static DcmElement createUL(int n, ByteBuffer byteBuffer) {
        if ((byteBuffer.limit() & 3) != 0) {
            DcmElementImpl.log.warn("Ignore illegal value of " + Tags.toString(n) + " UL #" + byteBuffer.limit());
            return new UL(n, DcmElementImpl.EMPTY_VALUE);
        }
        return new UL(n, byteBuffer);
    }

    static DcmElement createUL(int n) {
        return new UL(n, DcmElementImpl.EMPTY_VALUE);
    }

    static DcmElement createUL(int n, int n2) {
        return new UL(n, ValueElement.setInt(n2));
    }

    static DcmElement createUL(int n, int[] nArray) {
        return new UL(n, ValueElement.setInts(nArray));
    }

    private static ByteBuffer setTag(int n) {
        return ByteBuffer.wrap(new byte[4]).order(ByteOrder.LITTLE_ENDIAN).putShort((short)(n >> 8)).putShort((short)n);
    }

    private static ByteBuffer setTags(int[] nArray) {
        if (nArray.length == 0) {
            return DcmElementImpl.EMPTY_VALUE;
        }
        if (nArray.length == 1) {
            return ValueElement.setTag(nArray[0]);
        }
        ByteBuffer byteBuffer = ByteBuffer.wrap(new byte[nArray.length << 2]).order(ByteOrder.LITTLE_ENDIAN);
        int n = 0;
        while (n < nArray.length) {
            byteBuffer.putShort((short)(nArray[n] >> 16)).putShort((short)nArray[n]);
            ++n;
        }
        return byteBuffer;
    }

    static DcmElement createAT(int n, ByteBuffer byteBuffer) {
        if ((byteBuffer.limit() & 3) != 0) {
            DcmElementImpl.log.warn("Ignore illegal value of " + Tags.toString(n) + " AT #" + byteBuffer.limit());
            return new AT(n, DcmElementImpl.EMPTY_VALUE);
        }
        return new AT(n, byteBuffer);
    }

    static DcmElement createAT(int n) {
        return new AT(n, DcmElementImpl.EMPTY_VALUE);
    }

    static DcmElement createAT(int n, int n2) {
        return new AT(n, ValueElement.setTag(n2));
    }

    static DcmElement createAT(int n, int[] nArray) {
        return new AT(n, ValueElement.setTags(nArray));
    }

    private static ByteBuffer setFloat(float f) {
        return ByteBuffer.wrap(new byte[4]).order(ByteOrder.LITTLE_ENDIAN).putFloat(f);
    }

    private static ByteBuffer setFloats(float[] fArray) {
        if (fArray.length == 0) {
            return DcmElementImpl.EMPTY_VALUE;
        }
        if (fArray.length == 1) {
            return ValueElement.setFloat(fArray[0]);
        }
        ByteBuffer byteBuffer = ByteBuffer.wrap(new byte[fArray.length << 2]).order(ByteOrder.LITTLE_ENDIAN);
        int n = 0;
        while (n < fArray.length) {
            byteBuffer.putFloat(fArray[n]);
            ++n;
        }
        return byteBuffer;
    }

    static DcmElement createFL(int n, ByteBuffer byteBuffer) {
        if ((byteBuffer.limit() & 3) != 0) {
            DcmElementImpl.log.warn("Ignore illegal value of " + Tags.toString(n) + " FL #" + byteBuffer.limit());
            return new FL(n, DcmElementImpl.EMPTY_VALUE);
        }
        return new FL(n, byteBuffer);
    }

    static DcmElement createFL(int n) {
        return new FL(n, DcmElementImpl.EMPTY_VALUE);
    }

    static DcmElement createFL(int n, float f) {
        return new FL(n, ValueElement.setFloat(f));
    }

    static DcmElement createFL(int n, float[] fArray) {
        return new FL(n, ValueElement.setFloats(fArray));
    }

    private static ByteBuffer setDouble(double d) {
        return ByteBuffer.wrap(new byte[8]).order(ByteOrder.LITTLE_ENDIAN).putDouble(d);
    }

    private static ByteBuffer setDoubles(double[] dArray) {
        if (dArray.length == 0) {
            return DcmElementImpl.EMPTY_VALUE;
        }
        if (dArray.length == 1) {
            return ValueElement.setDouble(dArray[0]);
        }
        ByteBuffer byteBuffer = ByteBuffer.wrap(new byte[dArray.length << 3]).order(ByteOrder.LITTLE_ENDIAN);
        int n = 0;
        while (n < dArray.length) {
            byteBuffer.putDouble(dArray[n]);
            ++n;
        }
        return byteBuffer;
    }

    static DcmElement createFD(int n, ByteBuffer byteBuffer) {
        if ((byteBuffer.limit() & 7) != 0) {
            DcmElementImpl.log.warn("Ignore illegal value of " + Tags.toString(n) + " FD #" + byteBuffer.limit());
            return new FD(n, DcmElementImpl.EMPTY_VALUE);
        }
        return new FD(n, byteBuffer);
    }

    static DcmElement createFD(int n) {
        return new FD(n, DcmElementImpl.EMPTY_VALUE);
    }

    static DcmElement createFD(int n, double d) {
        return new FD(n, ValueElement.setDouble(d));
    }

    static DcmElement createFD(int n, double[] dArray) {
        return new FD(n, ValueElement.setDoubles(dArray));
    }

    static DcmElement createOF(int n) {
        return new OF(n, DcmElementImpl.EMPTY_VALUE);
    }

    static DcmElement createOF(int n, float[] fArray) {
        ByteBuffer byteBuffer = ByteBuffer.allocate(fArray.length << 2);
        byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
        int n2 = 0;
        while (n2 < fArray.length) {
            byteBuffer.putFloat(fArray[n2]);
            ++n2;
        }
        return new OF(n, byteBuffer);
    }

    static DcmElement createOF(int n, ByteBuffer byteBuffer) {
        if ((byteBuffer.limit() & 3) != 0) {
            DcmElementImpl.log.warn("Ignore illegal value of " + Tags.toString(n) + " OW #" + byteBuffer.limit());
            return new OF(n, DcmElementImpl.EMPTY_VALUE);
        }
        return new OF(n, byteBuffer);
    }

    static DcmElement createOW(int n) {
        return new OW(n, DcmElementImpl.EMPTY_VALUE);
    }

    static DcmElement createOW(int n, short[] sArray) {
        ByteBuffer byteBuffer = ByteBuffer.allocate(sArray.length << 1);
        byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
        int n2 = 0;
        while (n2 < sArray.length) {
            byteBuffer.putShort(sArray[n2]);
            ++n2;
        }
        return new OW(n, byteBuffer);
    }

    static DcmElement createOW(int n, ByteBuffer byteBuffer) {
        if ((byteBuffer.limit() & 1) != 0) {
            DcmElementImpl.log.warn("Ignore illegal value of " + Tags.toString(n) + " OW #" + byteBuffer.limit());
            return new OW(n, DcmElementImpl.EMPTY_VALUE);
        }
        return new OW(n, byteBuffer);
    }

    static DcmElement createOB(int n) {
        return new OB(n, DcmElementImpl.EMPTY_VALUE);
    }

    static DcmElement createOB(int n, ByteBuffer byteBuffer) {
        return new OB(n, byteBuffer);
    }

    static DcmElement createOB(int n, byte[] byArray) {
        return new OB(n, ByteBuffer.wrap(byArray).order(ByteOrder.LITTLE_ENDIAN));
    }

    static DcmElement createUN(int n) {
        return new UN(n, DcmElementImpl.EMPTY_VALUE);
    }

    static DcmElement createUN(int n, ByteBuffer byteBuffer) {
        return new UN(n, byteBuffer);
    }

    static DcmElement createUN(int n, byte[] byArray) {
        return new UN(n, ByteBuffer.wrap(byArray).order(ByteOrder.LITTLE_ENDIAN));
    }

    private static final class UN
    extends ValueElement {
        UN(int n, ByteBuffer byteBuffer) {
            super(n, byteBuffer);
        }

        public final int vr() {
            return 21838;
        }

        public String getString(int n, Charset charset) {
            return this.getBoundedString(Integer.MAX_VALUE, n, charset);
        }

        public String getBoundedString(int n, int n2, Charset charset) {
            if (n2 >= this.vm()) {
                return n2 == 0 ? "" : null;
            }
            return StringUtils.promptOB(this.data, n);
        }

        public String[] getStrings(Charset charset) throws DcmValueException {
            return this.getBoundedStrings(Integer.MAX_VALUE, charset);
        }

        public String[] getBoundedStrings(int n, Charset charset) {
            String[] stringArray = new String[this.vm()];
            int n2 = 0;
            while (n2 < stringArray.length) {
                stringArray[n2] = this.getBoundedString(n, n2, null);
                ++n2;
            }
            return stringArray;
        }
    }

    private static final class OB
    extends ValueElement {
        OB(int n, ByteBuffer byteBuffer) {
            super(n, byteBuffer);
        }

        public final int vr() {
            return 20290;
        }

        public String getString(int n, Charset charset) {
            return this.getBoundedString(Integer.MAX_VALUE, n, charset);
        }

        public String getBoundedString(int n, int n2, Charset charset) {
            if (n2 >= this.vm()) {
                return n2 == 0 ? "" : null;
            }
            return StringUtils.promptOB(this.data, n);
        }

        public String[] getStrings(Charset charset) {
            return this.getBoundedStrings(Integer.MAX_VALUE, charset);
        }

        public String[] getBoundedStrings(int n, Charset charset) {
            String[] stringArray = new String[this.vm()];
            int n2 = 0;
            while (n2 < stringArray.length) {
                stringArray[n2] = this.getBoundedString(n, n2, null);
                ++n2;
            }
            return stringArray;
        }
    }

    private static final class OW
    extends ValueElement {
        OW(int n, ByteBuffer byteBuffer) {
            super(n, byteBuffer);
        }

        public final int vr() {
            return 20311;
        }

        public final int getInt(int n) {
            return this.data.getShort(n << 1) & 0xFFFF;
        }

        public final int[] getInts() {
            int[] nArray = new int[this.data.limit() >> 1];
            int n = 0;
            while (n < nArray.length) {
                nArray[n] = this.getInt(n);
                ++n;
            }
            return nArray;
        }

        public String getString(int n, Charset charset) {
            return this.getBoundedString(Integer.MAX_VALUE, n, charset);
        }

        public String getBoundedString(int n, int n2, Charset charset) {
            if (n2 >= this.vm()) {
                return n2 == 0 ? "" : null;
            }
            return StringUtils.promptOW(this.data, n);
        }

        public String[] getStrings(Charset charset) {
            return this.getBoundedStrings(Integer.MAX_VALUE, charset);
        }

        public String[] getBoundedStrings(int n, Charset charset) {
            String[] stringArray = new String[this.vm()];
            int n2 = 0;
            while (n2 < stringArray.length) {
                stringArray[n2] = this.getBoundedString(n, n2, null);
                ++n2;
            }
            return stringArray;
        }

        protected void swapOrder() {
            DcmElementImpl.swapWords(this.data);
        }
    }

    private static final class OF
    extends ValueElement {
        OF(int n, ByteBuffer byteBuffer) {
            super(n, byteBuffer);
        }

        public final int vr() {
            return 20294;
        }

        public final float getFloat(int n) {
            return this.data.getFloat(n << 2);
        }

        public final float[] getFloats() {
            float[] fArray = new float[this.data.limit() >> 2];
            int n = 0;
            while (n < fArray.length) {
                fArray[n] = this.getFloat(n);
                ++n;
            }
            return fArray;
        }

        public String getString(int n, Charset charset) {
            return this.getBoundedString(Integer.MAX_VALUE, n, charset);
        }

        public String getBoundedString(int n, int n2, Charset charset) {
            if (n2 >= this.vm()) {
                return n2 == 0 ? "" : null;
            }
            return StringUtils.promptOF(this.data, n);
        }

        public String[] getStrings(Charset charset) throws DcmValueException {
            return this.getBoundedStrings(Integer.MAX_VALUE, charset);
        }

        public String[] getBoundedStrings(int n, Charset charset) {
            String[] stringArray = new String[this.vm()];
            int n2 = 0;
            while (n2 < stringArray.length) {
                stringArray[n2] = this.getBoundedString(n, n2, null);
                ++n2;
            }
            return stringArray;
        }

        protected void swapOrder() {
            DcmElementImpl.swapInts(this.data);
        }
    }

    private static final class FD
    extends ValueElement {
        FD(int n, ByteBuffer byteBuffer) {
            super(n, byteBuffer);
        }

        public final int vm() {
            return this.data.limit() >>> 3;
        }

        public final int vr() {
            return 17988;
        }

        public final double getDouble(int n) {
            return this.data.getDouble(n << 3);
        }

        public final double[] getDoubles() {
            double[] dArray = new double[this.vm()];
            int n = 0;
            while (n < dArray.length) {
                dArray[n] = this.getDouble(n);
                ++n;
            }
            return dArray;
        }

        public String getString(int n, Charset charset) {
            if (n >= this.vm()) {
                return n == 0 ? "" : null;
            }
            return String.valueOf(this.getDouble(n));
        }

        public String[] getStrings(Charset charset) throws DcmValueException {
            String[] stringArray = new String[this.vm()];
            int n = 0;
            while (n < stringArray.length) {
                stringArray[n] = String.valueOf(this.getDouble(n));
                ++n;
            }
            return stringArray;
        }

        protected void swapOrder() {
            DcmElementImpl.swapLongs(this.data);
        }
    }

    private static final class FL
    extends ValueElement {
        FL(int n, ByteBuffer byteBuffer) {
            super(n, byteBuffer);
        }

        public final int vm() {
            return this.data.limit() >> 2;
        }

        public final int vr() {
            return 17996;
        }

        public final float getFloat(int n) {
            return this.data.getFloat(n << 2);
        }

        public final float[] getFloats() {
            float[] fArray = new float[this.vm()];
            int n = 0;
            while (n < fArray.length) {
                fArray[n] = this.getFloat(n);
                ++n;
            }
            return fArray;
        }

        public String getString(int n, Charset charset) {
            if (n >= this.vm()) {
                return n == 0 ? "" : null;
            }
            return String.valueOf(this.getFloat(n));
        }

        public String[] getStrings(Charset charset) throws DcmValueException {
            String[] stringArray = new String[this.vm()];
            int n = 0;
            while (n < stringArray.length) {
                stringArray[n] = String.valueOf(this.getFloat(n));
                ++n;
            }
            return stringArray;
        }

        protected void swapOrder() {
            DcmElementImpl.swapInts(this.data);
        }
    }

    private static final class AT
    extends ValueElement {
        AT(int n, ByteBuffer byteBuffer) {
            super(n, byteBuffer);
        }

        public final int vr() {
            return 16724;
        }

        public final int vm() {
            return this.data.limit() >> 2;
        }

        public final int getTag(int n) {
            int n2 = n << 2;
            return this.data.getShort(n2) << 16 | this.data.getShort(n2 + 2) & 0xFFFF;
        }

        public final int[] getTags() {
            int[] nArray = new int[this.vm()];
            int n = 0;
            while (n < nArray.length) {
                nArray[n] = this.getTag(n);
                ++n;
            }
            return nArray;
        }

        public String getString(int n, Charset charset) throws DcmValueException {
            if (n >= this.vm()) {
                return null;
            }
            return Tags.toHexString(this.getTag(n), 8);
        }

        public String[] getStrings(Charset charset) throws DcmValueException {
            String[] stringArray = new String[this.vm()];
            int n = 0;
            while (n < stringArray.length) {
                stringArray[n] = this.getString(n, null);
                ++n;
            }
            return stringArray;
        }

        protected void swapOrder() {
            DcmElementImpl.swapWords(this.data);
        }
    }

    static class UL
    extends Int {
        UL(int n, ByteBuffer byteBuffer) {
            super(n, byteBuffer);
        }

        public final int vr() {
            return 21836;
        }

        public String getString(int n, Charset charset) {
            if (n >= this.vm()) {
                return n == 0 ? "" : null;
            }
            return String.valueOf((long)this.getInt(n) & 0xFFFFFFFFL);
        }

        public String[] getStrings(Charset charset) throws DcmValueException {
            String[] stringArray = new String[this.vm()];
            int n = 0;
            while (n < stringArray.length) {
                stringArray[n] = String.valueOf((long)this.getInt(n) & 0xFFFFFFFFL);
                ++n;
            }
            return stringArray;
        }
    }

    private static class SL
    extends Int {
        SL(int n, ByteBuffer byteBuffer) {
            super(n, byteBuffer);
        }

        public final int vr() {
            return 21324;
        }
    }

    private static abstract class Int
    extends ValueElement {
        Int(int n, ByteBuffer byteBuffer) {
            super(n, byteBuffer);
        }

        public final int getInt(int n) {
            return this.data.getInt(n << 2);
        }

        public final int[] getInts() {
            int[] nArray = new int[this.vm()];
            int n = 0;
            while (n < nArray.length) {
                nArray[n] = this.getInt(n);
                ++n;
            }
            return nArray;
        }

        public final int vm() {
            return this.data.limit() >> 2;
        }

        protected void swapOrder() {
            DcmElementImpl.swapInts(this.data);
        }
    }

    private static final class US
    extends ValueElement {
        US(int n, ByteBuffer byteBuffer) {
            super(n, byteBuffer);
        }

        public final int vr() {
            return 21843;
        }

        public final int vm() {
            return this.data.limit() >> 1;
        }

        public final int getInt(int n) {
            return this.data.getShort(n << 1) & 0xFFFF;
        }

        public final int[] getInts() {
            int[] nArray = new int[this.vm()];
            int n = 0;
            while (n < nArray.length) {
                nArray[n] = this.getInt(n);
                ++n;
            }
            return nArray;
        }

        protected void swapOrder() {
            DcmElementImpl.swapWords(this.data);
        }
    }

    private static final class SS
    extends ValueElement {
        SS(int n, ByteBuffer byteBuffer) {
            super(n, byteBuffer);
        }

        public final int vr() {
            return 21331;
        }

        public final int vm() {
            return this.data.limit() >> 1;
        }

        public final int getInt(int n) {
            return this.data.getShort(n << 1);
        }

        public final int[] getInts() {
            int[] nArray = new int[this.vm()];
            int n = 0;
            while (n < nArray.length) {
                nArray[n] = this.getInt(n);
                ++n;
            }
            return nArray;
        }

        protected void swapOrder() {
            DcmElementImpl.swapWords(this.data);
        }
    }
}

