/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4cheri.data;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.charset.Charset;
import java.util.ArrayList;
import org.dcm4che.data.DcmElement;
import org.dcm4che.dict.Tags;
import org.dcm4che.dict.VRs;
import org.dcm4cheri.data.DcmElementImpl;
import org.dcm4cheri.util.StringUtils;

abstract class FragmentElement
extends DcmElementImpl {
    private static final byte[] EMPTY_BYTE_ARRAY = new byte[0];
    private final ArrayList list = new ArrayList();

    public FragmentElement(int n) {
        super(n);
    }

    public final int vm() {
        return this.list.size();
    }

    public final boolean hasDataFragments() {
        return true;
    }

    public final ByteBuffer getDataFragment(int n) {
        return (ByteBuffer)this.list.get(n);
    }

    public final ByteBuffer getDataFragment(int n, ByteOrder byteOrder) {
        ByteBuffer byteBuffer = (ByteBuffer)this.list.get(n);
        if (byteBuffer.order() != byteOrder) {
            this.swapOrder(byteBuffer);
        }
        return byteBuffer;
    }

    public final int getDataFragmentLength(int n) {
        ByteBuffer byteBuffer = (ByteBuffer)this.list.get(n);
        return byteBuffer.limit() + 1 & 0xFFFFFFFE;
    }

    public String getString(int n, Charset charset) {
        return this.getBoundedString(Integer.MAX_VALUE, n, charset);
    }

    public String getBoundedString(int n, int n2, Charset charset) {
        if (n2 >= this.vm()) {
            return n2 == 0 ? "" : null;
        }
        return StringUtils.promptValue(this.vr(), this.getDataFragment(n2), n);
    }

    public String[] getStrings(Charset charset) {
        return this.getBoundedStrings(Integer.MAX_VALUE, charset);
    }

    public String[] getBoundedStrings(int n, Charset charset) {
        String[] stringArray = new String[this.vm()];
        int n2 = 0;
        while (n2 < stringArray.length) {
            stringArray[n2] = StringUtils.promptValue(this.vr(), this.getDataFragment(n2), n);
            ++n2;
        }
        return stringArray;
    }

    int calcLength() {
        int n = 8;
        int n2 = 0;
        int n3 = this.vm();
        while (n2 < n3) {
            n += this.getDataFragmentLength(n2) + 8;
            ++n2;
        }
        return n;
    }

    public void addDataFragment(ByteBuffer byteBuffer) {
        this.list.add(byteBuffer != null ? byteBuffer : DcmElementImpl.EMPTY_VALUE);
    }

    protected void swapOrder(ByteBuffer byteBuffer) {
        byteBuffer.order(DcmElementImpl.swap(byteBuffer.order()));
    }

    public static DcmElement createOB(int n) {
        return new OB(n);
    }

    public static DcmElement createOF(int n) {
        return new OF(n);
    }

    public static DcmElement createOW(int n) {
        return new OW(n);
    }

    public static DcmElement createUN(int n) {
        return new UN(n);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(DcmElementImpl.DICT.toString(this.tag));
        stringBuffer.append(",").append(VRs.toString(this.vr()));
        if (!this.isEmpty()) {
            int n = 0;
            int n2 = this.vm();
            while (n < n2) {
                stringBuffer.append("\n\tFrag-").append(n + 1).append(",#").append(this.getDataFragmentLength(n)).append("[").append(StringUtils.promptValue(this.vr(), this.getDataFragment(n), 64)).append("]");
                ++n;
            }
        }
        return stringBuffer.toString();
    }

    private static final class UN
    extends FragmentElement {
        UN(int n) {
            super(n);
        }

        public final int vr() {
            return 21838;
        }
    }

    private static final class OW
    extends FragmentElement {
        OW(int n) {
            super(n);
        }

        public final int vr() {
            return 20311;
        }

        public void addDataFragment(ByteBuffer byteBuffer) {
            if ((byteBuffer.limit() & 1) != 0) {
                DcmElementImpl.log.warn("Ignore odd length fragment of " + Tags.toString(this.tag) + " OW #" + byteBuffer.limit());
                byteBuffer = null;
            }
            super.addDataFragment(byteBuffer);
        }

        protected void swapOrder(ByteBuffer byteBuffer) {
            DcmElementImpl.swapWords(byteBuffer);
        }
    }

    private static final class OF
    extends FragmentElement {
        OF(int n) {
            super(n);
        }

        public final int vr() {
            return 20294;
        }

        public void addDataFragment(ByteBuffer byteBuffer) {
            if ((byteBuffer.limit() & 3) != 0) {
                DcmElementImpl.log.warn("Ignore odd length fragment of " + Tags.toString(this.tag) + " OF #" + byteBuffer.limit());
                byteBuffer = null;
            }
            super.addDataFragment(byteBuffer);
        }

        protected void swapOrder(ByteBuffer byteBuffer) {
            DcmElementImpl.swapInts(byteBuffer);
        }
    }

    private static final class OB
    extends FragmentElement {
        OB(int n) {
            super(n);
        }

        public final int vr() {
            return 20290;
        }
    }
}

