/*
 * Decompiled with CFR 0.152.
 */
package de.iftm.pgm;

import java.io.File;
import java.io.FileOutputStream;
import java.io.PrintStream;
import java.util.Iterator;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.imageio.ImageIO;
import javax.imageio.ImageWriter;
import org.dcm4che.data.Dataset;
import org.dcm4che.data.DcmElement;
import org.dcm4che.data.DcmObjectFactory;
import org.dcm4che.dict.DictionaryFactory;
import org.dcm4che.dict.TagDictionary;
import org.dcm4che.dict.VRs;
import org.dcm4che.imageio.plugins.DcmMetadata;

public class PgmCommentsUtil {
    private static TagDictionary dict = DictionaryFactory.getInstance().getDefaultTagDictionary();

    public static Dataset commentsToDataset(Vector comments) {
        Dataset dataset = null;
        if (comments == null) {
            return null;
        }
        dataset = DcmObjectFactory.getInstance().newDataset();
        Iterator i = comments.iterator();
        while (i.hasNext()) {
            String s = (String)i.next();
            while (s.startsWith(" ")) {
                s = s.substring(1);
            }
            if (!s.startsWith("Dicom/")) continue;
            int iTag = s.indexOf("(") + 1;
            String tagString = s.substring(iTag, iTag + 4);
            tagString = tagString + s.substring(iTag + 5, iTag + 9);
            int tag = Integer.parseInt(tagString, 16);
            int vr = VRs.valueOf(PgmCommentsUtil.dict.lookup((int)tag).vr);
            int iValue = s.indexOf(":") + 2;
            String value = s.substring(iValue);
            PgmCommentsUtil.addElement(dataset, tag, vr, value);
        }
        return dataset;
    }

    public static void addElement(Dataset dataset, int tag, int vr, String value) {
        if (dict.lookup(tag) == null) {
            System.err.println("Tag " + Integer.toHexString(tag) + " not defined in dictionary.");
            return;
        }
        try {
            if (value.equals("")) {
                value = null;
            }
            if (value == null) {
                dataset.putXX(tag, vr);
                return;
            }
            if (vr == 20290 | vr == 20311 | vr == 20294 | vr == 21329 | vr == 21838 | vr == 0) {
                System.err.println("Can't process " + VRs.toString(vr));
                return;
            }
            if (value.indexOf(92) == -1) {
                dataset.putXX(tag, vr, value);
                return;
            }
            StringTokenizer st = new StringTokenizer(value, "\\");
            Vector<String> stringVector = new Vector<String>();
            while (st.hasMoreTokens()) {
                stringVector.add(st.nextToken());
            }
            String[] stringArray = stringVector.toArray(new String[1]);
            dataset.putXX(tag, vr, stringArray);
        }
        catch (Exception e) {
            System.err.println("Can't add tag: " + Integer.toHexString(tag) + " value: " + value);
        }
    }

    public static Vector datasetToComments(Dataset dataset) {
        if (dataset == null) {
            return null;
        }
        Dataset dummy = DcmObjectFactory.getInstance().newDataset();
        Vector<String> comments = new Vector<String>();
        Iterator iter = dataset.iterator();
        while (iter.hasNext()) {
            try {
                DcmElement element = (DcmElement)iter.next();
                if (dict.lookup(element.tag()) == null) continue;
                String[] valueArray = dataset.getStrings(element.tag());
                int i = 0;
                while (i < valueArray.length) {
                    valueArray[i] = valueArray[i].replaceAll("\r", "\\\\r");
                    valueArray[i] = valueArray[i].replaceAll("\n", "\\\\n");
                    valueArray[i] = valueArray[i].replaceAll("\f", "\\\\f");
                    valueArray[i] = valueArray[i].replaceAll("\u001b", "\\\\033");
                    ++i;
                }
                dummy.putXX(element.tag(), VRs.valueOf(PgmCommentsUtil.dict.lookup((int)element.tag()).vr), valueArray);
                String tagString = "0000" + Integer.toHexString(element.tag());
                tagString = tagString.substring(tagString.length() - 8);
                String name = PgmCommentsUtil.dict.lookup((int)element.tag()).name;
                String key = " Dicom/(";
                key = key + tagString.substring(0, 4);
                key = key + ",";
                key = key + tagString.substring(4);
                key = key + ")";
                key = key + name;
                key = key + ": ";
                switch (element.vm()) {
                    case 0: {
                        comments.add(key);
                        break;
                    }
                    case 1: {
                        comments.add(key + valueArray[0]);
                        break;
                    }
                    default: {
                        String value = "";
                        int i2 = 0;
                        while (i2 < element.vm()) {
                            value = value + "\\\\" + valueArray[i2];
                            ++i2;
                        }
                        comments.add(key + value.substring(2));
                    }
                }
            }
            catch (Exception ignore) {
                // empty catch block
            }
        }
        return comments;
    }

    public static Dataset getDefaultInfoMetadata(String patientID, int studyID, int seriesNumber, int instanceNumber) {
        ImageWriter dcmImageWriter;
        Dataset idDS = DcmObjectFactory.getInstance().newDataset();
        idDS.putLO(0x100020, patientID);
        idDS.putSH(0x200010, String.valueOf(studyID));
        idDS.putIS(0x200011, String.valueOf(seriesNumber));
        idDS.putIS(2097171, String.valueOf(instanceNumber));
        Iterator<ImageWriter> writers = ImageIO.getImageWritersByFormatName("DICOM");
        do {
            if ((dcmImageWriter = writers.next()) != null) continue;
            throw new UnsupportedOperationException("No DcmImageWriter found");
        } while (!(dcmImageWriter.getDefaultStreamMetadata(null) instanceof DcmMetadata));
        Dataset returnDS = ((DcmMetadata)dcmImageWriter.getDefaultStreamMetadata(null)).getDataset();
        returnDS.putAll(idDS);
        return returnDS;
    }

    public static String createPatientID() {
        return Long.toString(System.currentTimeMillis());
    }

    public static void main(String[] args) {
        Dataset ds = PgmCommentsUtil.getDefaultInfoMetadata(PgmCommentsUtil.createPatientID(), 1, 1, 1);
        File f = new File(System.getProperty("user.dir"), "default_comments.txt");
        try {
            PrintStream ps = new PrintStream(new FileOutputStream(f));
            Vector comments = PgmCommentsUtil.datasetToComments(ds);
            String[] commentsArray = comments.toArray(new String[1]);
            int i = 1;
            while (i < commentsArray.length) {
                ps.println(commentsArray[i]);
                ++i;
            }
            ps.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

