/*
 * Decompiled with CFR 0.152.
 */
package de.iftm.pgm;

import de.iftm.pgm.PgmCommentsUtil;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferInt;
import java.awt.image.DataBufferUShort;
import java.awt.image.WritableRaster;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.util.Iterator;
import java.util.Vector;
import org.dcm4che.data.Dataset;

public class PGM {
    public String magicNumber = null;
    public Vector comments = null;
    public int width;
    public int height;
    public int maximumColorValue;
    public byte[] pixel;
    private byte[] inBuffer = null;
    private int inIndex;

    public void setMetadata(Dataset metaDataset) {
        this.comments = PgmCommentsUtil.datasetToComments(metaDataset);
    }

    public Dataset getMetadata() {
        return PgmCommentsUtil.commentsToDataset(this.comments);
    }

    public void setImage(BufferedImage bufferedImage) {
        switch (bufferedImage.getData().getDataBuffer().getDataType()) {
            case 1: {
                this.magicNumber = "P5";
                this.maximumColorValue = 65535;
                this.width = bufferedImage.getWidth();
                this.height = bufferedImage.getHeight();
                short[] ushortBuffer = ((DataBufferUShort)bufferedImage.getData().getDataBuffer()).getData();
                this.pixel = new byte[this.width * this.height * 2];
                int pixelIdx = 0;
                int i = 0;
                while (i < ushortBuffer.length) {
                    short ushort = ushortBuffer[i];
                    this.pixel[pixelIdx++] = (byte)(ushort >>> 8);
                    this.pixel[pixelIdx++] = (byte)(ushort & 0xFF);
                    ++i;
                }
                break;
            }
            default: {
                this.magicNumber = "P6";
                this.maximumColorValue = 255;
                this.width = bufferedImage.getWidth();
                this.height = bufferedImage.getHeight();
                BufferedImage rgbImage = new BufferedImage(this.width, this.height, 1);
                Graphics2D g = rgbImage.createGraphics();
                g.drawImage((Image)bufferedImage, 0, 0, null);
                g.dispose();
                this.pixel = new byte[this.width * this.height * 3];
                int pixelIdx = 0;
                int[] intBuffer = ((DataBufferInt)rgbImage.getData().getDataBuffer()).getData();
                int i = 0;
                while (i < intBuffer.length) {
                    int argbInt = intBuffer[i];
                    this.pixel[pixelIdx++] = (byte)(argbInt >>> 16);
                    this.pixel[pixelIdx++] = (byte)(argbInt >>> 8);
                    this.pixel[pixelIdx++] = (byte)(argbInt & 0xFF);
                    ++i;
                }
                break block0;
            }
        }
    }

    public BufferedImage getImage() {
        if (this.magicNumber.equals("16HL") | this.magicNumber.equals("P5")) {
            BufferedImage ushortImage = new BufferedImage(this.width, this.height, 11);
            WritableRaster ushortRaster = ushortImage.getRaster();
            int ushortIdx = 0;
            int pixelIdx = 0;
            short[] ushortBuffer = new short[this.width * this.height];
            while (pixelIdx < this.pixel.length) {
                ushortBuffer[ushortIdx] = (short)(this.pixel[pixelIdx++] << 8);
                int n = ushortIdx++;
                ushortBuffer[n] = (short)(ushortBuffer[n] + this.pixel[pixelIdx++]);
            }
            ushortRaster.setDataElements(0, 0, this.width, this.height, ushortBuffer);
            return ushortImage;
        }
        if (this.magicNumber.equals("P6")) {
            BufferedImage rgbImage = new BufferedImage(this.width, this.height, 1);
            WritableRaster rgbRaster = rgbImage.getRaster();
            int pixelIdx = 0;
            int intIdx = 0;
            int[] intBuffer = new int[this.width * this.height];
            while (pixelIdx < this.pixel.length) {
                intBuffer[intIdx] = this.pixel[pixelIdx++] << 16;
                int n = intIdx;
                intBuffer[n] = intBuffer[n] + (this.pixel[pixelIdx++] << 8);
                int n2 = intIdx++;
                intBuffer[n2] = intBuffer[n2] + this.pixel[pixelIdx++];
            }
            rgbRaster.setDataElements(0, 0, this.width, this.height, intBuffer);
            return rgbImage;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean read(File f) {
        block13: {
            block12: {
                fis = null;
                try {
                    try {
                        fis = new FileInputStream(f);
                        this.inBuffer = new byte[(int)f.length()];
                        if (fis.read(this.inBuffer) != this.inBuffer.length) {
                            var4_3 = false;
                            var7_5 = null;
                            break block12;
                        }
                        this.comments = new Vector<E>();
                        this.inIndex = 0;
                        this.magicNumber = this.nextValidToken();
                        this.width = Integer.parseInt(this.nextValidToken());
                        this.height = Integer.parseInt(this.nextValidToken());
                        this.maximumColorValue = Integer.parseInt(this.nextValidToken());
                        this.pixel = new byte[this.inBuffer.length - this.inIndex];
                        pixelIndex = 0;
                        while (this.inIndex < this.inBuffer.length) {
                            this.pixel[pixelIndex++] = this.inBuffer[this.inIndex++];
                        }
                        break block13;
                    }
                    catch (Exception e) {
                        System.err.println(e.toString());
                        var5_14 = false;
                        var7_7 = null;
                        try {
                            if (fis == null) return var5_14;
                            fis.close();
                            return var5_14;
                        }
                        catch (Exception ignore) {
                            // empty catch block
                        }
                        return var5_14;
                    }
                }
                catch (Throwable var6_15) {
                    var7_8 = null;
                    ** try [egrp 2[TRYBLOCK] [5 : 200->211)] { 
lbl39:
                    // 1 sources

                    if (fis == null) throw var6_15;
                    fis.close();
                    throw var6_15;
lbl42:
                    // 1 sources

                    catch (Exception ignore) {
                        // empty catch block
                    }
                    throw var6_15;
                }
            }
            ** try [egrp 2[TRYBLOCK] [5 : 200->211)] { 
lbl47:
            // 1 sources

            if (fis == null) return var4_3;
            fis.close();
            return var4_3;
lbl50:
            // 1 sources

            catch (Exception ignore) {
                // empty catch block
            }
            return var4_3;
        }
        var7_6 = null;
        try {}
        catch (Exception ignore) {}
        if (fis == null) return true;
        fis.close();
        return true;
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public boolean write(File f) {
        block13: {
            DataOutputStream dos = null;
            dos = new DataOutputStream(new FileOutputStream(f));
            dos.writeBytes(this.magicNumber + "\n");
            if (this.comments != null) {
                Iterator i = this.comments.iterator();
                while (i.hasNext()) {
                    String s = (String)i.next();
                    dos.writeBytes("#" + s + "\n");
                }
            }
            dos.writeBytes(this.width + "\n");
            dos.writeBytes(this.height + "\n");
            dos.writeBytes(this.maximumColorValue + "\n");
            dos.write(this.pixel, 0, this.pixel.length);
            Object var7_6 = null;
            try {
                if (dos != null) {
                    dos.flush();
                    dos.close();
                }
                break block13;
            }
            catch (Exception ignore) {}
            break block13;
            {
                catch (Exception e) {
                    System.err.println(e.toString());
                    boolean bl = false;
                    Object var7_7 = null;
                    try {
                        if (dos != null) {
                            dos.flush();
                            dos.close();
                        }
                    }
                    catch (Exception ignore) {
                        // empty catch block
                    }
                    return bl;
                }
            }
            catch (Throwable throwable) {
                Object var7_8 = null;
                try {
                    if (dos != null) {
                        dos.flush();
                        dos.close();
                    }
                }
                catch (Exception ignore) {
                    // empty catch block
                }
                throw throwable;
            }
        }
        return true;
    }

    private String nextValidToken() throws Exception {
        String s;
        String delim = " \t\r\n";
        String eol = "\r\n";
        while (this.inBuffer[this.inIndex] == 35) {
            ++this.inIndex;
            s = "";
            while (eol.indexOf(this.inBuffer[this.inIndex]) == -1) {
                s = s + (char)this.inBuffer[this.inIndex++];
                if (this.inIndex >= this.inBuffer.length) break;
            }
            ++this.inIndex;
            this.comments.add(s);
        }
        s = "";
        while (delim.indexOf(this.inBuffer[this.inIndex]) == -1) {
            s = s + (char)this.inBuffer[this.inIndex++];
            if (this.inIndex >= this.inBuffer.length) break;
        }
        ++this.inIndex;
        return s;
    }
}

