/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4che.data;

import java.nio.ByteOrder;
import org.dcm4che.data.DcmEncodeParam;

public class DcmDecodeParam {
    public final ByteOrder byteOrder;
    public final boolean explicitVR;
    public final boolean deflated;
    public final boolean encapsulated;
    public static final DcmEncodeParam IVR_LE = new DcmEncodeParam(ByteOrder.LITTLE_ENDIAN, false, false, false, false, false, false);
    public static final DcmEncodeParam IVR_BE = new DcmEncodeParam(ByteOrder.BIG_ENDIAN, false, false, false, true, true, true);
    public static final DcmEncodeParam EVR_LE = new DcmEncodeParam(ByteOrder.LITTLE_ENDIAN, true, false, false, true, true, true);
    public static final DcmEncodeParam EVR_BE = new DcmEncodeParam(ByteOrder.BIG_ENDIAN, true, false, false, true, true, true);
    public static final DcmEncodeParam DEFL_EVR_LE = new DcmEncodeParam(ByteOrder.LITTLE_ENDIAN, true, true, false, true, true, true);
    public static final DcmEncodeParam ENCAPS_EVR_LE = new DcmEncodeParam(ByteOrder.LITTLE_ENDIAN, true, false, true, true, true, true);

    public DcmDecodeParam(ByteOrder byteOrder, boolean bl, boolean bl2, boolean bl3) {
        if (byteOrder == null) {
            throw new NullPointerException();
        }
        this.byteOrder = byteOrder;
        this.explicitVR = bl;
        this.deflated = bl2;
        this.encapsulated = bl3;
    }

    public String toString() {
        return (this.explicitVR ? "explVR-" : "implVR-") + this.byteOrder.toString() + (this.deflated ? " deflated" : "") + (this.encapsulated ? " encapsulated" : "");
    }

    public static final DcmEncodeParam valueOf(String string) {
        if ("1.2.840.10008.1.2".equals(string)) {
            return IVR_LE;
        }
        if ("1.2.840.10008.1.2.1".equals(string)) {
            return EVR_LE;
        }
        if ("1.2.840.10008.1.2.1.99".equals(string)) {
            return DEFL_EVR_LE;
        }
        if ("1.2.840.10008.1.2.2".equals(string)) {
            return EVR_BE;
        }
        return ENCAPS_EVR_LE;
    }
}

