/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4cheri.srom;

import java.util.Date;
import org.dcm4che.data.Dataset;
import org.dcm4che.srom.Code;
import org.dcm4che.srom.Content;
import org.dcm4che.srom.KeyObject;
import org.dcm4che.srom.SCoordContent;
import org.dcm4che.srom.Template;
import org.dcm4cheri.srom.NamedContentImpl;

abstract class SCoordContentImpl
extends NamedContentImpl
implements SCoordContent {
    protected final float[] graphicData;

    SCoordContentImpl(KeyObject keyObject, Date date, Template template, Code code, float[] fArray) {
        super(keyObject, date, template, code);
        this.graphicData = (float[])fArray.clone();
    }

    public String toString() {
        StringBuffer stringBuffer = this.prompt().append(this.getGraphicType()).append(":[");
        if (this.graphicData.length > 8) {
            stringBuffer.append("N=").append(this.graphicData.length);
        } else {
            stringBuffer.append(this.graphicData[0]);
            int n = 1;
            while (n < this.graphicData.length) {
                stringBuffer.append(',').append(this.graphicData[n]);
                ++n;
            }
        }
        return stringBuffer.append("]").toString();
    }

    public Content.ValueType getValueType() {
        return Content.ValueType.SCOORD;
    }

    public float[] getGraphicData() {
        return (float[])this.graphicData.clone();
    }

    public void toDataset(Dataset dataset) {
        super.toDataset(dataset);
        dataset.putCS(7340067, this.getGraphicType());
        dataset.putFL(0x700022, this.graphicData);
    }

    static class Ellipse
    extends SCoordContentImpl
    implements SCoordContent.Ellipse {
        Ellipse(KeyObject keyObject, Date date, Template template, Code code, float[] fArray) {
            super(keyObject, date, template, code, fArray);
            if (fArray.length != 8) {
                throw new IllegalArgumentException("float[" + fArray.length + "]");
            }
        }

        Content clone(KeyObject keyObject, boolean bl) {
            return new Ellipse(keyObject, this.getObservationDateTime(bl), this.template, this.name, this.graphicData);
        }

        public String getGraphicType() {
            return "ELLIPSE";
        }
    }

    static class Circle
    extends SCoordContentImpl
    implements SCoordContent.Circle {
        Circle(KeyObject keyObject, Date date, Template template, Code code, float[] fArray) {
            super(keyObject, date, template, code, fArray);
            if (fArray.length != 4) {
                throw new IllegalArgumentException("float[" + fArray.length + "]");
            }
        }

        Content clone(KeyObject keyObject, boolean bl) {
            return new Circle(keyObject, this.getObservationDateTime(bl), this.template, this.name, this.graphicData);
        }

        public String getGraphicType() {
            return "CIRCLE";
        }
    }

    static class Polyline
    extends SCoordContentImpl
    implements SCoordContent.Polyline {
        Polyline(KeyObject keyObject, Date date, Template template, Code code, float[] fArray) {
            super(keyObject, date, template, code, fArray);
            if ((fArray.length & 1) != 0) {
                throw new IllegalArgumentException("float[" + fArray.length + "]");
            }
        }

        Content clone(KeyObject keyObject, boolean bl) {
            return new Polyline(keyObject, this.getObservationDateTime(bl), this.template, this.name, this.graphicData);
        }

        public String getGraphicType() {
            return "POLYLINE";
        }
    }

    static class MultiPoint
    extends SCoordContentImpl
    implements SCoordContent.MultiPoint {
        MultiPoint(KeyObject keyObject, Date date, Template template, Code code, float[] fArray) {
            super(keyObject, date, template, code, fArray);
            if ((fArray.length & 1) != 0) {
                throw new IllegalArgumentException("float[" + fArray.length + "]");
            }
        }

        Content clone(KeyObject keyObject, boolean bl) {
            return new MultiPoint(keyObject, this.getObservationDateTime(bl), this.template, this.name, this.graphicData);
        }

        public String getGraphicType() {
            return "MULTIPOINT";
        }
    }

    static class Point
    extends SCoordContentImpl
    implements SCoordContent.Point {
        Point(KeyObject keyObject, Date date, Template template, Code code, float[] fArray) {
            super(keyObject, date, template, code, fArray);
            if (fArray.length != 2) {
                throw new IllegalArgumentException("float[" + fArray.length + "]");
            }
        }

        Content clone(KeyObject keyObject, boolean bl) {
            return new Point(keyObject, this.getObservationDateTime(bl), this.template, this.name, this.graphicData);
        }

        public String getGraphicType() {
            return "POINT";
        }
    }
}

