/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4cheri.server;

import java.io.IOException;
import java.net.Socket;
import java.util.Iterator;
import java.util.LinkedList;
import org.dcm4che.net.AAssociateAC;
import org.dcm4che.net.AcceptorPolicy;
import org.dcm4che.net.Association;
import org.dcm4che.net.AssociationListener;
import org.dcm4che.net.DcmServiceRegistry;
import org.dcm4che.net.Factory;
import org.dcm4che.server.DcmHandler;

class DcmHandlerImpl
implements DcmHandler {
    private static final Factory fact = Factory.getInstance();
    private final AcceptorPolicy policy;
    private final DcmServiceRegistry services;
    private final LinkedList listeners = new LinkedList();
    private int requestTO = 5000;

    public DcmHandlerImpl(AcceptorPolicy acceptorPolicy, DcmServiceRegistry dcmServiceRegistry) {
        if (acceptorPolicy == null) {
            throw new NullPointerException();
        }
        if (dcmServiceRegistry == null) {
            throw new NullPointerException();
        }
        this.policy = acceptorPolicy;
        this.services = dcmServiceRegistry;
    }

    public void handle(Socket socket) throws IOException {
        Association association = fact.newAcceptor(socket);
        Iterator iterator = this.listeners.iterator();
        while (iterator.hasNext()) {
            association.addAssociationListener((AssociationListener)iterator.next());
        }
        if (association.accept(this.policy, this.requestTO) instanceof AAssociateAC) {
            fact.newActiveAssociation(association, this.services).run();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addAssociationListener(AssociationListener associationListener) {
        LinkedList linkedList = this.listeners;
        synchronized (linkedList) {
            this.listeners.add(associationListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAssociationListener(AssociationListener associationListener) {
        LinkedList linkedList = this.listeners;
        synchronized (linkedList) {
            this.listeners.remove(associationListener);
        }
    }

    public boolean isSockedClosedByHandler() {
        return true;
    }
}

