/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4cheri.net;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;

final class UnparsedPDUImpl {
    static final long MAX_LENGTH = 0x100000L;
    private final byte[] buf;
    private final int type;
    private final int len;

    public UnparsedPDUImpl(InputStream inputStream, byte[] byArray) throws IOException {
        if (byArray == null || byArray.length < 6) {
            byArray = new byte[10];
        }
        UnparsedPDUImpl.readFully(inputStream, byArray, 0, 6);
        this.type = byArray[0] & 0xFF;
        this.len = (byArray[2] & 0xFF) << 24 | (byArray[3] & 0xFF) << 16 | (byArray[4] & 0xFF) << 8 | (byArray[5] & 0xFF) << 0;
        if ((long)(this.len & 0xFFFFFFFF) > 0x100000L) {
            UnparsedPDUImpl.skipFully(inputStream, (long)this.len & 0xFFFFFFFFL);
            this.buf = null;
            return;
        }
        if (byArray.length < 6 + this.len) {
            this.buf = new byte[6 + this.len];
            System.arraycopy(byArray, 0, this.buf, 0, 6);
        } else {
            this.buf = byArray;
        }
        UnparsedPDUImpl.readFully(inputStream, this.buf, 6, this.len);
    }

    public final int type() {
        return this.type;
    }

    public final int length() {
        return this.len;
    }

    public final byte[] buffer() {
        return this.buf;
    }

    public String toString() {
        return "PDU[type=" + this.type + ", length=" + ((long)this.len & 0xFFFFFFFFL) + "]";
    }

    static void skipFully(InputStream inputStream, long l) throws IOException {
        long l2 = 0L;
        while (l2 < l) {
            long l3 = inputStream.skip(l - l2);
            if (l3 < 0L) {
                throw new EOFException();
            }
            l2 += l3;
        }
    }

    static void readFully(InputStream inputStream, byte[] byArray, int n, int n2) throws IOException {
        int n3 = 0;
        while (n3 < n2) {
            int n4 = inputStream.read(byArray, n3 + n, n2 - n3);
            if (n4 < 0) {
                throw new EOFException();
            }
            n3 += n4;
        }
    }
}

