/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4cheri.net;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import org.dcm4che.net.PDUException;
import org.dcm4che.net.RoleSelection;
import org.dcm4cheri.net.AAbortImpl;
import org.dcm4cheri.net.AAssociateRQACImpl;

final class RoleSelectionImpl
implements RoleSelection {
    private final String asuid;
    private final boolean scu;
    private final boolean scp;

    RoleSelectionImpl(String string, boolean bl, boolean bl2) {
        this.asuid = string;
        this.scu = bl;
        this.scp = bl2;
    }

    RoleSelectionImpl(DataInputStream dataInputStream, int n) throws IOException, PDUException {
        int n2 = dataInputStream.readUnsignedShort();
        if (n2 + 4 != n) {
            throw new PDUException("SCP/SCU role selection sub-item length: " + n + " mismatch UID-length:" + n2, new AAbortImpl(2, 6));
        }
        this.asuid = AAssociateRQACImpl.readASCII(dataInputStream, n2);
        this.scu = dataInputStream.readBoolean();
        this.scp = dataInputStream.readBoolean();
    }

    public final String getSOPClassUID() {
        return this.asuid;
    }

    public final boolean scu() {
        return this.scu;
    }

    public final boolean scp() {
        return this.scp;
    }

    final int length() {
        return 4 + this.asuid.length();
    }

    void writeTo(DataOutputStream dataOutputStream) throws IOException {
        dataOutputStream.write(84);
        dataOutputStream.write(0);
        dataOutputStream.writeShort(this.length());
        dataOutputStream.writeShort(this.asuid.length());
        dataOutputStream.writeBytes(this.asuid);
        dataOutputStream.writeBoolean(this.scu);
        dataOutputStream.writeBoolean(this.scp);
    }
}

