/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4cheri.net;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.dcm4che.dict.DictionaryFactory;
import org.dcm4che.dict.UIDDictionary;
import org.dcm4che.net.PDUException;
import org.dcm4che.net.PresContext;
import org.dcm4cheri.net.AAbortImpl;
import org.dcm4cheri.net.AAssociateRQACImpl;

final class PresContextImpl
implements PresContext {
    private static final UIDDictionary UID_DICT = DictionaryFactory.getInstance().getDefaultUIDDictionary();
    private final int type;
    private final int pcid;
    private final int result;
    private final String asuid;
    private final List tsuids;

    PresContextImpl(int n, int n2, int n3, String string, String[] stringArray) {
        if ((n2 | 1) == 0 || (n2 & 0xFFFFFF00) != 0) {
            throw new IllegalArgumentException("pcid=" + n2);
        }
        if (stringArray.length == 0) {
            throw new IllegalArgumentException("Missing TransferSyntax");
        }
        this.type = n;
        this.pcid = n2;
        this.result = n3;
        this.asuid = string;
        this.tsuids = new ArrayList<String>(Arrays.asList(stringArray));
    }

    PresContextImpl(int n, DataInputStream dataInputStream, int n2) throws IOException, PDUException {
        this.type = n;
        this.pcid = dataInputStream.readUnsignedByte();
        dataInputStream.readUnsignedByte();
        this.result = dataInputStream.readUnsignedByte();
        dataInputStream.readUnsignedByte();
        int n3 = n2 - 4;
        String string = null;
        this.tsuids = new LinkedList();
        while (n3 > 0) {
            int n4 = dataInputStream.readUnsignedByte();
            dataInputStream.readUnsignedByte();
            int n5 = dataInputStream.readUnsignedShort();
            switch (n4) {
                case 48: {
                    if (n == 33 || string != null) {
                        throw new PDUException("Unexpected Abstract Syntax sub-item in Presentation Context", new AAbortImpl(2, 5));
                    }
                    string = AAssociateRQACImpl.readASCII(dataInputStream, n5);
                    break;
                }
                case 64: {
                    if (n == 33 && !this.tsuids.isEmpty()) {
                        throw new PDUException("Unexpected Transfer Syntax sub-item in Presentation Context", new AAbortImpl(2, 5));
                    }
                    this.tsuids.add(AAssociateRQACImpl.readASCII(dataInputStream, n5));
                    break;
                }
                default: {
                    throw new PDUException("unrecognized item type " + Integer.toHexString(n4) + 'H', new AAbortImpl(2, 4));
                }
            }
            n3 -= 4 + n5;
        }
        this.asuid = string;
        if (n3 < 0) {
            throw new PDUException("Presentation item length: " + n2 + " mismatch length of sub-items", new AAbortImpl(2, 6));
        }
    }

    void writeTo(DataOutputStream dataOutputStream) throws IOException {
        dataOutputStream.write(this.type);
        dataOutputStream.write(0);
        dataOutputStream.writeShort(this.length());
        dataOutputStream.write(this.pcid);
        dataOutputStream.write(0);
        dataOutputStream.write(this.result);
        dataOutputStream.write(0);
        if (this.asuid != null) {
            dataOutputStream.write(48);
            dataOutputStream.write(0);
            dataOutputStream.writeShort(this.asuid.length());
            dataOutputStream.writeBytes(this.asuid);
        }
        Iterator iterator = this.tsuids.iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            dataOutputStream.write(64);
            dataOutputStream.write(0);
            dataOutputStream.writeShort(string.length());
            dataOutputStream.writeBytes(string);
        }
    }

    final int length() {
        int n = 4;
        if (this.asuid != null) {
            n += 4 + this.asuid.length();
        }
        Iterator iterator = this.tsuids.iterator();
        while (iterator.hasNext()) {
            n += 4 + ((String)iterator.next()).length();
        }
        return n;
    }

    final int type() {
        return this.type;
    }

    public final int pcid() {
        return this.pcid;
    }

    public final int result() {
        return this.result;
    }

    public final String getAbstractSyntaxUID() {
        return this.asuid;
    }

    public final List getTransferSyntaxUIDs() {
        return Collections.unmodifiableList(this.tsuids);
    }

    public final String getTransferSyntaxUID() {
        return (String)this.tsuids.get(0);
    }

    public String toString() {
        return this.toStringBuffer(new StringBuffer()).toString();
    }

    private StringBuffer toStringBuffer(StringBuffer stringBuffer) {
        stringBuffer.append("PresContext[pcid=").append(this.pcid);
        if (this.type == 32) {
            stringBuffer.append(", as=").append(UID_DICT.lookup(this.asuid));
        } else {
            stringBuffer.append(", result=").append(this.resultAsString());
        }
        Iterator iterator = this.tsuids.iterator();
        stringBuffer.append(", ts=").append(UID_DICT.lookup((String)iterator.next()));
        while (iterator.hasNext()) {
            stringBuffer.append(", ").append(UID_DICT.lookup((String)iterator.next()));
        }
        return stringBuffer.append("]");
    }

    public String resultAsString() {
        switch (this.result()) {
            case 0: {
                return "0 - acceptance";
            }
            case 1: {
                return "1 - user-rejection";
            }
            case 2: {
                return "2 - no-reason-given";
            }
            case 3: {
                return "3 - abstract-syntax-not-supported";
            }
            case 4: {
                return "4 - transfer-syntaxes-not-supported";
            }
        }
        return String.valueOf(this.result());
    }
}

