/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4cheri.net;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.dcm4che.data.Command;
import org.dcm4che.data.Dataset;
import org.dcm4che.data.DcmDecodeParam;
import org.dcm4che.data.DcmObjectFactory;
import org.dcm4che.dict.DictionaryFactory;
import org.dcm4che.dict.UIDDictionary;
import org.dcm4che.net.DataSource;
import org.dcm4che.net.Dimse;

class DimseImpl
implements Dimse {
    protected static final DcmObjectFactory objFact = DcmObjectFactory.getInstance();
    private final int pcid;
    private final Command cmd;
    private Dataset ds;
    private InputStream in;
    private final DataSource src;
    private String tsUID;
    private static UIDDictionary DICT = DictionaryFactory.getInstance().getDefaultUIDDictionary();

    public DimseImpl(int n, String string, Command command, InputStream inputStream) {
        this.pcid = n;
        this.cmd = command;
        this.ds = null;
        this.src = null;
        this.in = inputStream;
        this.tsUID = string;
    }

    public DimseImpl(int n, Command command, Dataset dataset, DataSource dataSource) {
        this.pcid = n;
        this.cmd = command;
        this.ds = dataset;
        this.src = dataSource;
        this.in = null;
        this.tsUID = null;
        this.cmd.putUS(2048, dataset == null && dataSource == null ? 257 : 0);
    }

    public final int pcid() {
        return this.pcid;
    }

    public final Command getCommand() {
        return this.cmd;
    }

    public final String getTransferSyntaxUID() {
        return this.tsUID;
    }

    final void setTransferSyntaxUID(String string) {
        this.tsUID = string;
    }

    public final Dataset getDataset() throws IOException {
        if (this.ds != null) {
            return this.ds;
        }
        if (this.in == null) {
            return null;
        }
        if (this.tsUID == null) {
            throw new IllegalStateException();
        }
        this.ds = objFact.newDataset();
        this.ds.readDataset(this.in, DcmDecodeParam.valueOf(this.tsUID), -1);
        this.in.close();
        this.in = null;
        return this.ds;
    }

    public final InputStream getDataAsStream() {
        return this.in;
    }

    public void writeTo(OutputStream outputStream, String string) throws IOException {
        if (this.src != null) {
            this.src.writeTo(outputStream, string);
            return;
        }
        if (this.ds == null) {
            throw new IllegalStateException("Missing Dataset");
        }
        this.ds.writeDataset(outputStream, DcmDecodeParam.valueOf(string));
    }

    public String toString() {
        return "[pc-" + this.pcid + "] " + this.cmd.toString();
    }
}

