/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4cheri.net;

import java.io.IOException;
import java.io.OutputStream;
import org.dcm4che.net.AAssociateRJ;
import org.dcm4che.net.PDUException;
import org.dcm4cheri.net.AAbortImpl;
import org.dcm4cheri.net.UnparsedPDUImpl;

final class AAssociateRJImpl
implements AAssociateRJ {
    private final byte[] buf;

    static AAssociateRJImpl parse(UnparsedPDUImpl unparsedPDUImpl) throws PDUException {
        if (unparsedPDUImpl.length() != 4) {
            throw new PDUException("Illegal A-ASSOCIATE-RJ " + unparsedPDUImpl, new AAbortImpl(2, 6));
        }
        return new AAssociateRJImpl(unparsedPDUImpl.buffer());
    }

    private AAssociateRJImpl(byte[] byArray) {
        this.buf = byArray;
    }

    AAssociateRJImpl(int n, int n2, int n3) {
        this.buf = new byte[]{3, 0, 0, 0, 0, 4, 0, (byte)n, (byte)n2, (byte)n3};
    }

    public final int result() {
        return this.buf[7] & 0xFF;
    }

    public final int source() {
        return this.buf[8] & 0xFF;
    }

    public final int reason() {
        return this.buf[9] & 0xFF;
    }

    public void writeTo(OutputStream outputStream) throws IOException {
        outputStream.write(this.buf);
        outputStream.flush();
    }

    public String toString(boolean bl) {
        return this.toString();
    }

    public String toString() {
        return this.toStringBuffer(new StringBuffer()).toString();
    }

    final StringBuffer toStringBuffer(StringBuffer stringBuffer) {
        return stringBuffer.append("A-ASSOCIATE-RJ\n\tresult=").append(this.resultAsString()).append("\n\tsource=").append(this.sourceAsString()).append("\n\treason=").append(this.reasonAsString());
    }

    private String resultAsString() {
        switch (this.result()) {
            case 1: {
                return "1 - rejected-permanent";
            }
            case 2: {
                return "2 - rejected-transient";
            }
        }
        return String.valueOf(this.result());
    }

    private String sourceAsString() {
        switch (this.source()) {
            case 1: {
                return "1 - service-user";
            }
            case 2: {
                return "2 - service-provider (ACSE)";
            }
            case 3: {
                return "3 - service-provider (Presentation)";
            }
        }
        return String.valueOf(this.source());
    }

    private String reasonAsString() {
        switch (this.source()) {
            case 1: {
                switch (this.reason()) {
                    case 1: {
                        return "1 - no-reason-given";
                    }
                    case 2: {
                        return "2 - application-context-name-not-supported";
                    }
                    case 3: {
                        return "3 - calling-AE-title-not-recognized";
                    }
                    case 7: {
                        return "7 - called-AE-title-not-recognizedr";
                    }
                }
            }
            case 2: {
                switch (this.reason()) {
                    case 1: {
                        return "1 - no-reason-given";
                    }
                    case 2: {
                        return "2 - protocol-version-not-supported";
                    }
                }
            }
            case 3: {
                switch (this.reason()) {
                    case 1: {
                        return "1 - temporary-congestion";
                    }
                    case 2: {
                        return "2 - local-limit-exceeded";
                    }
                }
            }
        }
        return String.valueOf(this.reason());
    }
}

