/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4cheri.media;

import java.io.IOException;
import org.dcm4che.data.Dataset;
import org.dcm4che.data.DcmElement;
import org.dcm4che.data.DcmObjectFactory;
import org.dcm4che.data.DcmParser;
import org.dcm4che.data.DcmValueException;
import org.dcm4che.media.DirRecord;

final class DirRecordImpl
implements DirRecord {
    private static final DcmObjectFactory factory = DcmObjectFactory.getInstance();
    final DcmParser parser;
    final Dataset dataset;
    final String type;
    final int next;
    final int lower;
    final int inUse;
    final String[] refFileIDs;
    final String refSOPClassUID;
    final String refSOPInstanceUID;
    final String refTransferSyntaxUID;
    final long inUsePos;
    final long nextValPos;
    final long lowerValPos;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DirRecordImpl(DcmParser dcmParser, int n) throws IOException {
        DcmElement dcmElement;
        this.parser = dcmParser;
        this.dataset = factory.newDataset();
        dcmParser.seek((long)n & 0xFFFFFFFFL);
        dcmParser.setDcmHandler(this.dataset.getDcmHandler());
        try {
            dcmParser.parseItemDataset();
            dcmElement = null;
            dcmParser.setDcmHandler(null);
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            dcmParser.setDcmHandler(null);
            throw throwable;
        }
        this.type = this.dataset.getString(267312, null);
        if (this.type == null) {
            throw new DcmValueException("Missing Directory Record Type");
        }
        DcmElement dcmElement2 = this.dataset.get(267264);
        if (dcmElement2 == null || dcmElement2.isEmpty()) {
            throw new DcmValueException("Missing Offset of Referenced Next Directory Record");
        }
        this.next = dcmElement2.getInt();
        this.nextValPos = dcmElement2.getStreamPosition() + 8L;
        dcmElement = this.dataset.get(267280);
        if (dcmElement == null || dcmElement.isEmpty()) {
            throw new DcmValueException("Missing Record In-use Flag");
        }
        this.inUse = dcmElement.getInt();
        this.inUsePos = dcmElement.getStreamPosition() + 8L;
        DcmElement dcmElement3 = this.dataset.get(267296);
        if (dcmElement3 == null || dcmElement3.isEmpty()) {
            throw new DcmValueException("Missing Offset of Referenced Lower-Level Directory Entity");
        }
        this.lower = dcmElement3.getInt();
        this.lowerValPos = dcmElement3.getStreamPosition() + 8L;
        this.refFileIDs = this.dataset.getStrings(267520);
        this.refSOPClassUID = this.dataset.getString(267536, null);
        this.refSOPInstanceUID = this.dataset.getString(267537, null);
        this.refTransferSyntaxUID = this.dataset.getString(267538, null);
    }

    public Dataset getDataset() {
        return this.dataset;
    }

    public String getType() {
        return this.type;
    }

    public int getInUseFlag() {
        return this.inUse;
    }

    public String[] getRefFileIDs() {
        return this.refFileIDs;
    }

    public String getRefSOPClassUID() {
        return this.refSOPClassUID;
    }

    public String getRefSOPInstanceUID() {
        return this.refSOPInstanceUID;
    }

    public String getRefSOPTransferSyntaxUID() {
        return this.refTransferSyntaxUID;
    }

    public String toString() {
        return "DirRecord[inUse:" + this.inUse + ",type:" + this.type + ",next: " + this.next + ",lower: " + this.lower + "]";
    }

    public DirRecord getNextSibling(boolean bl) throws IOException {
        if (this.next == 0) {
            return null;
        }
        DirRecordImpl dirRecordImpl = new DirRecordImpl(this.parser, this.next);
        if (bl && dirRecordImpl.getInUseFlag() == 0) {
            return dirRecordImpl.getNextSibling(bl);
        }
        return dirRecordImpl;
    }

    public DirRecord getFirstChild(boolean bl) throws IOException {
        if (this.lower == 0) {
            return null;
        }
        DirRecordImpl dirRecordImpl = new DirRecordImpl(this.parser, this.lower);
        if (bl && dirRecordImpl.getInUseFlag() == 0) {
            return dirRecordImpl.getNextSibling(bl);
        }
        return dirRecordImpl;
    }
}

