/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4cheri.imageio.plugins;

import java.io.IOException;
import java.util.Locale;
import javax.imageio.ImageReader;
import javax.imageio.spi.ImageReaderSpi;
import javax.imageio.stream.ImageInputStream;
import org.dcm4che.data.DcmParser;
import org.dcm4cheri.imageio.plugins.DcmImageReader;
import org.dcm4cheri.imageio.plugins.DcmImageReaderConf;

public class DcmImageReaderSpi
extends ImageReaderSpi {
    static final String vendorName = "TIANI MEDGRAPH AG";
    static final String version = "1.0";
    static final String[] names = new String[]{"DICOM"};
    static final String[] suffixes = new String[]{"dcm"};
    static final String[] MIMETypes = new String[]{"Application/dicom"};
    static final String readerClassName = "org.dcm4cheri.imageio.plugins.DcmImageReader";
    private static final String[] writerSpiNames = null;
    static final boolean supportsStandardStreamMetadataFormat = false;
    static final String nativeStreamMetadataFormatName = "dcm4che_imageio_dicom_1.0";
    static final String nativeStreamMetadataFormatClassName = "org.dcm4che.imageio.plugins.DcmMetadataFormat";
    static final DcmImageReaderConf conf = DcmImageReaderConf.getInstance();
    static final boolean supportsStandardImageMetadataFormat = false;
    static final String nativeImageMetadataFormatName = null;
    static final String nativeImageMetadataFormatClassName = null;
    static final String[] extraImageMetadataFormatNames = null;
    static final String[] extraImageMetadataFormatClassNames = null;

    public DcmImageReaderSpi() {
        super(vendorName, version, names, suffixes, MIMETypes, readerClassName, ImageReaderSpi.STANDARD_INPUT_TYPE, writerSpiNames, false, nativeStreamMetadataFormatName, nativeStreamMetadataFormatClassName, conf.getExtraStreamMetadataFormatNames(), conf.getExtraStreamMetadataFormatClassNames(), false, nativeImageMetadataFormatName, nativeImageMetadataFormatClassName, extraImageMetadataFormatNames, extraImageMetadataFormatClassNames);
    }

    public String getDescription(Locale locale) {
        return "DICOM image reader";
    }

    public boolean canDecodeInput(Object object) throws IOException {
        if (!(object instanceof ImageInputStream)) {
            return false;
        }
        DcmParser dcmParser = DcmImageReader.pfact.newDcmParser((ImageInputStream)object);
        return dcmParser.detectFileFormat() != null;
    }

    public ImageReader createReaderInstance(Object object) {
        return new DcmImageReader(this);
    }
}

