/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4cheri.imageio.plugins;

import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import java.util.StringTokenizer;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.transform.Templates;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.sax.SAXTransformerFactory;
import javax.xml.transform.sax.TransformerHandler;
import javax.xml.transform.stream.StreamSource;
import org.dcm4che.data.Dataset;
import org.dcm4che.data.DcmObjectFactory;

final class DcmImageReaderConf {
    private static DcmImageReaderConf instance = new DcmImageReaderConf();
    private final ClassLoader classloader;
    private String[] extraStreamMetadataFormatNames;
    private List formatNameList;
    private String[] extraStreamMetadataFormatClassNames;
    private String[] extraStreamMetadataFormatFilterResource;
    private String[] extraStreamMetadataFormatStyleResource;
    private Dataset[] datasetFilter;
    private Templates[] transformerTemplates;

    public static DcmImageReaderConf getInstance() {
        return instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private DcmImageReaderConf() {
        Object object2222;
        Properties properties;
        block12: {
            this.extraStreamMetadataFormatNames = null;
            this.formatNameList = Collections.EMPTY_LIST;
            this.extraStreamMetadataFormatClassNames = null;
            this.extraStreamMetadataFormatFilterResource = null;
            this.extraStreamMetadataFormatStyleResource = null;
            this.datasetFilter = null;
            this.transformerTemplates = null;
            this.classloader = Thread.currentThread().getContextClassLoader();
            String string = System.getProperty("dcm4cheri.imageio.plugins.DcmImageReader.config", "DcmImageReader.properties");
            InputStream inputStream = this.classloader.getResourceAsStream(string);
            if (inputStream == null) {
                return;
            }
            properties = new Properties();
            properties.load(inputStream);
            Object var6_4 = null;
            try {
                inputStream.close();
            }
            catch (IOException object2222) {}
            break block12;
            {
                catch (IOException iOException) {
                    iOException.printStackTrace();
                    Object var6_5 = null;
                    try {
                        inputStream.close();
                    }
                    catch (IOException iOException2) {
                        // empty catch block
                    }
                    return;
                }
            }
            catch (Throwable throwable) {
                Object var6_6 = null;
                try {
                    inputStream.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                throw throwable;
            }
        }
        StringTokenizer stringTokenizer = new StringTokenizer(properties.getProperty("extraStreamMetadataFormatNames", ""), " ,\t");
        int n = stringTokenizer.countTokens();
        if (n == 0) {
            return;
        }
        this.extraStreamMetadataFormatNames = new String[n];
        this.extraStreamMetadataFormatClassNames = new String[n];
        this.extraStreamMetadataFormatFilterResource = new String[n];
        this.extraStreamMetadataFormatStyleResource = new String[n];
        int n2 = 0;
        while (n2 < n) {
            this.extraStreamMetadataFormatNames[n2] = object2222 = stringTokenizer.nextToken();
            this.extraStreamMetadataFormatClassNames[n2] = properties.getProperty((String)object2222 + ".class");
            this.extraStreamMetadataFormatFilterResource[n2] = properties.getProperty((String)object2222 + ".filter");
            this.extraStreamMetadataFormatStyleResource[n2] = properties.getProperty((String)object2222 + ".style");
            ++n2;
        }
        this.formatNameList = Arrays.asList(this.extraStreamMetadataFormatNames);
        this.datasetFilter = new Dataset[n];
        this.transformerTemplates = new Templates[n];
    }

    public String[] getExtraStreamMetadataFormatNames() {
        return this.extraStreamMetadataFormatNames;
    }

    public String[] getExtraStreamMetadataFormatClassNames() {
        return this.extraStreamMetadataFormatClassNames;
    }

    public boolean contains(String string) {
        return this.formatNameList.indexOf(string) != -1;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Dataset getFilterDataset(String string) {
        int n = this.formatNameList.indexOf(string);
        if (n == -1) return null;
        if (this.extraStreamMetadataFormatFilterResource[n] == null) {
            return null;
        }
        if (this.datasetFilter[n] != null) {
            return this.datasetFilter[n];
        }
        InputStream inputStream = this.classloader.getResourceAsStream(this.extraStreamMetadataFormatFilterResource[n]);
        if (inputStream == null) {
            throw new ConfigurationError("Could not open resource " + this.extraStreamMetadataFormatFilterResource[n], null);
        }
        try {
            try {
                Dataset dataset = DcmObjectFactory.getInstance().newDataset();
                SAXParser sAXParser = SAXParserFactory.newInstance().newSAXParser();
                sAXParser.parse(inputStream, dataset.getSAXHandler());
                Dataset dataset2 = this.datasetFilter[n] = dataset;
                Object var8_8 = null;
                try {
                    inputStream.close();
                    return dataset2;
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                return dataset2;
            }
            catch (Exception exception) {
                throw new ConfigurationError("Could not parse resource " + this.extraStreamMetadataFormatFilterResource[n], exception);
            }
        }
        catch (Throwable throwable) {
            Object var8_9 = null;
            try {}
            catch (IOException iOException) {
                throw throwable;
            }
            inputStream.close();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TransformerHandler getTransformerHandler(String string) {
        int n = this.formatNameList.indexOf(string);
        if (n == -1 || this.extraStreamMetadataFormatStyleResource[n] == null) {
            return null;
        }
        try {
            SAXTransformerFactory sAXTransformerFactory = (SAXTransformerFactory)TransformerFactory.newInstance();
            if (this.transformerTemplates[n] == null) {
                InputStream inputStream = this.classloader.getResourceAsStream(this.extraStreamMetadataFormatStyleResource[n]);
                if (inputStream == null) {
                    throw new ConfigurationError("Could not open resource " + this.extraStreamMetadataFormatStyleResource[n], null);
                }
                try {
                    this.transformerTemplates[n] = sAXTransformerFactory.newTemplates(new StreamSource(inputStream));
                    Object var6_6 = null;
                }
                catch (Throwable throwable) {
                    Object var6_7 = null;
                    try {
                        inputStream.close();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    throw throwable;
                }
                try {
                    inputStream.close();
                }
                catch (IOException iOException) {}
            }
            return sAXTransformerFactory.newTransformerHandler(this.transformerTemplates[n]);
        }
        catch (Exception exception) {
            throw new ConfigurationError("Could not parse resource " + this.extraStreamMetadataFormatStyleResource[n], exception);
        }
    }

    static class ConfigurationError
    extends Error {
        ConfigurationError(String string, Exception exception) {
            super(string, exception);
        }
    }
}

