/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4cheri.hl7;

import java.io.ByteArrayOutputStream;
import org.dcm4cheri.hl7.HL7Fields;

class HL7FieldsImpl
implements HL7Fields {
    protected final byte[] data;
    protected final int off;
    protected final int len;
    protected final byte[] delim;
    protected HL7Fields[] subFields = null;
    static final HL7Fields NULL = new HL7Fields(){

        public String toString() {
            return "";
        }

        public String get(int n) {
            return "";
        }

        public int size() {
            return 0;
        }

        public String get(int[] nArray) {
            return "";
        }

        public int size(int n) {
            return 0;
        }

        public int size(int[] nArray) {
            return 0;
        }

        public void writeTo(ByteArrayOutputStream byteArrayOutputStream) {
        }

        public void writeTo(int n, ByteArrayOutputStream byteArrayOutputStream) {
        }
    };

    static HL7Fields newInstance(byte[] byArray, int n, int n2, byte[] byArray2) {
        return n2 == 0 ? NULL : new HL7FieldsImpl(byArray, n, n2, byArray2);
    }

    public HL7FieldsImpl(byte[] byArray, int n, int n2, byte[] byArray2) {
        if (byArray.length < n + n2) {
            throw new IllegalArgumentException("data.length[" + byArray.length + "] < off[" + n + "] + len [" + n2 + "]");
        }
        if (byArray2.length == 0) {
            throw new IllegalArgumentException("delim.length == 0");
        }
        this.data = byArray;
        this.off = n;
        this.len = n2;
        this.delim = byArray2;
    }

    public int size() {
        this.initSubFields();
        return this.subFields.length;
    }

    public int size(int n) {
        if (this.delim.length == 0) {
            throw new IllegalArgumentException("delim.length == 0");
        }
        this.initSubFields();
        return n < this.subFields.length ? this.subFields[n].size() : 0;
    }

    public int size(int[] nArray) {
        if (nArray.length > this.delim.length) {
            throw new IllegalArgumentException("index.length[" + nArray.length + "] > delim.length[" + this.delim.length + "]");
        }
        switch (nArray.length) {
            case 0: {
                return this.size();
            }
            case 1: {
                return this.size(nArray[0]);
            }
        }
        this.initSubFields();
        if (nArray[0] >= this.subFields.length) {
            return 0;
        }
        int[] nArray2 = new int[nArray.length - 1];
        System.arraycopy(nArray, 1, nArray2, 0, nArray2.length);
        return this.subFields[nArray[0]].size(nArray2);
    }

    public void writeTo(ByteArrayOutputStream byteArrayOutputStream) {
        byteArrayOutputStream.write(this.data, this.off, this.len);
    }

    public void writeTo(int n, ByteArrayOutputStream byteArrayOutputStream) {
        this.initSubFields();
        if (n < this.subFields.length) {
            this.subFields[n].writeTo(byteArrayOutputStream);
        }
    }

    public String toString() {
        return new String(this.data, this.off, this.len);
    }

    public String get(int n) {
        if (this.delim.length == 0) {
            throw new IllegalArgumentException("delim.length == 0");
        }
        this.initSubFields();
        return n < this.subFields.length ? this.subFields[n].toString() : "";
    }

    public String get(int[] nArray) {
        if (nArray.length > this.delim.length) {
            throw new IllegalArgumentException("index.length[" + nArray.length + "] > delim.length[" + this.delim.length + "]");
        }
        switch (nArray.length) {
            case 0: {
                return this.toString();
            }
            case 1: {
                return this.get(nArray[0]);
            }
        }
        this.initSubFields();
        if (nArray[0] >= this.subFields.length) {
            return "";
        }
        int[] nArray2 = new int[nArray.length - 1];
        System.arraycopy(nArray, 1, nArray2, 0, nArray2.length);
        return this.subFields[nArray[0]].get(nArray2);
    }

    private void initSubFields() {
        if (this.subFields != null) {
            return;
        }
        int n = 0;
        int n2 = this.off;
        int n3 = this.off + this.len;
        while (n2 < n3) {
            if (this.data[n2] == this.delim[0]) {
                ++n;
            }
            ++n2;
        }
        this.subFields = new HL7Fields[n + 1];
        byte[] byArray = new byte[this.delim.length - 1];
        System.arraycopy(this.delim, 1, byArray, 0, byArray.length);
        n = 0;
        int n4 = this.off;
        int n5 = this.off;
        int n6 = this.off + this.len;
        while (n5 < n6) {
            if (this.data[n5] == this.delim[0]) {
                this.subFields[n++] = HL7FieldsImpl.newInstance(this.data, n4, n5 - n4, byArray);
                n4 = n5 + 1;
            }
            ++n5;
        }
        this.subFields[n] = HL7FieldsImpl.newInstance(this.data, n4, this.off + this.len - n4, byArray);
    }
}

