/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4cheri.dict;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import org.dcm4che.dict.DictionaryFactory;
import org.dcm4che.dict.TagDictionary;
import org.dcm4che.dict.UIDDictionary;
import org.dcm4cheri.dict.TagDictionaryImpl;
import org.dcm4cheri.dict.UIDDictionaryImpl;

public class DictionaryFactoryImpl
extends DictionaryFactory {
    private static final String DEF_TAG_DICT = "org/dcm4cheri/dict/TagDictionary.ser";
    private static final String DEF_UID_DICT = "org/dcm4cheri/dict/UIDDictionary.ser";
    private static TagDictionary defTagDict;
    private static UIDDictionary defUIDDict;

    public TagDictionary newTagDictionary() {
        return new TagDictionaryImpl();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public TagDictionary getDefaultTagDictionary() {
        if (defTagDict != null) {
            return defTagDict;
        }
        DictionaryFactoryImpl dictionaryFactoryImpl = this;
        synchronized (dictionaryFactoryImpl) {
            if (defTagDict != null) {
                return defTagDict;
            }
            ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
            InputStream inputStream = classLoader.getResourceAsStream(DEF_TAG_DICT);
            if (inputStream == null) {
                throw new RuntimeException("Missing org/dcm4cheri/dict/TagDictionary.ser");
            }
            ObjectInputStream objectInputStream = null;
            try {
                try {
                    objectInputStream = new ObjectInputStream(new BufferedInputStream(inputStream));
                    TagDictionary tagDictionary = defTagDict = (TagDictionary)objectInputStream.readObject();
                    Object var8_8 = null;
                    try {
                        (objectInputStream != null ? objectInputStream : inputStream).close();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    return tagDictionary;
                }
                catch (Exception exception) {
                    throw new RuntimeException("Load DefaultTagDictionary from org/dcm4cheri/dict/TagDictionary.ser failed!", exception);
                }
            }
            catch (Throwable throwable) {
                Object var8_9 = null;
                try {}
                catch (IOException iOException) {
                    throw throwable;
                }
                (objectInputStream != null ? objectInputStream : inputStream).close();
                throw throwable;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void initDefTagDict(File file, File file2) throws Exception {
        TagDictionaryImpl tagDictionaryImpl = new TagDictionaryImpl();
        tagDictionaryImpl.load(file);
        file2.getParentFile().mkdirs();
        ObjectOutputStream objectOutputStream = new ObjectOutputStream(new BufferedOutputStream(new FileOutputStream(file2)));
        try {
            objectOutputStream.writeObject(tagDictionaryImpl);
            System.out.println("Create: " + file2);
            Object var5_4 = null;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            objectOutputStream.close();
            throw throwable;
        }
        objectOutputStream.close();
    }

    public UIDDictionary newUIDDictionary() {
        return new UIDDictionaryImpl();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public UIDDictionary getDefaultUIDDictionary() {
        if (defUIDDict != null) {
            return defUIDDict;
        }
        DictionaryFactoryImpl dictionaryFactoryImpl = this;
        synchronized (dictionaryFactoryImpl) {
            if (defUIDDict != null) {
                return defUIDDict;
            }
            ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
            InputStream inputStream = classLoader.getResourceAsStream(DEF_UID_DICT);
            if (inputStream == null) {
                throw new RuntimeException("Missing org/dcm4cheri/dict/UIDDictionary.ser");
            }
            ObjectInputStream objectInputStream = null;
            try {
                try {
                    objectInputStream = new ObjectInputStream(new BufferedInputStream(inputStream));
                    UIDDictionary uIDDictionary = defUIDDict = (UIDDictionary)objectInputStream.readObject();
                    Object var8_8 = null;
                    try {
                        (objectInputStream != null ? objectInputStream : inputStream).close();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    return uIDDictionary;
                }
                catch (Exception exception) {
                    throw new RuntimeException("Load DefaultUIDDictionary from org/dcm4cheri/dict/UIDDictionary.ser failed!", exception);
                }
            }
            catch (Throwable throwable) {
                Object var8_9 = null;
                try {}
                catch (IOException iOException) {
                    throw throwable;
                }
                (objectInputStream != null ? objectInputStream : inputStream).close();
                throw throwable;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void initDefUIDDict(File file, File file2) throws Exception {
        UIDDictionaryImpl uIDDictionaryImpl = new UIDDictionaryImpl();
        uIDDictionaryImpl.load(file);
        file2.getParentFile().mkdirs();
        ObjectOutputStream objectOutputStream = new ObjectOutputStream(new BufferedOutputStream(new FileOutputStream(file2)));
        try {
            objectOutputStream.writeObject(uIDDictionaryImpl);
            System.out.println("Create: " + file2);
            Object var5_4 = null;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            objectOutputStream.close();
            throw throwable;
        }
        objectOutputStream.close();
    }

    public static void main(String[] stringArray) throws Exception {
        if (stringArray.length != 2) {
            System.out.println("Usage: java -cp <classpath> org/dcm4cheri/dict/DictionaryFactoryImpl \\\n  <dictionary.xml> <resdir>");
            System.exit(1);
        }
        File file = new File(stringArray[1]);
        DictionaryFactoryImpl.initDefTagDict(new File(stringArray[0]), new File(file, DEF_TAG_DICT));
        DictionaryFactoryImpl.initDefUIDDict(new File(stringArray[0]), new File(file, DEF_UID_DICT));
    }
}

