/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4cheri.data;

import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.NoSuchElementException;
import javax.imageio.stream.ImageInputStream;
import org.dcm4che.data.Dataset;
import org.dcm4che.data.DcmDecodeParam;
import org.dcm4che.data.DcmElement;
import org.dcm4che.data.DcmHandler;
import org.dcm4che.data.FileFormat;
import org.dcm4che.dict.Tags;
import org.dcm4cheri.data.BaseDatasetImpl;
import org.dcm4cheri.data.DcmObjectImpl;
import org.dcm4cheri.data.FilterSQElement;
import org.dcm4cheri.data.SQElement;
import org.xml.sax.helpers.DefaultHandler;

abstract class FilterDataset
extends BaseDatasetImpl
implements Dataset {
    protected final BaseDatasetImpl backend;

    public FilterDataset(Dataset dataset) {
        this.backend = (BaseDatasetImpl)dataset;
    }

    protected abstract boolean filter(int var1);

    public Iterator iterator() {
        final Iterator iterator = this.backend.iterator();
        return new Iterator(){
            private DcmElement next = this.findNext();

            private DcmElement findNext() {
                while (iterator.hasNext()) {
                    DcmElement dcmElement = (DcmElement)iterator.next();
                    if (!FilterDataset.this.filter(dcmElement.tag())) continue;
                    return dcmElement;
                }
                return null;
            }

            public boolean hasNext() {
                return this.next != null;
            }

            public Object next() {
                if (this.next == null) {
                    throw new NoSuchElementException();
                }
                DcmElement dcmElement = this.next;
                this.next = this.findNext();
                return dcmElement;
            }

            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    public boolean isEmpty() {
        return this.size() == 0;
    }

    public Charset getCharset() {
        return this.backend.getCharset();
    }

    public Dataset getParent() {
        return this.backend.getParent();
    }

    public long getItemOffset() {
        return this.backend.getItemOffset();
    }

    public DcmHandler getDcmHandler() {
        throw new UnsupportedOperationException();
    }

    public DefaultHandler getSAXHandler() {
        throw new UnsupportedOperationException();
    }

    protected DcmElement put(DcmElement dcmElement) {
        if (!this.filter(dcmElement.tag())) {
            throw new IllegalArgumentException("" + dcmElement + " does not fit in this sub DataSet");
        }
        return this.backend.put(dcmElement);
    }

    public DcmElement remove(int n) {
        return this.filter(n) ? this.backend.remove(n) : null;
    }

    public void clear() {
        ArrayList<DcmElement> arrayList = new ArrayList<DcmElement>();
        Iterator iterator = this.backend.iterator();
        while (iterator.hasNext()) {
            DcmElement dcmElement = (DcmElement)iterator.next();
            if (!this.filter(dcmElement.tag())) continue;
            arrayList.add(dcmElement);
        }
        int n = 0;
        int n2 = arrayList.size();
        while (n < n2) {
            this.backend.remove(((DcmElement)arrayList.get(n)).tag());
            ++n;
        }
    }

    public Dataset setItemOffset(long l) {
        throw new UnsupportedOperationException();
    }

    public void readDataset(InputStream inputStream, DcmDecodeParam dcmDecodeParam, int n) throws IOException {
        throw new UnsupportedOperationException();
    }

    public void readFile(InputStream inputStream, FileFormat fileFormat, int n) throws IOException {
        throw new UnsupportedOperationException();
    }

    public void readFile(ImageInputStream imageInputStream, FileFormat fileFormat, int n) throws IOException {
        throw new UnsupportedOperationException();
    }

    static final class Segment
    extends FilterDataset {
        private long fromTag;
        private long toTag;

        Segment(Dataset dataset, int n, int n2) {
            super(dataset);
            this.fromTag = (long)n & 0xFFFFFFFFL;
            this.toTag = (long)n2 & 0xFFFFFFFFL;
            if (this.fromTag > this.toTag) {
                throw new IllegalArgumentException("fromTag:" + Tags.toString(n) + " greater toTag:" + Tags.toString(n2));
            }
        }

        public int size() {
            int n = 0;
            Iterator iterator = this.backend.iterator();
            while (iterator.hasNext()) {
                long l = (long)((DcmElement)iterator.next()).tag() & 0xFFFFFFFFL;
                if (l < this.fromTag) continue;
                if (l >= this.toTag) break;
                ++n;
            }
            return n;
        }

        protected boolean filter(int n) {
            long l = n & 0xFFFFFFFF;
            return l >= this.fromTag && l < this.toTag;
        }

        public DcmElement get(int n) {
            return this.filter(n) ? this.backend.get(n) : null;
        }
    }

    static final class Selection
    extends FilterDataset {
        private final Dataset filter;

        Selection(Dataset dataset, Dataset dataset2) {
            super(dataset);
            this.filter = dataset2;
        }

        public int size() {
            if (this.filter == null) {
                return this.backend.size();
            }
            int n = 0;
            Iterator iterator = this.iterator();
            while (iterator.hasNext()) {
                iterator.next();
                ++n;
            }
            return n;
        }

        protected boolean filter(int n) {
            return this.filter == null || this.filter.contains(n);
        }

        public boolean contains(int n) {
            return this.filter(n) && this.backend.contains(n);
        }

        public DcmElement get(int n) {
            if (this.filter == null) {
                return this.backend.get(n);
            }
            DcmElement dcmElement = this.filter.get(n);
            if (dcmElement == null) {
                return null;
            }
            DcmElement dcmElement2 = this.backend.get(n);
            if (!(dcmElement2 instanceof SQElement)) {
                return dcmElement2;
            }
            if (!(dcmElement instanceof SQElement)) {
                DcmObjectImpl.log.warn("VR mismatch - dataset:" + dcmElement2 + ", filter:" + dcmElement);
                return dcmElement2;
            }
            if (dcmElement.isEmpty()) {
                return dcmElement2;
            }
            return new FilterSQElement((SQElement)dcmElement2, dcmElement.getItem());
        }
    }
}

