/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4cheri.data;

import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import javax.imageio.stream.ImageOutputStream;
import org.dcm4che.data.DcmDecodeParam;
import org.dcm4che.data.DcmHandler;
import org.dcm4che.dict.VRs;
import org.dcm4cheri.data.FileMetaInfoImpl;

class DcmStreamHandlerImpl
implements DcmHandler {
    private static final int ITEM_TAG = -73728;
    private static final int ITEM_DELIMITATION_ITEM_TAG = -73715;
    private static final int SEQ_DELIMITATION_ITEM_TAG = -73507;
    private final byte[] b12 = new byte[12];
    private final ByteBuffer bb12 = ByteBuffer.wrap(this.b12).order(ByteOrder.LITTLE_ENDIAN);
    private boolean explicitVR = false;
    private int tag = 0;
    private int vr = 0;
    private DataOutput out;

    public DcmStreamHandlerImpl(OutputStream outputStream) {
        this.out = outputStream instanceof DataOutput ? (DataOutput)((Object)outputStream) : new DataOutputStream(outputStream);
    }

    public DcmStreamHandlerImpl(ImageOutputStream imageOutputStream) {
        this.out = imageOutputStream;
    }

    public void startCommand() {
    }

    public void endCommand() {
    }

    public void startDcmFile() {
    }

    public void endDcmFile() {
    }

    public void startFileMetaInfo(byte[] byArray) throws IOException {
        if (byArray != null) {
            this.out.write(byArray, 0, 128);
            this.out.write(FileMetaInfoImpl.DICM_PREFIX, 0, 4);
        }
    }

    public void endFileMetaInfo() {
    }

    public void startDataset() {
    }

    public void endDataset() {
    }

    public void setDcmDecodeParam(DcmDecodeParam dcmDecodeParam) {
        this.bb12.order(dcmDecodeParam.byteOrder);
        this.explicitVR = dcmDecodeParam.explicitVR;
    }

    public int writeHeader(int n, int n2, int n3) throws IOException {
        this.bb12.clear();
        this.bb12.putShort((short)(n >>> 16));
        this.bb12.putShort((short)n);
        if (!this.explicitVR || n2 == 0) {
            this.bb12.putInt(n3);
            this.out.write(this.b12, 0, 8);
            return 8;
        }
        this.bb12.put((byte)(n2 >>> 8));
        this.bb12.put((byte)n2);
        if (VRs.isLengthField16Bit(n2)) {
            this.bb12.putShort((short)n3);
            this.out.write(this.b12, 0, 8);
            return 8;
        }
        this.bb12.put((byte)0);
        this.bb12.put((byte)0);
        this.bb12.putInt(n3);
        this.out.write(this.b12, 0, 12);
        return 12;
    }

    public void startElement(int n, int n2, long l) throws IOException {
        this.tag = n;
        this.vr = n2;
    }

    public void endElement() throws IOException {
    }

    public void startSequence(int n) throws IOException {
        this.writeHeader(this.tag, this.vr, n);
    }

    public void endSequence(int n) throws IOException {
        if (n == -1) {
            this.writeHeader(-73507, 0, 0);
        }
    }

    public void startItem(int n, long l, int n2) throws IOException {
        this.writeHeader(-73728, 0, n2);
    }

    public void endItem(int n) throws IOException {
        if (n == -1) {
            this.writeHeader(-73715, 0, 0);
        }
    }

    public void value(byte[] byArray, int n, int n2) throws IOException {
        this.writeHeader(this.tag, this.vr, n2 + 1 & 0xFFFFFFFE);
        this.out.write(byArray, n, n2);
        if ((n2 & 1) != 0) {
            this.out.write(VRs.getPadding(this.vr));
        }
    }

    public void fragment(int n, long l, byte[] byArray, int n2, int n3) throws IOException {
        this.writeHeader(-73728, 0, n3 + 1 & 0xFFFFFFFE);
        this.value(byArray, n2, n3);
    }
}

